/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.web;

import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.entity.Zd;
import cn.gtmap.landtax.model.ResponseObject;
import cn.gtmap.landtax.model.dictionary.Gtlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.query.SjgjQuery;
import cn.gtmap.landtax.service.SjgjService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sjgj"})
public class SjgjController {
    @Autowired
    private SjgjService sjgjService;
    @Autowired
    BaseRepository baseRepository;

    @RequestMapping(value={"list"})
    public String zdList(Model model) {
        return "landtax/sjgj/sjgj";
    }

    @RequestMapping(value={"syJson"})
    @ResponseBody
    public Page syJson(Model model, Pageable pageable, SjgjQuery sjgjQuery) {
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        Page page = null;
        String zlField = "";
        String zhField = "";
        if (sjgjQuery.getSylx() == null || sjgjQuery.getSylx().equals("1")) {
            queryConditionList.add(new QueryCondition("swDjTd.tdId is not null"));
            zlField = "swDjTd.tdzl";
            zhField = "swDjTd.tdsyzh";
        } else if (sjgjQuery.getSylx().equals("2")) {
            queryConditionList.add(new QueryCondition("swDjFc.fcId is not null"));
            zlField = "swDjFc.fczl";
            zhField = "swDjFc.fczh";
        } else {
            if (StringUtils.isNotEmpty((String)sjgjQuery.getGlbm())) {
                queryConditionList.add(new QueryCondition("swDjJbb.glbm", "llike", (Object)sjgjQuery.getGlbm()));
            }
            queryConditionList.add(new QueryCondition("sgztDm", "=", (Object)"06"));
            sjgjQuery.setTdzl(null);
            sjgjQuery.setZh(null);
        }
        String gjfs = sjgjQuery.getGjfs();
        if (gjfs == null) {
            gjfs = "1";
            sjgjQuery.setMc("1");
        }
        if (gjfs.equals("1")) {
            page = this.sjgjService.getZdppSyPage(sjgjQuery, pageable);
        } else if (gjfs.equals("2")) {
            if (StringUtils.isNotEmpty((String)sjgjQuery.getMc())) {
                queryConditionList.add(new QueryCondition("swDjJbb.nsrmc", "like", (Object)sjgjQuery.getMc()));
            }
            if (StringUtils.isNotEmpty((String)sjgjQuery.getTdzl())) {
                queryConditionList.add(new QueryCondition(zlField, "like", (Object)sjgjQuery.getTdzl()));
            }
            if (StringUtils.isNotEmpty((String)sjgjQuery.getZh())) {
                queryConditionList.add(new QueryCondition(zhField, "like", (Object)sjgjQuery.getZh()));
            }
            queryConditionList.add(new QueryCondition("sjly", "=", (Object)"0"));
            page = this.sjgjService.getSyPage(queryConditionList, pageable, sjgjQuery.getSylx());
        } else if (gjfs.equals("0")) {
            if (StringUtils.isNotEmpty((String)sjgjQuery.getMc())) {
                queryConditionList.add(new QueryCondition("swDjJbb.nsrmc", "like", (Object)sjgjQuery.getMc()));
            }
            if (StringUtils.isNotEmpty((String)sjgjQuery.getTdzl())) {
                queryConditionList.add(new QueryCondition(zlField, "like", (Object)sjgjQuery.getTdzl()));
            }
            if (StringUtils.isNotEmpty((String)sjgjQuery.getZh())) {
                queryConditionList.add(new QueryCondition(zhField, "like", (Object)sjgjQuery.getZh()));
            }
            queryConditionList.add(new QueryCondition("sjly in ('1', '2')"));
            page = this.sjgjService.getSyPage(queryConditionList, pageable, sjgjQuery.getSylx());
        }
        return page;
    }

    @RequestMapping(value={"zdJson"})
    @ResponseBody
    public Page zdJson(Model model, Pageable pageable, SjgjQuery sjgjQuery) {
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        String gjfs = sjgjQuery.getGjfs();
        if (StringUtils.isEmpty((String)gjfs)) {
            queryConditionList.add(new QueryCondition(" 1=2 "));
        } else if (gjfs.equals("1")) {
            if (StringUtils.isNotEmpty((String)sjgjQuery.getMc())) {
                queryConditionList.add(new QueryCondition("qlrmc", "=", (Object)sjgjQuery.getMc()));
            }
            if (StringUtils.isNotEmpty((String)sjgjQuery.getTdzl())) {
                queryConditionList.add(new QueryCondition("tdzl", "=", (Object)sjgjQuery.getTdzl()));
            }
            if (StringUtils.isNotEmpty((String)sjgjQuery.getZh())) {
                queryConditionList.add(new QueryCondition("tdzh", "=", (Object)sjgjQuery.getZh()));
            }
        } else if (gjfs.equals("2")) {
            if (StringUtils.isNotEmpty((String)sjgjQuery.getMc())) {
                queryConditionList.add(new QueryCondition("qlrmc", "like", (Object)sjgjQuery.getMc()));
            }
            if (StringUtils.isNotEmpty((String)sjgjQuery.getTdzl())) {
                queryConditionList.add(new QueryCondition("tdzl", "like", (Object)sjgjQuery.getTdzl()));
            }
            if (StringUtils.isNotEmpty((String)sjgjQuery.getZh())) {
                queryConditionList.add(new QueryCondition("tdzh", "like", (Object)sjgjQuery.getZh()));
            }
        } else if (gjfs.equals("0")) {
            queryConditionList.add(new QueryCondition("djh", "=", (Object)sjgjQuery.getDjh()));
        }
        return this.sjgjService.getZdPage(queryConditionList, pageable, sjgjQuery.getSylx());
    }

    @RequestMapping(value={"doGj"})
    @ResponseBody
    public Object doGj(Model model, String syId, String djh, String gjfs, String sylx) {
        ResponseMessage responseMessage = new ResponseMessage();
        String msg = "";
        SwDjSy swDjSy = (SwDjSy)this.baseRepository.get(SwDjSy.class, (Object)syId);
        if (swDjSy != null) {
            swDjSy.setSjly(gjfs);
            swDjSy.setUpdateRq(new Date());
            if (StringUtils.isEmpty((String)gjfs)) {
                msg = "\u672a\u6307\u5b9a\u6302\u63a5\u65b9\u5f0f\uff01";
            } else if (gjfs.equals("1") || gjfs.equals("2")) {
                Zd zd = new Zd();
                zd.setDjh(djh);
                swDjSy.setZd(zd);
                swDjSy.setGtly(Gtlx.ZD.toString());
                this.sjgjService.updateSwdjSy(swDjSy, sylx);
                msg = "\u6302\u63a5\u6210\u529f\uff01";
            } else if (gjfs.equals("0")) {
                swDjSy.setGtly(null);
                swDjSy.setZd(null);
                this.sjgjService.updateSwdjSy(swDjSy, sylx);
                msg = "\u53d6\u6d88\u6302\u63a5\u6210\u529f\uff01";
            } else if (gjfs.equals("4")) {
                this.sjgjService.updateSwdjSy(swDjSy, sylx);
                msg = "\u6807\u8bb0\u65e0\u6cd5\u6302\u63a5\u6210\u529f\uff01";
            } else {
                msg = "\u672a\u77e5\u6302\u63a5\u65b9\u5f0f\uff08" + gjfs + "\uff09\uff01";
            }
        } else {
            msg = "\u672a\u627e\u5230\u7a0e\u6e90\u4fe1\u606f\uff01";
        }
        responseMessage.setMsg(msg);
        return responseMessage;
    }

    @RequestMapping(value={"initData"})
    public String initData(Model model) {
        return "landtax/sjgj/initData";
    }

    @RequestMapping(value={"excuteSqlFile"})
    @ResponseBody
    public Object excuteSqlFile(Model model, String filePath, Long pos) {
        ResponseObject ro = new ResponseObject();
        try {
            this.sjgjService.excuteSqlFile(filePath, pos.longValue(), ro);
        }
        catch (Exception e) {
            // empty catch block
        }
        return ro;
    }
}

