/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.web;

import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.service.DicService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/dic"})
public class DicController {
    @Autowired
    DicService dicService;

    @RequestMapping(value={""})
    @ResponseBody
    public Object getDicMap(Model model, String name) throws Exception {
        HashMap dicMap = Maps.newHashMap();
        if (StringUtils.isNotBlank((String)name)) {
            String[] tmpDicNames;
            for (String tmpDicName : tmpDicNames = StringUtils.split((String)name, (String)",")) {
                dicMap.put(tmpDicName, this.dicService.buildEnumMap(tmpDicName));
            }
        }
        return dicMap;
    }

    @RequestMapping(value={"getNameByDm"})
    @ResponseBody
    public Object getNameByDm(Model model, String dicName, String dm) throws Exception {
        ResponseMessage responseMessage = new ResponseMessage();
        String mc = this.dicService.findMcByDm(dicName, dm);
        responseMessage.setMsg(mc);
        return responseMessage;
    }
}

