/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.SwDjFc;
import cn.gtmap.landtax.entity.SwDjFcHis;
import cn.gtmap.landtax.entity.SwDjFcTemp;
import cn.gtmap.landtax.entity.SwDjJbb;
import cn.gtmap.landtax.entity.SwDjJbbHis;
import cn.gtmap.landtax.entity.SwDjJbbTemp;
import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.entity.SwDjSyHis;
import cn.gtmap.landtax.entity.SwDjSyTemp;
import cn.gtmap.landtax.entity.SwDjTd;
import cn.gtmap.landtax.entity.SwDjTdHis;
import cn.gtmap.landtax.entity.SwDjTdTemp;
import cn.gtmap.landtax.entity.Zd;
import cn.gtmap.landtax.model.dictionary.Czlx;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaxServiceImpl
implements TaxService {
    @Autowired
    BaseRepository baseRepository;

    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    public Page<SwDjSy> findSwdjTdMap(SwDjSyQuery swDjSyQuery, Pageable pageable) {
        List list = this.addParameter(swDjSyQuery);
        list.add(new QueryCondition("swDjTd.tdId is not null"));
        return this.baseRepository.find(SwDjSy.class, list, null, pageable);
    }

    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    public Page<SwDjSy> findSwdjFcMap(SwDjSyQuery swDjSyQuery, Pageable pageable) {
        List list = this.addParameter(swDjSyQuery);
        list.add(new QueryCondition("swDjFc.fcId is not null"));
        return this.baseRepository.find(SwDjSy.class, list, null, pageable);
    }

    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    public SwDjJbb findSwDjJbbByGlbm(String glbm) {
        String jpql = "from SwDjJbb where glbm=?0";
        List list = this.baseRepository.getByJpql(jpql, new Object[]{glbm});
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (SwDjJbb)list.get(0);
        }
        return null;
    }

    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    public SwDjJbbTemp findSwDjJbbTempByGlbm(String glbm) {
        String jpql = "from SwDjJbbTemp where glbm=?0";
        List list = this.baseRepository.getByJpql(jpql, new Object[]{glbm});
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (SwDjJbbTemp)list.get(0);
        }
        return null;
    }

    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    public SwDjJbb findSwDjJbbById(String jbbId) {
        return (SwDjJbb)this.baseRepository.get(SwDjJbb.class, (Object)jbbId);
    }

    @Transactional
    public void updateSwDjSy(SwDjSy swDjSy) {
        if (StringUtils.isEmpty((String)swDjSy.getSyId())) {
            swDjSy.setSyId(UUIDGenerator.generate());
        }
        SwDjSy swDjSyOld = (SwDjSy)this.baseRepository.get(SwDjSy.class, (Object)swDjSy.getSyId());
        if (swDjSy.getSwDjJbb() != null) {
            SwDjJbb swDjJbb = this.findSwDjJbbById(swDjSy.getSwDjJbb().getJbbId());
            if (swDjJbb == null) {
                this.baseRepository.save((Object)swDjSy.getSwDjJbb());
            } else {
                try {
                    swDjJbb = (SwDjJbb)CommonUtil.copyPropertyForSave((Object)swDjSy.getSwDjJbb(), (Object)swDjJbb);
                    this.baseRepository.update((Object)swDjJbb);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.addSwDjSyUpdateInfo(swDjSy, Czlx.UPDATE.toString());
        if (swDjSyOld != null) {
            SwDjSyHis swDjSyHis = this.copySyToHis(swDjSyOld);
            this.baseRepository.save((Object)swDjSyHis);
            if (swDjSyOld.getSyzt().equalsIgnoreCase(Syzt.SC.toString())) {
                if (swDjSy.getSwDjTd() != null && swDjSyOld.getSwDjTd() != null) {
                    swDjSy.getSwDjTd().setTdId(swDjSyOld.getSwDjTd().getTdId());
                }
                if (swDjSy.getSwDjFc() != null && swDjSyOld.getSwDjFc() != null) {
                    swDjSy.getSwDjFc().setFcId(swDjSyOld.getSwDjFc().getFcId());
                }
            }
            try {
                swDjSy = (SwDjSy)CommonUtil.copyPropertyForSave((Object)swDjSy, (Object)swDjSyOld);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.baseRepository.update((Object)swDjSy);
        } else {
            if (swDjSy.getSwDjTd() != null) {
                if (StringUtils.isBlank((String)swDjSy.getSwDjTd().getTdId())) {
                    swDjSy.getSwDjTd().setTdId(UUIDGenerator.generate());
                }
                if (StringUtils.isBlank((String)swDjSy.getSwDjTd().getSyId())) {
                    swDjSy.getSwDjTd().setSyId(swDjSy.getSyId());
                }
            }
            if (swDjSy.getSwDjFc() != null) {
                if (StringUtils.isBlank((String)swDjSy.getSwDjFc().getFcId())) {
                    swDjSy.getSwDjFc().setFcId(UUIDGenerator.generate());
                }
                if (StringUtils.isBlank((String)swDjSy.getSwDjFc().getSyId())) {
                    swDjSy.getSwDjFc().setSyId(swDjSy.getSyId());
                }
            }
            this.baseRepository.save((Object)swDjSy);
        }
    }

    @Transactional
    public void deleteSwDjSy(String syId) {
        SwDjSy swDjSyOld = (SwDjSy)this.baseRepository.get(SwDjSy.class, (Object)syId);
        if (swDjSyOld != null) {
            SwDjSyHis swDjSyHis = this.copySyToHis(swDjSyOld);
            this.baseRepository.save((Object)swDjSyHis);
            this.addSwDjSyUpdateInfo(swDjSyOld, Czlx.DELETE.toString());
            this.baseRepository.update((Object)swDjSyOld);
        }
    }

    @Transactional
    public void updateSwDjSyTemp(SwDjSyTemp swDjSyTemp) {
        if (StringUtils.isEmpty((String)swDjSyTemp.getSyId())) {
            swDjSyTemp.setSyId(UUIDGenerator.generate());
        }
        SwDjSyTemp swDjSyTempOld = (SwDjSyTemp)this.baseRepository.get(SwDjSyTemp.class, (Object)swDjSyTemp.getTempId());
        this.addSwDjSyTempUpdateInfo(swDjSyTemp, Czlx.UPDATE.toString());
        if (swDjSyTempOld != null) {
            if (swDjSyTempOld.getSyzt().equalsIgnoreCase(Syzt.SC.toString())) {
                if (swDjSyTemp.getSwDjTdTemp() != null && swDjSyTempOld.getSwDjTdTemp() != null) {
                    swDjSyTemp.getSwDjTdTemp().setTempId(swDjSyTempOld.getSwDjTdTemp().getTempId());
                }
                if (swDjSyTemp.getSwDjFcTemp() != null && swDjSyTempOld.getSwDjFcTemp() != null) {
                    swDjSyTemp.getSwDjFcTemp().setTempId(swDjSyTempOld.getSwDjFcTemp().getTempId());
                }
                this.baseRepository.update((Object)swDjSyTemp);
            } else {
                this.baseRepository.update((Object)swDjSyTemp);
            }
        } else {
            this.baseRepository.save((Object)swDjSyTemp);
        }
    }

    @Transactional
    public void deleteSwDjSyTemp(String tempId) {
        SwDjSyTemp swDjSyTempOld = (SwDjSyTemp)this.baseRepository.get(SwDjSyTemp.class, (Object)tempId);
        if (swDjSyTempOld != null) {
            this.addSwDjSyTempUpdateInfo(swDjSyTempOld, Czlx.DELETE.toString());
            this.baseRepository.update((Object)swDjSyTempOld);
        }
    }

    public void addSwDjSyUpdateInfo(SwDjSy swDjSy, String czlx) {
        if (swDjSy != null && StringUtils.isNotEmpty((String)czlx)) {
            UserInfo userInfo = SessionUtil.getCurrentUser();
            if (userInfo != null) {
                swDjSy.setUpdateUserid(userInfo.getId());
                swDjSy.setUpdateUsername(userInfo.getUsername());
                swDjSy.setUpdateRq(Calendar.getInstance().getTime());
            }
            if (czlx.equalsIgnoreCase(Czlx.DELETE.toString())) {
                swDjSy.setCzlx(Czlx.DELETE.toString());
                swDjSy.setSyzt(Syzt.SC.toString());
            } else {
                swDjSy.setCzlx(Czlx.UPDATE.toString());
                swDjSy.setSyzt(Syzt.ZC.toString());
            }
        }
    }

    public void addSwDjSyTempUpdateInfo(SwDjSyTemp swDjSyTemp, String czlx) {
        if (swDjSyTemp != null && StringUtils.isNotEmpty((String)czlx)) {
            UserInfo userInfo = SessionUtil.getCurrentUser();
            if (userInfo != null) {
                swDjSyTemp.setUpdateUserid(userInfo.getId());
                swDjSyTemp.setUpdateUsername(userInfo.getUsername());
                swDjSyTemp.setUpdateRq(Calendar.getInstance().getTime());
            }
            if (czlx.equalsIgnoreCase(Czlx.DELETE.toString())) {
                swDjSyTemp.setCzlx(Czlx.DELETE.toString());
                swDjSyTemp.setSyzt(Syzt.SC.toString());
            } else {
                swDjSyTemp.setCzlx(Czlx.UPDATE.toString());
                swDjSyTemp.setSyzt(Syzt.ZC.toString());
            }
        }
    }

    public SwDjSyHis copySyToHis(SwDjSy swDjSy) {
        String hisId = UUIDGenerator.generate();
        SwDjSyHis swDjSyHis = new SwDjSyHis();
        BeanUtils.copyProperties((Object)swDjSy, (Object)swDjSyHis);
        swDjSyHis.setHisId(hisId);
        if (swDjSy.getSwDjJbb() != null) {
            SwDjJbbHis swDjJbbHis = new SwDjJbbHis();
            BeanUtils.copyProperties((Object)swDjSy.getSwDjJbb(), (Object)swDjJbbHis);
            swDjJbbHis.setHisId(hisId);
            swDjSyHis.setSwDjJbbHis(swDjJbbHis);
        }
        if (swDjSy.getSwDjTd() != null) {
            SwDjTdHis swDjTdHis = new SwDjTdHis();
            BeanUtils.copyProperties((Object)swDjSy.getSwDjTd(), (Object)swDjTdHis);
            swDjTdHis.setHisId(hisId);
            swDjSyHis.setSwDjTdHis(swDjTdHis);
        }
        if (swDjSy.getSwDjFc() != null) {
            SwDjFcHis swDjFcHis = new SwDjFcHis();
            BeanUtils.copyProperties((Object)swDjSy.getSwDjFc(), (Object)swDjFcHis);
            swDjFcHis.setHisId(hisId);
            swDjSyHis.setSwDjFcHis(swDjFcHis);
        }
        if (swDjSy.getZd() != null) {
            Zd zd = new Zd();
            BeanUtils.copyProperties((Object)swDjSy.getZd(), (Object)zd);
            swDjSyHis.setZd(zd);
        }
        return swDjSyHis;
    }

    public SwDjSyTemp copySyToTemp(SwDjSy swDjSy) {
        String tempId = UUIDGenerator.generate();
        SwDjSyTemp swDjSyTemp = new SwDjSyTemp();
        BeanUtils.copyProperties((Object)swDjSy, (Object)swDjSyTemp);
        swDjSyTemp.setTempId(tempId);
        if (swDjSy.getSwDjJbb() != null) {
            SwDjJbbTemp swDjJbbTemp = new SwDjJbbTemp();
            BeanUtils.copyProperties((Object)swDjSy.getSwDjJbb(), (Object)swDjJbbTemp);
            swDjJbbTemp.setTempId(tempId);
            swDjSyTemp.setSwDjJbbTemp(swDjJbbTemp);
        }
        if (swDjSy.getSwDjTd() != null) {
            SwDjTdTemp swDjTdTemp = new SwDjTdTemp();
            BeanUtils.copyProperties((Object)swDjSy.getSwDjTd(), (Object)swDjTdTemp);
            swDjTdTemp.setTempId(tempId);
            swDjSyTemp.setSwDjTdTemp(swDjTdTemp);
        }
        if (swDjSy.getSwDjFc() != null) {
            SwDjFcTemp swDjFcTemp = new SwDjFcTemp();
            BeanUtils.copyProperties((Object)swDjSy.getSwDjFc(), (Object)swDjFcTemp);
            swDjFcTemp.setTempId(tempId);
            swDjSyTemp.setSwDjFcTemp(swDjFcTemp);
        }
        if (swDjSy.getZd() != null) {
            Zd zd = new Zd();
            BeanUtils.copyProperties((Object)swDjSy.getZd(), (Object)zd);
            swDjSyTemp.setZd(zd);
        }
        return swDjSyTemp;
    }

    public SwDjSy copyTempToSy(SwDjSyTemp swDjSyTemp) {
        SwDjSy swDjSy = new SwDjSy();
        BeanUtils.copyProperties((Object)swDjSyTemp, (Object)swDjSy);
        if (swDjSyTemp.getSwDjJbbTemp() != null) {
            SwDjJbb swDjJbb = new SwDjJbb();
            BeanUtils.copyProperties((Object)swDjSyTemp.getSwDjJbbTemp(), (Object)swDjJbb);
            swDjSy.setSwDjJbb(swDjJbb);
        }
        if (swDjSyTemp.getSwDjTdTemp() != null) {
            SwDjTd swDjTd = new SwDjTd();
            BeanUtils.copyProperties((Object)swDjSyTemp.getSwDjTdTemp(), (Object)swDjTd);
            swDjTd.setTdId(swDjSyTemp.getSwDjTdTemp().getTempId());
            swDjSy.setSwDjTd(swDjTd);
        }
        if (swDjSyTemp.getSwDjFcTemp() != null) {
            SwDjFc swDjFc = new SwDjFc();
            BeanUtils.copyProperties((Object)swDjSyTemp.getSwDjFcTemp(), (Object)swDjFc);
            swDjFc.setFcId(swDjSyTemp.getSwDjFcTemp().getTempId());
            swDjSy.setSwDjFc(swDjFc);
        }
        if (swDjSyTemp.getZd() != null) {
            Zd zd = new Zd();
            BeanUtils.copyProperties((Object)swDjSyTemp.getZd(), (Object)zd);
            swDjSy.setZd(zd);
        }
        return swDjSy;
    }

    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    public List<SwDjSy> findSyList(List<QueryCondition> queryConditionList) {
        if (queryConditionList == null) {
            queryConditionList = new ArrayList<QueryCondition>();
        }
        return this.baseRepository.list(SwDjSy.class, queryConditionList);
    }

    @Transactional(readOnly=true, propagation=Propagation.NOT_SUPPORTED)
    public List<SwDjSyTemp> findSyTempList(List<QueryCondition> queryConditionList) {
        if (queryConditionList == null) {
            queryConditionList = new ArrayList<QueryCondition>();
        }
        return this.baseRepository.list(SwDjSyTemp.class, queryConditionList);
    }

    public void updateSyZdInfo(String syId, String djhNew) {
        if (StringUtils.isEmpty((String)syId) || StringUtils.isEmpty((String)djhNew)) {
            return;
        }
        SwDjSy swDjSy = (SwDjSy)this.baseRepository.get(SwDjSy.class, (Object)syId);
        Zd zd = (Zd)this.baseRepository.get(Zd.class, (Object)djhNew);
        if (swDjSy == null || zd == null) {
            return;
        }
        swDjSy.setZd(zd);
        swDjSy.setBz("\u5b97\u5730\u53d8\u66f4\u4fe1\u606f\u66f4\u65b0");
        this.updateSwDjSy(swDjSy);
    }

    private List<QueryCondition> addParameter(SwDjSyQuery swDjSyQuery) {
        ArrayList<QueryCondition> list = new ArrayList<QueryCondition>();
        if (StringUtils.isNotBlank((String)swDjSyQuery.getGlbm())) {
            list.add(new QueryCondition("swDjJbb.glbm", "like", (Object)swDjSyQuery.getGlbm()));
        }
        if (StringUtils.isNotBlank((String)swDjSyQuery.getDjh())) {
            list.add(new QueryCondition("zd.djh", "like", (Object)swDjSyQuery.getDjh()));
        }
        if (StringUtils.isNotBlank((String)swDjSyQuery.getNsrmc())) {
            list.add(new QueryCondition("swDjJbb.nsrmc", "like", (Object)swDjSyQuery.getNsrmc()));
        }
        list.add(new QueryCondition("syzt=1"));
        list.add(new QueryCondition("zd.djh is not null"));
        return list;
    }
}

