/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.service.MapService;
import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class MapServiceImpl
implements MapService {
    @Value(value="${egov.conf}/landtax/map.json")
    String configPath;

    @Cacheable(value={"mapConfig"})
    public Object getMapConfig() throws Exception {
        return this.readJsonFile(this.configPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readJsonFile(String path) throws Exception {
        if (StringUtils.isNotBlank((String)path)) {
            File file;
            if (path.indexOf("file:/") > -1) {
                path = path.substring(path.indexOf("file:/") + 6);
            }
            if (!(file = new File(path)).exists()) {
                throw new FileNotFoundException();
            }
            BufferedReader bufferedReader = null;
            StringBuffer config = new StringBuffer();
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                String tmp = null;
                while ((tmp = bufferedReader.readLine()) != null) {
                    config.append(tmp);
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            if (StringUtils.isNotBlank((String)config.toString())) {
                return JSON.parse((String)config.toString());
            }
        }
        return null;
    }
}

