/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landtax.print;

import cn.gtmap.landtax.util.CommonUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class VoXml {
    private Object vo = null;
    private HashMap<String, String> map = null;

    public VoXml() {
    }

    public VoXml(Object vo) {
        this.vo = vo;
    }

    public String getXMLData() {
        String retvalue = this.getXML();
        return retvalue;
    }

    public String getEntityXMLData() {
        String retvalue = null;
        try {
            retvalue = this.getEntityXML(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retvalue;
    }

    public String getXMLDataByHashMap() {
        String retvalue = this.getXMLByHashMap();
        return retvalue;
    }

    private String getXMLByHashMap() {
        StringBuffer sb = new StringBuffer();
        try {
            if (this.map != null) {
                for (Map.Entry entry : this.map.entrySet()) {
                    Object key = entry.getKey();
                    if (key == null || !StringUtils.isNotBlank((String)key.toString())) continue;
                    Object value = entry.getValue();
                    String name = "";
                    if (value != null && StringUtils.isNotBlank((String)value.toString())) {
                        name = value.toString();
                    }
                    if (name.indexOf(">") > -1 || name.indexOf("<") > -1) {
                        StringBuffer sbName = new StringBuffer();
                        for (int i = 0; i < name.length(); ++i) {
                            if (name.charAt(i) == '<') {
                                sbName.append('\uff1c');
                                continue;
                            }
                            if (name.charAt(i) == '>') {
                                sbName.append('\uff1e');
                                continue;
                            }
                            sbName.append(name.charAt(i));
                        }
                        name = sbName.toString();
                    }
                    if (name.equals("0") || name.equals("0.0")) {
                        name = "";
                    }
                    String datastr = "<data name=\"" + key.toString().trim() + "\" type=\"String\">" + name + "</data>";
                    sb.append(datastr);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private List getFields() {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Field[] fieldArr = null;
        fieldArr = this.vo.getClass().getDeclaredFields();
        fieldList.addAll(Arrays.asList(fieldArr));
        for (Class<?> classz = this.vo.getClass().getSuperclass(); classz != null; classz = classz.getSuperclass()) {
            fieldArr = classz.getDeclaredFields();
            fieldList.addAll(Arrays.asList(fieldArr));
        }
        Field[] ffields = this.vo.getClass().getDeclaredFields();
        int fieldcount = fieldList.size();
        for (int i = 0; i < fieldcount; ++i) {
            Field aField = (Field)fieldList.get(i);
            String fieldname = aField.getName();
            fieldname = fieldname.substring(0, 1).toUpperCase() + fieldname.substring(1);
            list.add(fieldname);
        }
        return list;
    }

    private List getFields(Object obj) {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Field[] fieldArr = null;
        fieldArr = obj.getClass().getDeclaredFields();
        fieldList.addAll(Arrays.asList(fieldArr));
        for (Class<?> classz = obj.getClass().getSuperclass(); classz != null; classz = classz.getSuperclass()) {
            fieldArr = classz.getDeclaredFields();
            fieldList.addAll(Arrays.asList(fieldArr));
        }
        Field[] ffields = obj.getClass().getDeclaredFields();
        int fieldcount = fieldList.size();
        for (int i = 0; i < fieldcount; ++i) {
            Field aField = (Field)fieldList.get(i);
            String fieldname = aField.getName();
            fieldname = fieldname.substring(0, 1).toUpperCase() + fieldname.substring(1);
            list.add(fieldname);
        }
        return list;
    }

    private String getXML() {
        StringBuffer sb = new StringBuffer();
        List list = this.getFields();
        for (String fieldname : list) {
            String methodname = "get" + fieldname;
            Method method = this.getMethod(methodname);
            if (method == null) continue;
            String datastr = "";
            String fieldtype = this.getFiledType(method);
            String name = this.getValue(method, fieldtype.trim());
            if (name.indexOf(">") > -1 || name.indexOf("<") > -1) {
                StringBuffer sbName = new StringBuffer();
                for (int i = 0; i < name.length(); ++i) {
                    if (name.charAt(i) == '<') {
                        sbName.append('\uff1c');
                        continue;
                    }
                    if (name.charAt(i) == '>') {
                        sbName.append('\uff1e');
                        continue;
                    }
                    sbName.append(name.charAt(i));
                }
                name = sbName.toString();
            }
            datastr = "<data name=\"" + fieldname.trim() + "\" type=\"String\">" + name + "</data>";
            sb.append(datastr);
        }
        return sb.toString();
    }

    private String getEntityXML(Object obj) throws Exception {
        String preField = "";
        if (obj == null) {
            obj = this.vo;
        } else {
            preField = obj.getClass().getSimpleName() + ".";
        }
        StringBuffer sb = new StringBuffer();
        List list = this.getFields(obj);
        for (String fieldname : list) {
            String methodname = "get" + fieldname;
            Method method = this.getMethod(obj, methodname);
            if (method == null) continue;
            String datastr = "";
            String fieldtype = this.getFiledType(method);
            if (method.getReturnType().toString().startsWith("class cn.gtmap.landtax.entity.")) {
                Object retobj = null;
                try {
                    retobj = method.invoke(obj, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (retobj == null) {
                    retobj = Class.forName(method.getReturnType().toString().substring(6)).newInstance();
                }
                datastr = this.getEntityXML(retobj);
            } else {
                String name = this.getValue(obj, method, fieldtype.trim());
                if (name.indexOf(">") > -1 || name.indexOf("<") > -1) {
                    StringBuffer sbName = new StringBuffer();
                    for (int i = 0; i < name.length(); ++i) {
                        if (name.charAt(i) == '<') {
                            sbName.append('\uff1c');
                            continue;
                        }
                        if (name.charAt(i) == '>') {
                            sbName.append('\uff1e');
                            continue;
                        }
                        sbName.append(name.charAt(i));
                    }
                    name = sbName.toString();
                }
                datastr = "<data name=\"" + preField + fieldname.trim() + "\" type=\"String\">" + name + "</data>";
            }
            sb.append(datastr);
        }
        return sb.toString();
    }

    private Method getMethod(String methodName) {
        Method method = null;
        try {
            method = this.vo.getClass().getDeclaredMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            methodName = "get" + methodName.substring(3, 4).toLowerCase() + methodName.substring(4, methodName.length());
            try {
                method = this.vo.getClass().getDeclaredMethod(methodName, new Class[0]);
            }
            catch (Exception e2) {
                e.printStackTrace();
            }
        }
        return method;
    }

    private Method getMethod(Object obj, String methodName) {
        Method method = null;
        try {
            method = obj.getClass().getMethod(methodName, new Class[0]);
        }
        catch (Exception e) {
            methodName = "get" + methodName.substring(3, 4).toLowerCase() + methodName.substring(4, methodName.length());
            try {
                method = obj.getClass().getMethod(methodName, new Class[0]);
            }
            catch (Exception e2) {
                e.printStackTrace();
            }
        }
        return method;
    }

    private String getValue(Method method, String fieldtype) {
        String retvalue = null;
        Object retobj = null;
        try {
            retobj = method.invoke(this.vo, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (retobj == null) {
            retvalue = "";
        } else if (fieldtype.equals("String")) {
            retvalue = (String)retobj;
        } else if (fieldtype.equals("int")) {
            int temp = (Integer)retobj;
            retvalue = Integer.toString(temp);
        } else if (fieldtype.equals("Boolean")) {
            Boolean temp = (Boolean)retobj;
            retvalue = Boolean.toString(temp);
        } else if (fieldtype.equals("float")) {
            float temp = ((Float)retobj).floatValue();
            retvalue = Float.toString(temp);
        } else if (fieldtype.equalsIgnoreCase("double")) {
            double temp = (Double)retobj;
            retvalue = temp == 0.0 ? "" : CommonUtil.DoubleToString((Double)temp, (Integer)4, (boolean)false);
        } else if (fieldtype.equals("BigDecimal")) {
            BigDecimal temp = (BigDecimal)retobj;
            retvalue = temp.toString();
        } else if (fieldtype.equals("Long")) {
            long temp = (Long)retobj;
            retvalue = Long.toString(temp);
        } else if (fieldtype.equals("short")) {
            short temp = (Short)retobj;
            retvalue = Short.toString(temp);
        } else if (fieldtype.equals("byte")) {
            byte temp = (Byte)retobj;
            retvalue = Byte.toString(temp);
        } else if (fieldtype.equals("Integer")) {
            Integer tempInt = (Integer)retobj;
            retvalue = String.valueOf(tempInt);
        } else if (fieldtype.equals("Date")) {
            Date tempInt = (Date)retobj;
            int hours = tempInt.getHours();
            SimpleDateFormat sdf = hours > 0 ? new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH:mm") : new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            retvalue = String.valueOf(sdf.format(tempInt));
        } else {
            retvalue = "";
        }
        return retvalue;
    }

    private String getValue(Object obj, Method method, String fieldtype) {
        String retvalue = null;
        Object retobj = null;
        try {
            retobj = method.invoke(obj, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (retobj == null) {
            retvalue = "";
        } else if (fieldtype.equals("String")) {
            retvalue = (String)retobj;
        } else if (fieldtype.equals("int")) {
            int temp = (Integer)retobj;
            retvalue = Integer.toString(temp);
        } else if (fieldtype.equals("Boolean")) {
            Boolean temp = (Boolean)retobj;
            retvalue = Boolean.toString(temp);
        } else if (fieldtype.equals("float")) {
            float temp = ((Float)retobj).floatValue();
            retvalue = Float.toString(temp);
        } else if (fieldtype.equalsIgnoreCase("double")) {
            double temp = (Double)retobj;
            retvalue = temp == 0.0 ? "" : CommonUtil.DoubleToString((Double)temp, (Integer)4, (boolean)false);
        } else if (fieldtype.equals("BigDecimal")) {
            BigDecimal temp = (BigDecimal)retobj;
            retvalue = temp.toString();
        } else if (fieldtype.equals("Long")) {
            long temp = (Long)retobj;
            retvalue = Long.toString(temp);
        } else if (fieldtype.equals("short")) {
            short temp = (Short)retobj;
            retvalue = Short.toString(temp);
        } else if (fieldtype.equals("byte")) {
            byte temp = (Byte)retobj;
            retvalue = Byte.toString(temp);
        } else if (fieldtype.equals("Integer")) {
            Integer tempInt = (Integer)retobj;
            retvalue = String.valueOf(tempInt);
        } else if (fieldtype.equals("Date")) {
            Date tempInt = (Date)retobj;
            int hours = tempInt.getHours();
            SimpleDateFormat sdf = hours > 0 ? new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH:mm") : new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            retvalue = String.valueOf(sdf.format(tempInt));
        } else {
            retvalue = "";
        }
        return retvalue;
    }

    private String getFiledType(Method method) {
        String fieldtype = method.getReturnType().toString();
        int pos = fieldtype.lastIndexOf(".");
        if (pos > 0) {
            fieldtype = fieldtype.substring(pos + 1);
        }
        return fieldtype;
    }

    public void setMap(HashMap<String, String> map) {
        this.map = map;
    }
}

