package cn.gtmap.landtax.web.tj;

import cn.gtmap.landtax.entity.ChartBaseParamVo;
import cn.gtmap.landtax.entity.TjBaseParamVo;
import cn.gtmap.landtax.print.PrintGridExcelUtil;
import cn.gtmap.landtax.printexcel.access.ExcelBean;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.service.impl.DicServiceImpl;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.QueryCondition;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by xuchao on 2014/9/27.
 */
@Controller
@RequestMapping("/tj")
public class TjController {
    @Autowired
    TjService tjService;
    @Autowired
    DicServiceImpl dicServiceImpl;
    @Autowired
    DwxxService dwxxService;

    //基础统计表
    @RequestMapping("baseTj")
    public String baseTj(Model model, String tag, String customParams) {
        model.addAttribute("tag",tag);
        model.addAttribute("customParams", customParams);
        TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tag);
        model.addAttribute("tjBaseParamVo", tjBaseParamVo);
        if (tjBaseParamVo != null) {
            model.addAttribute("colJson", tjBaseParamVo.getColJson());
            model.addAttribute("headPageFile", tjBaseParamVo.getHeadPageFile());
            model.addAttribute("reportName", tjBaseParamVo.getReportName());
            if (StringUtils.isNotBlank(tjBaseParamVo.getExcelTemplate()) && StringUtils.isNotBlank(tjBaseParamVo.getExcelXml()) && StringUtils.isNotBlank(tjBaseParamVo.getExportFieldList())) {
                model.addAttribute("needExport", "true");
            }
            if (tjBaseParamVo.isNeedExport()) {
                model.addAttribute("autoExport", "true");
            }
        }
        return "landtax/tj/baseTj";
    }

    //基础统计表
    @RequestMapping("baseChart")
    public String baseChart(Model model, String tag, String customParams) {
        TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tag);
        model.addAttribute("tjBaseParamVo", tjBaseParamVo);
        model.addAttribute("customParams", customParams);

        return "landtax/tj/baseChart";
    }

    // 获取统计报表的数据
    @RequestMapping("tjJson")
    @ResponseBody
    public Page tjJson(Model model, Pageable request, String tag, String query, String customParams) {
        List<QueryCondition> queryConditionList = CommonUtil.initQueryCondition(query);
        queryConditionList = addCustomParams(queryConditionList, customParams);
        Page page = tjService.getTjJson(request, tag, queryConditionList);
        return page;
    }

    // 获取统计报表的数据
    @RequestMapping("chartJson")
    @ResponseBody
    public Object chartJson(Model model, Pageable request, String tag, String query, String customParams, String uniqueId) {
        // 根据tag值获取统计的配置参数
        TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tag);

        // 根据图表的uniqueId值获取图表配置参数
        ChartBaseParamVo  chartBaseParamVo = tjBaseParamVo.getChartBaseParamVoList().get(0);
        for (ChartBaseParamVo chartBaseParamVoTemp : tjBaseParamVo.getChartBaseParamVoList()) {
            if (chartBaseParamVoTemp.getUniqueId().equals(uniqueId)) {
                chartBaseParamVo = chartBaseParamVoTemp;
                break;
            }
        }

        // 根据配置参数查询数据
        List<QueryCondition> queryConditionList = CommonUtil.initQueryCondition(query);
        queryConditionList = addCustomParams(queryConditionList, customParams);
        List<HashMap> tjList = tjService.getTjList(tag, queryConditionList);

        // 获取统计图表的X轴刻度值
        String chartRowField = chartBaseParamVo.getRowUseFlagField();
        List<String> categoriesList = new ArrayList<String>();
        for (HashMap hashMap : tjList) {
            if (hashMap.get(chartRowField) == null || hashMap.get(chartRowField).toString().equals("1"))
                categoriesList.add(hashMap.get(chartBaseParamVo.getCategoriesField()).toString());
        }

        // 获取统计图表的系列数据
        List seriesList = new ArrayList();
        List<HashMap> seriesNameList = chartBaseParamVo.getSeriesList();
        for (int i = 0; i < seriesNameList.size(); i++) {
            String seriesField = seriesNameList.get(i).get("seriesField").toString();
            String seriesName = seriesNameList.get(i).get("seriesName").toString();
            String seriesUnit = seriesNameList.get(i).get("seriesUnit").toString();

            List<HashMap> list = new ArrayList<HashMap>();
            for (HashMap hashMap : tjList) {
                if (hashMap.get(chartRowField) == null || hashMap.get(chartRowField).toString().equals("1")) {
                    HashMap hashMapTemp = new HashMap();
                    hashMapTemp.put("name", hashMap.get(chartBaseParamVo.getCategoriesField()));
                    hashMapTemp.put("y", hashMap.get(seriesField) == null ? 0 : hashMap.get(seriesField));
                    list.add(hashMapTemp);
                }
            }


            HashMap seriesMap = new HashMap();
            seriesMap.put("name", seriesName);
            seriesMap.put("data", list);
            seriesMap.put("unit", seriesUnit);

            seriesList.add(seriesMap);
        }

        HashMap resultMap = new HashMap();
        resultMap.put("categories",categoriesList);
        resultMap.put("series",seriesList);
        resultMap.put("chartBaseParamVo", chartBaseParamVo);
        resultMap.put("customOptions", chartBaseParamVo.getCustomOptions());

        return resultMap;
    }

    @RequestMapping("tjList")
    @ResponseBody
    public List tjList(Model model, Pageable request, String tag, String query, String customParams) {
        List<QueryCondition> queryConditionList = CommonUtil.initQueryCondition(query);
        queryConditionList = addCustomParams(queryConditionList, customParams);
        List list = tjService.getTjList(tag, queryConditionList);
        return list;
    }

    @RequestMapping("exportExcelTj")
    public String exportExcelTj(HttpServletRequest request, String tag, String query, String customParams) throws Exception {
        try {
            TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tag);
            if (tjBaseParamVo == null) {
                return null;
            }
            String[] fieldList = tjBaseParamVo.getExportFieldList().split(",");
            List<QueryCondition> queryConditionList = CommonUtil.initQueryCondition(query);
            queryConditionList = addCustomParams(queryConditionList, customParams);
            List<HashMap> list = (List<HashMap>)tjService.getTjList(tag, queryConditionList);

            HashMap<String, List<String[]>> map = new HashMap<String, List<String[]>>();
            List<String[]> retList = new ArrayList<String[]>(); // 组织参数
            int sheetIndex = 0;
            long sheetRecordCount = 50000;
            for (int i = 0; i < list.size(); i++) {
                HashMap tempVo = list.get(i);
                if (tempVo != null) {
                    String[] strs = new String[fieldList.length];
                    for (int j = 0; j < fieldList.length; j++){
                        if (tempVo.get(fieldList[j].toString()) != null) {
                            strs[j] = tempVo.get(fieldList[j].toString()).toString();
                        } else if (fieldList[j].toString().equals("XH")) {
                            strs[j] = String.valueOf((i + 1));
                        }
                    }
                    retList.add(strs);
                }

                if (retList.size() >= sheetRecordCount) {
                    sheetIndex += 1;
                    map.put("group" + String.valueOf(sheetIndex), retList); // 把retList放入group中
                    retList = new ArrayList<String[]>(); // 清空retList
                }
            }

            if (retList.size() > 0) {
                sheetIndex += 1;
                map.put("group" + String.valueOf(sheetIndex), retList); // 把retList放入group中
                retList = new ArrayList<String[]>(); // 清空retList
            }

            ExcelBean eb = new ExcelBean();
            request.setAttribute("date", ""+new SimpleDateFormat("yyyy年MM月dd日").format(new Date()));
            request.setAttribute("year",""+new SimpleDateFormat("yyyy").format(new Date()));

            eb.setGroupMap(map);
            eb.setExcelTemplate(tjBaseParamVo.getExcelTemplate()); //
            eb.setExcelXml(tjBaseParamVo.getExcelXml()); // 上述两步骤是把xml文件和xls文件有机组合
            eb.printExcel(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    @RequestMapping("exportExcelTjEx")
    public String exportExcelTjEx(HttpServletRequest request, String tag, String query, String customParams, String gridOptions){
        try {
            TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tag);
            if (tjBaseParamVo == null) {
                return null;
            }
            List<QueryCondition> queryConditionList = CommonUtil.initQueryCondition(query);
            queryConditionList = addCustomParams(queryConditionList, customParams);
            List<HashMap> list = (List<HashMap>)tjService.getTjList(tag, queryConditionList);

            com.alibaba.fastjson.JSONObject jsonObject = (new com.alibaba.fastjson.JSONObject()).parseObject(gridOptions);
            PrintGridExcelUtil printGridExcel = new PrintGridExcelUtil();
            printGridExcel.setTitle(tjBaseParamVo.getReportName());
            printGridExcel.setGridOptions(jsonObject);
            printGridExcel.printGridExcel(request, list);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }

    private List<QueryCondition> addCustomParams(List<QueryCondition> queryConditionList, String customParams) {
        if (queryConditionList == null)
            queryConditionList = new ArrayList<QueryCondition>();

        if (StringUtils.isNotBlank(customParams)) {
            List<QueryCondition> customQueryConditionList = CommonUtil.initQueryCondition(customParams);
            for (int i = 0; i < customQueryConditionList.size(); i++) {
                queryConditionList.add(customQueryConditionList.get(i));
            }
        }

        return queryConditionList;
    }
}
