package cn.gtmap.landtax.web.syhc;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.print.PrintGridExcelUtil;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;

/**
 * Created by user on 2015/9/4.
 */

@Controller
@RequestMapping("/syhc")
public class SyhcController {
    @Autowired
    SyhcService syhcService;
    @Autowired
    WorkFlowService workFlowService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    TaxService taxService;
    @Autowired
    ZdService zdService;
    @Autowired
    TjService tjService;
    @Autowired
    DicService dicService;
    @Autowired
    BaseRepository baseRepository;

    //根据proid获取下发任务的纳税人信息、和任务相关联的宗地信息，税源信息
    @RequestMapping("sytz")
    public String Sytz(Model model, String proid) throws Exception{

        String isYbj = "false";
        String isZdhc = "false";
        String hcxmlx = workFlowService.getHcxmlx(proid);
        SwHcXmRwRel swHcXmRwRel = hcxmService.getCurSwHcXmRwRelByProid(proid);
        String bdId = swHcXmRwRel.getBdId();

        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();

        if (hcxmlx.equals(Hcxmlx.ZDHC.toString())) {
           queryConditionList.add(new QueryCondition("QLR_ID", QueryCondition.EQ, bdId));
           SwDjJbb swDjJbb = new SwDjJbb();
           isZdhc = "true";
        } else {
           queryConditionList.add(new QueryCondition("JBB_ID", QueryCondition.EQ, bdId));
        }
        List<HashMap> zdList = tjService.getTjList("zdList", queryConditionList);
        List<SwDjSyTemp> swDjSyTempList = new ArrayList<SwDjSyTemp>();
        swDjSyTempList = syhcService.getSyxx(swHcXmRwRel.getShxrId());
        SwDjJbb swDjJbb = new SwDjJbb();
        if (hcxmlx.equals(Hcxmlx.ZDHC.toString())) {
           String qlrmc = syhcService.getZdList(bdId);
           swDjJbb.setNsrmc(qlrmc);
        }else {
           swDjJbb = taxService.findSwDjJbbById(bdId);
        }
        if(swHcXmRwRel.getBlzt().equals(Blzt.YBJ.toString())){
           isYbj="true";
        }

        // 获取面积差异数据
        HashMap mjMap = new HashMap();
        BigDecimal zdMjHJ = new BigDecimal(0);
        HashMap zd;
        for (int i = 0; i < zdList.size(); i++) {
            zd = zdList.get(i);
            if (zd.get("SYQMJ") != null)
                zdMjHJ = zdMjHJ.add(new BigDecimal(zd.get("SYQMJ").toString()));
        }
        mjMap.put("zdMjHJ", zdMjHJ);

        BigDecimal syMjHJ = new BigDecimal(0);
        SwDjSyTemp swDjSyTemp;
        for (int j = 0; j < swDjSyTempList.size(); j++) {
            swDjSyTemp = swDjSyTempList.get(j);
            if (!Syzt.ZC.toString().equals(swDjSyTemp.getSyzt()))
                continue;

            if (swDjSyTemp.getSwDjTdTemp() == null)
                continue;

            if (swDjSyTemp.getSwDjTdTemp().getScmj() == null)
                syMjHJ = syMjHJ.add(new BigDecimal(swDjSyTemp.getSwDjTdTemp().getScmj().toString()));
        }
        mjMap.put("syMjHJ", syMjHJ);
        mjMap.put("mjcz", zdMjHJ.subtract(syMjHJ));
        String cybl = "--";
        if (!zdMjHJ.equals(new BigDecimal(0))) {
            cybl = zdMjHJ.subtract(syMjHJ).divide(zdMjHJ).multiply(new BigDecimal(100)).toString() + "%";
        }
        mjMap.put("cybl", cybl);

        model.addAttribute("mjMap", mjMap);
        model.addAttribute("isZdhc", isZdhc);
        model.addAttribute("isYbj", isYbj);
        model.addAttribute("swDjJbb", swDjJbb);
        model.addAttribute("swDjSyTempList", swDjSyTempList);
        model.addAttribute("zdList", zdList);
        model.addAttribute("proid", proid);
        return "landtax/syhc/sytz";
    }

    @RequestMapping("zdgxhctz")
    public String zdgxhctz(Model model, String proid) throws Exception{
        String isYbj = "false";
        String isZdhc = "false";
        String hcxmlx = workFlowService.getHcxmlx(proid);
        SwHcXmRwRel swHcXmRwRel = hcxmService.getCurSwHcXmRwRelByProid(proid);
        String bdId = swHcXmRwRel.getBdId();

        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("djh in (select distinct t1.djh_new from  s_sj_zdbg_analy t left join s_sj_zdbg t1 on t.bgproid=t1.projectid where t.groupid='" + bdId + "')"));
        List<HashMap> zdList = tjService.getTjList("zdList", queryConditionList);

        queryConditionList.clear();
        queryConditionList.add(new QueryCondition("groupid", QueryCondition.EQ, bdId));
        List<HashMap> zdbgAnalyList = tjService.getTjList("zdbgAnalyList", queryConditionList);

        List<SwDjSyTemp> swDjSyTempList = new ArrayList<SwDjSyTemp>();
        swDjSyTempList = syhcService.getSyxx(swHcXmRwRel.getShxrId());

        if(swHcXmRwRel.getBlzt().equals(Blzt.YBJ.toString())){
            isYbj="true";
        }

        // 获取面积差异数据
        HashMap mjMap = new HashMap();
        BigDecimal zdMjHJ = new BigDecimal(0);
        HashMap zd;
        for (int i = 0; i < zdList.size(); i++) {
            zd = zdList.get(i);
            if (zd.get("SCMJ") != null)
                zdMjHJ = zdMjHJ.add(new BigDecimal(zd.get("SCMJ").toString()));
        }
        mjMap.put("zdMjHJ", zdMjHJ);

        BigDecimal syMjHJ = new BigDecimal(0);
        SwDjSyTemp swDjSyTemp;
        for (int j = 0; j < swDjSyTempList.size(); j++) {
            swDjSyTemp = swDjSyTempList.get(j);
            if (!Syzt.ZC.toString().equals(swDjSyTemp.getSyzt()))
                continue;

            if (swDjSyTemp.getSwDjTdTemp() == null)
                continue;

            if (swDjSyTemp.getSwDjTdTemp().getScmj() == null)
                syMjHJ = syMjHJ.add(new BigDecimal(swDjSyTemp.getSwDjTdTemp().getScmj().toString()));
        }
        mjMap.put("syMjHJ", syMjHJ);
        mjMap.put("mjcz", zdMjHJ.subtract(syMjHJ));
        String cybl = "--";
        if (!zdMjHJ.equals(new BigDecimal(0))) {
            cybl = zdMjHJ.subtract(syMjHJ).divide(zdMjHJ).multiply(new BigDecimal(100)).toString() + "%";
        }
        mjMap.put("cybl", cybl);

//        model.addAttribute("mjMap", mjMap);
        model.addAttribute("isYbj", isYbj);
        model.addAttribute("swDjSyTempList", swDjSyTempList);
        model.addAttribute("zdbgAnalyList", zdbgAnalyList);
        model.addAttribute("swDjJbb", new SwDjJbb());
        model.addAttribute("zdList", zdList);
        model.addAttribute("proid", proid);
        return "landtax/syhc/zdgxhctz";
    }

    //根据jbbId和前台输入的djh，增加一个和纳税人相关联的宗地信息，同时生成相应的税源信息
    @RequestMapping("addZd")
    @ResponseBody
    public Object addZd(Model model, String jbbId, String djh) throws Exception {
        ResponseMessage responseMessage = new ResponseMessage();
        String msg="";
        String syId = UUIDGenerator.generate();
        String tempId = UUIDGenerator.generate();
        String userId = SessionUtil.getCurrentUserId();
        String username = SessionUtil.getCurrentUser().getUsername();
        Date updateRq= Calendar.getInstance().getTime();
        try{
            Zd zd = new Zd();
            zd.setDjh(djh);
            SwDjJbb swDjJbb = new SwDjJbb();
            swDjJbb.setJbbId(jbbId);

            SwDjSy swDjSy = new SwDjSy();
            swDjSy.setSyId(syId);
            swDjSy.setGtly(Gtlx.ZD.toString());
            swDjSy.setSjly(Sjly.SYHC.toString());
            swDjSy.setSyzt(Syzt.LS.toString());
            swDjSy.setBz("核查入库");
            swDjSy.setUpdateRq(updateRq);
            swDjSy.setUpdateUserid(userId);
            swDjSy.setUpdateUsername(username);
            swDjSy.setCzlx("insert");
            swDjSy.setZd(zd);
            swDjSy.setSwDjJbb(swDjJbb);
            List<SwDjSy> tempList = new ArrayList<SwDjSy>();
            List<QueryCondition> paramList = new ArrayList<QueryCondition>();
            paramList.add(new QueryCondition("zd.djh",QueryCondition.EQ,djh));
            paramList.add(new QueryCondition("swDjJbb.jbbId",QueryCondition.EQ,jbbId));
            tempList=syhcService.findSyList(paramList);
            if(CollectionUtils.isNotEmpty(tempList)){
                responseMessage.setMsg("创建失败，纳税人不能重复增加同一块宗地！");
            }else{
                syhcService.saveSy(swDjSy);
                responseMessage.setMsg(" 创建成功！");
            }
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("创建失败！");
        }
        return responseMessage;
    }

    //根据djh,jbbId,proid创建一个临时的税源信息，存放在临时表中
    @RequestMapping("createNewSyTdTemp")
    @ResponseBody
    public Object createNewSyTdTemp(Model model,String djh,String jbbId,String proid) throws Exception{
        String tempId = "";

        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("syzt", QueryCondition.EQ, Syzt.LS.toString()));
        queryConditionList.add(new QueryCondition("zd.djh", QueryCondition.EQ, djh));
        queryConditionList.add(new QueryCondition("swDjJbbTemp.jbbId", QueryCondition.EQ, jbbId));
        queryConditionList.add(new QueryCondition("swHcXmRwRel.rwId", QueryCondition.EQ, proid));
        queryConditionList.add(new QueryCondition("swDjTdTemp.syId is not null"));
        List<SwDjSyTemp> swDjSyTempList = taxService.findSyTempList(queryConditionList);

        String syId = UUIDGenerator.generate();
        tempId = UUIDGenerator.generate();
        String userId = SessionUtil.getCurrentUserId();
        String username = SessionUtil.getCurrentUser().getUsername();
        Date updateRq = Calendar.getInstance().getTime();
        if (CollectionUtils.isNotEmpty(swDjSyTempList)) {
            tempId = swDjSyTempList.get(0).getTempId();

            swDjSyTempList.get(0).getSwDjJbbTemp().setSgyMc(username);
            String regionCode = SessionUtil.getCurrentUser().getRegionCode();
            String zgkgDm = "2" + regionCode + "00";
            String zgkgMc= dicService.findMcByDm("zgkg", zgkgDm);
            swDjSyTempList.get(0).getSwDjJbbTemp().setZgkgDm(zgkgDm);
            swDjSyTempList.get(0).getSwDjJbbTemp().setZgkgMc(zgkgMc);

            syhcService.saveSyTemp(swDjSyTempList.get(0));
        } else {
            SwDjSyTemp swDjSyTemp = new SwDjSyTemp();

            swDjSyTemp.setTempId(tempId);

            swDjSyTemp.setSyId(syId);
            swDjSyTemp.setSjly(Sjly.SYHC.toString());
            swDjSyTemp.setSyzt(Syzt.LS.toString());
            swDjSyTemp.setBz("核查入库");
            swDjSyTemp.setUpdateRq(updateRq);
            swDjSyTemp.setUpdateUserid(userId);
            swDjSyTemp.setUpdateUsername(username);
            swDjSyTemp.setCzlx(Czlx.INSERT.toString());

            Zd zd = null;
            if (StringUtils.isNotEmpty(djh)) {
                zd = zdService.findZdByDjh(djh);
                if (zd == null) {
                    zd = new Zd();
                    zd.setDjh(djh);
                }
                swDjSyTemp.setZd(zd);
                swDjSyTemp.setGtly(Gtlx.ZD.toString());
            }

            SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
            swHcXmRwRel = hcxmService.getCurSwHcXmRwRelByProid(proid);
            swDjSyTemp.setSwHcXmRwRel(swHcXmRwRel);

            SwDjJbbTemp swDjJbbTemp = new SwDjJbbTemp();
            if (StringUtils.isNotEmpty(jbbId)) {
                SwDjJbb swDjJbb = baseRepository.get(SwDjJbb.class, jbbId);
                swDjJbbTemp = (SwDjJbbTemp) CommonUtil.copyPropertyForSave(swDjJbb, swDjJbbTemp);
            } else {
                jbbId = UUIDGenerator.generate();
                swDjJbbTemp.setJbbId(jbbId);
            }
            swDjJbbTemp.setTempId(tempId);
            swDjJbbTemp.setSgyMc(username);
            String regionCode = SessionUtil.getCurrentUser().getRegionCode();
            String zgkgDm = "2" + regionCode + "00";
            String zgkgMc= dicService.findMcByDm("zgkg", zgkgDm);
            swDjJbbTemp.setZgkgDm(zgkgDm);
            swDjJbbTemp.setZgkgMc(zgkgMc);

            swDjSyTemp.setSwDjJbbTemp(swDjJbbTemp);

            SwDjTdTemp swDjTdTemp = new SwDjTdTemp();
            swDjTdTemp.setTempId(tempId);
            swDjTdTemp.setSyId(syId);
            if (zd != null)
                swDjTdTemp.setTddj(zd.getTddj());
            swDjSyTemp.setSwDjTdTemp(swDjTdTemp);

            syhcService.saveSyTemp(swDjSyTemp);
        }
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setMsg(tempId);
        return  responseMessage;
    }

    //根据djh,jbbId,proid创建一个临时的税源信息，存放在临时表中
    @RequestMapping("createNewSyFcTemp")
    @ResponseBody
    public Object createNewSyFcTemp(Model model, String djh, String jbbId, String proid)throws Exception{
        String tempId = "";

        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("syzt", QueryCondition.EQ, Syzt.LS.toString()));
        queryConditionList.add(new QueryCondition("swDjJbbTemp.jbbId", QueryCondition.EQ, jbbId));
        queryConditionList.add(new QueryCondition("swHcXmRwRel.rwId", QueryCondition.EQ, proid));
        queryConditionList.add(new QueryCondition("swDjFcTemp.syId is not null"));
        List<SwDjSyTemp> swDjSyTempList = taxService.findSyTempList(queryConditionList);

        String syId = UUIDGenerator.generate();
        tempId = UUIDGenerator.generate();
        String userId = SessionUtil.getCurrentUserId();
        String username = SessionUtil.getCurrentUser().getUsername();
        Date updateRq = Calendar.getInstance().getTime();
        if (CollectionUtils.isNotEmpty(swDjSyTempList)) {
            tempId = swDjSyTempList.get(0).getTempId();

            swDjSyTempList.get(0).getSwDjJbbTemp().setSgyMc(username);
            String regionCode = SessionUtil.getCurrentUser().getRegionCode();
            String zgkgDm = "2" + regionCode + "00";
            String zgkgMc= dicService.findMcByDm("zgkg", zgkgDm);
            swDjSyTempList.get(0).getSwDjJbbTemp().setZgkgDm(zgkgDm);
            swDjSyTempList.get(0).getSwDjJbbTemp().setZgkgMc(zgkgMc);

            syhcService.saveSyTemp(swDjSyTempList.get(0));
        } else {
            SwDjSyTemp swDjSyTemp = new SwDjSyTemp();

            swDjSyTemp.setTempId(tempId);

            swDjSyTemp.setSyId(syId);
            swDjSyTemp.setSjly(Sjly.SYHC.toString());
            swDjSyTemp.setSyzt(Syzt.LS.toString());
            swDjSyTemp.setBz("核查入库");
            swDjSyTemp.setUpdateRq(updateRq);
            swDjSyTemp.setUpdateUserid(userId);
            swDjSyTemp.setUpdateUsername(username);
            swDjSyTemp.setCzlx(Czlx.INSERT.toString());

            if (StringUtils.isNotEmpty(djh)) {
                Zd zd = new Zd();
                zd.setDjh(djh);
                swDjSyTemp.setZd(zd);
                swDjSyTemp.setGtly(Gtlx.ZD.toString());
            }

            SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
            swHcXmRwRel = hcxmService.getCurSwHcXmRwRelByProid(proid);
            swDjSyTemp.setSwHcXmRwRel(swHcXmRwRel);

            SwDjJbbTemp swDjJbbTemp = new SwDjJbbTemp();
            if (StringUtils.isNotEmpty(jbbId)) {
                SwDjJbb swDjJbb = baseRepository.get(SwDjJbb.class, jbbId);
                swDjJbbTemp = (SwDjJbbTemp) CommonUtil.copyPropertyForSave(swDjJbb, swDjJbbTemp);
            } else {
                swDjJbbTemp.setJbbId(UUIDGenerator.generate());
            }
            swDjJbbTemp.setTempId(tempId);
            swDjJbbTemp.setSgyMc(username);
            String regionCode = SessionUtil.getCurrentUser().getRegionCode();
            String zgkgDm = "2" + regionCode + "00";
            String zgkgMc= dicService.findMcByDm("zgkg", zgkgDm);
            swDjJbbTemp.setZgkgDm(zgkgDm);
            swDjJbbTemp.setZgkgMc(zgkgMc);
            swDjSyTemp.setSwDjJbbTemp(swDjJbbTemp);

            String jsblConf = AppConfig.getProperty("jsbl");
            if (StringUtils.isBlank(jsblConf)) {
                jsblConf = "0.7";
            }
            BigDecimal jsbl = new BigDecimal(jsblConf);
            SwDjFcTemp swDjFcTemp = new SwDjFcTemp();
            swDjFcTemp.setTempId(tempId);
            swDjFcTemp.setSyId(syId);
            swDjFcTemp.setJsbl(jsbl);
            swDjSyTemp.setSwDjFcTemp(swDjFcTemp);

            syhcService.saveSyTemp(swDjSyTemp);
        }
        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setMsg(tempId);
        return  responseMessage;
    }

    //根据临时表主键tempId获取税源信息进行查看和编辑
    @RequestMapping("update")
    public  String  update(Model model,String tempId,String noSave,String noPrint,String noBack){

        SwDjSyTemp swDjSyTemp = baseRepository.get(SwDjSyTemp.class,tempId);
        if(noSave==null){
            noSave = " 2 ";
        }

        model.addAttribute("swDjSyTemp", swDjSyTemp);
        model.addAttribute("noBack",noBack);
        model.addAttribute("noPrint",noPrint);
        model.addAttribute("noSave",noSave);
        return "landtax/fzjc/syxxTz";

    }

    //删除税源，将税源状态更改为3
    @RequestMapping("delete")
    @ResponseBody
    public  Object delete(Model model,String tempId)throws Exception{
        ResponseMessage responseMessage = new ResponseMessage();
        String msg="";
        try{
            syhcService.deleteSwdjSy(tempId);
            responseMessage.setMsg("删除成功!");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，删除失败！");
        }
        return responseMessage;
    }

    @RequestMapping("exportExcelSytz")
    public String exportExcelSytz(HttpServletRequest request, String proid, String sylx, String gridOptions){
        try {
            String title = "";

            SwHcXmRwRel swHcXmRwRel = hcxmService.getCurSwHcXmRwRelByProid(proid);
            List<SwDjSyTemp> swDjSyTempList = syhcService.getSyxx(swHcXmRwRel.getShxrId());
            List<SwDjSyTemp> list = new ArrayList<SwDjSyTemp>();

            if (Sylx.TDSY.toString().equals(sylx)) {
                title = "城镇土地税税源列表";
                for (SwDjSyTemp swDjSyTemp : swDjSyTempList) {
                    if (Syzt.ZC.toString().equals(swDjSyTemp.getSyzt()) && swDjSyTemp.getSwDjTdTemp() != null) {
                        list.add(swDjSyTemp);
                    }
                }
            } else {
                title = "房产税税源列表";
                for (SwDjSyTemp swDjSyTemp : swDjSyTempList) {
                    if (Syzt.ZC.toString().equals(swDjSyTemp.getSyzt()) && swDjSyTemp.getSwDjFcTemp() != null) {
                        list.add(swDjSyTemp);
                    }
                }
            }

            com.alibaba.fastjson.JSONObject jsonObject = (new com.alibaba.fastjson.JSONObject()).parseObject(gridOptions);
            PrintGridExcelUtil printGridExcel = new PrintGridExcelUtil();
            printGridExcel.setTitle(title);
            printGridExcel.setGridOptions(jsonObject);
            printGridExcel.printGridExcel(request, list);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }
}

