package cn.gtmap.landtax.web.map;


import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.MapService;
import cn.gtmap.landtax.support.spring.BaseController;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;

/**
 * .
 * <p/>
 * 地图应用
 *
 * @author yang
 * @version V1.0, 14-5-26
 */
@Controller
@RequestMapping("/map")
public class MapController extends BaseController {

    @Autowired
    DwxxService dwxxService;
    @Autowired
    MapService mapService;
    @Autowired
    HcxmService hcxmService;
    /**
     *
     * @param model
     * @param xzqdm 行政区代码
     * @param djh 地籍号
     * @param proid 核查工作流项目ID
     * @return
     */
    @RequestMapping("/index")
    public String showMap(Model model,String xzqdm,String djh,String proid) {
        if(StringUtils.isBlank(xzqdm))
            xzqdm = SessionUtil.getCurrentUser().getRegionCode();
        if(xzqdm.length()>6)
            xzqdm = xzqdm.substring(0,6);
        /*
        if(AppConfig.getProperty("zsfjdm").equals(xzqdm)){
            xzqdm = xzqdm.substring(0,4);
        }
        */
        Map cityMap = getCityMap(xzqdm);
        List counties = getCounties(xzqdm);
        model.addAttribute("city",cityMap);
        model.addAttribute("counties",counties);
        if(cityMap!=null){  //市级用户
            model.addAttribute("xzqdm",cityMap.get("xzqdm"));
            model.addAttribute("xzqmc",cityMap.get("xzqmc"));
        }else{
            if(counties.size()>0){  //县级
                Map county = (Map)counties.get(0);
                // 尝试获取自己的行政区名称
                for (int i = 0; i < counties.size(); i++) {
                    if (xzqdm.equals(((Map)counties.get(i)).get("xzqdm"))) {
                        county = (Map)counties.get(i);
                        break;
                    }
                }
                model.addAttribute("xzqdm",county.get("xzqdm"));
                model.addAttribute("xzqmc",county.get("xzqmc"));
            }else{  //分局
                String tmpXzqdm = StringUtils.substring(xzqdm,0,6);
                model.addAttribute("xzqdm",tmpXzqdm);
                SDmDwxxCz sDmDwxxCz = dwxxService.getDwxxByDwdm(tmpXzqdm);
                model.addAttribute("xzqmc",sDmDwxxCz==null?"":sDmDwxxCz.getDwmc());
            }
        }

        if(StringUtils.isNotEmpty(djh)){
            model.addAttribute("djh",djh);
        }
        if(StringUtils.isNotEmpty(proid)){
            model.addAttribute("proid",proid);
        }

        return "landtax/map/map";
    }


    @RequestMapping("/queryMap")
    public String queryMap(Model model) {
        return "landtax/querymap";
    }

    @RequestMapping("/config")
    @ResponseBody
    public Object mapConfig(Model model) throws Exception {
        return mapService.getMapConfig();
    }



    private Map getCityMap(String xzqdm){
        Map cityMap=null;
        if(StringUtils.endsWith(xzqdm,"00"))
            xzqdm = StringUtils.strip(xzqdm,"00");
        SDmDwxxCz sDmDwxxCz = dwxxService.getCityByDwdm(xzqdm);
        if(sDmDwxxCz!=null){
            cityMap = Maps.newHashMap();
            cityMap.put("xzqdm",sDmDwxxCz.getDwdm());
            cityMap.put("xzqmc",sDmDwxxCz.getDwmc());
        }
        return cityMap;
    }
    private List getCounties(String xzqdm){
        List counties = Lists.newArrayList();
        Map countyMap =null;
        if(StringUtils.endsWith(xzqdm,"00"))
            xzqdm = StringUtils.strip(xzqdm,"00");
        List<SDmDwxxCz> sDmDwxxCzList = dwxxService.getCountiesByDwdm(xzqdm);
        for(SDmDwxxCz sDmDwxxCz:sDmDwxxCzList){
            countyMap = Maps.newHashMap();
            countyMap.put("xzqdm",sDmDwxxCz.getDwdm());
            countyMap.put("xzqmc",sDmDwxxCz.getDwmc());
            counties.add(countyMap);
        }
        return counties;
    }





}
