package cn.gtmap.landtax.web.jdtj;


import cn.gtmap.landtax.model.query.DictTreeGrid;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.persistence.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Controller
@RequestMapping("/jdtj")
public class JdtjController {
    @Autowired
    BaseRepository baseRepository;

    //税源土地挂接进度
    @RequestMapping("gjZdJd")
    public String gjZdJd(){
        return "landtax/jdtj/gjZdJd";
    }

    @RequestMapping("gjZdJdJson")
    @ResponseBody
    public Object gjZdJdJson(String id){
        String sql = "";
        UserInfo userInfo = SessionUtil.getCurrentUser();
        String regionCode = userInfo.getRegionCode();
        Integer length  = regionCode.length();
        String where = "";
        if(StringUtils.isNotBlank(id)){//说明是点击节点加载
            regionCode = id;
            length = regionCode.length()+3;
            where = " where t1.DWDM like '"+regionCode+"%' ";
        }else{
            where = " where t1.DWDM='"+regionCode+"' ";
        }
        sql = "SELECT to_char(t1.DWDM)DWDM, to_char(DECODE(t3.DWMC, NULL, t1.DWDM, '', t1.DWDM, t3.DWMC)) AS DWMC, " +
                "       to_char(t1.ZS)ZS, to_char(NVL(t2.ZDPP, 0))ZDPP, to_char(NVL(t2.RGPP, 0))RGPP, to_char((NVL(t1.ZS, 0) - NVL(t2.GJZS, 0))) AS WGJS, to_char(NVL(t2.GJZS, 0)) AS GJZS ,ROUND(NVL(t2.GJZS, 0)/t1.ZS*100,2)PPL " +
                "FROM (" +
                "      SELECT SUBSTR(t1.DJH, 1, "+length+") AS DWDM, COUNT(DJH) AS ZS " +
                "      FROM ZD t1 " +
                "      GROUP BY SUBSTR(t1.DJH, 1, "+length+") " +
                "     ) t1 " +
                "LEFT JOIN (" +
                "                SELECT SUBSTR(t1.GT_BM, 1, "+length+") AS DWDM, SUM(DECODE(SJLY, '1', 1, 0)) AS ZDPP, SUM(DECODE(SJLY, '2', 1, 0)) AS RGPP, COUNT(SJLY) AS GJZS " +
                "                FROM (SELECT GT_BM, MAX(SJLY) AS SJLY " +
                "                       FROM SW_DJ_SY t1 " +
                "                       WHERE SJLY IN ('1', '2') AND SYZT = '1' " +
                "                       GROUP BY GT_BM) t1 " +
                "                GROUP BY SUBSTR(t1.GT_BM, 1, "+length+") " +
                "          ) t2 ON t1.DWDM=t2.DWDM " +
                "LEFT JOIN S_DM_DWXX_CZ t3 ON t1.DWDM=t3.DWDM";

        sql =  sql + where;

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        List<DictTreeGrid> resultList = new ArrayList<DictTreeGrid>();
        if(CollectionUtils.isNotEmpty(list)){
            for(HashMap tempMap : list){
                DictTreeGrid tempGrid = new DictTreeGrid();
                tempGrid.setDwdm(String.valueOf(tempMap.get("DWDM")));
                tempGrid.setDwmc(String.valueOf(tempMap.get("DWMC")));
                tempGrid.setZs(String.valueOf(tempMap.get("ZS")));
                tempGrid.setZdpp(String.valueOf(tempMap.get("ZDPP")));
                tempGrid.setRgpp(String.valueOf(tempMap.get("RGPP")));
                tempGrid.setWgjs(String.valueOf(tempMap.get("WGJS")));
                tempGrid.setGjzs(String.valueOf(tempMap.get("GJZS")));
                tempGrid.setPpl(String.valueOf(tempMap.get("PPL")));
                if(length==12){
                    tempGrid.setState("open");
                }
                tempGrid.setIconCls("empty");
                resultList.add(tempGrid);
            }
        }
        return resultList;



    }

    //土地税挂接进度
    @RequestMapping("gjTdJd")
    public String gjTdJd(){
        return "landtax/jdtj/gjTdJd";
    }

    @RequestMapping("gjTdJdJson")
    @ResponseBody
    public Object gjTdJdJson(String id){
        String sql = "";
        String where = "";
        Integer length  = 7;

        if(StringUtils.isNotBlank(id)){//说明是点击节点加载
            length = id.length()+4;
            where = " where t1.DWDM like '"+id+"%' ";
        }
        sql = "SELECT t1.*, ROUND(NVL(t1.GJZS, 0)/t1.ZS*100,2) PPL,DECODE(t3.DWMC, NULL, t1.DWDM, t3.DWMC) AS DWMC " +
                "FROM (" +
                "      SELECT SUBSTR(t3.ZGKG_DM,1,"+length+") AS DWDM, COUNT(*) AS ZS ,SUM(DECODE(t2.SJLY, '1', 1, 0)) AS ZDPP, " +
                "             SUM(DECODE(t2.SJLY, '2', 1, 0)) AS RGPP, SUM(DECODE(t2.SJLY, '0', 1, '4', 1, 0)) AS WGJS," +
                "             SUM(DECODE(t2.SJLY, '1', 1, '2', 1, 0)) AS GJZS " +
                "      FROM SW_DJ_TD t1 " +
                "           JOIN SW_DJ_SY t2 on t1.SY_ID=t2.SY_ID " +
                "           JOIN SW_DJ_JBB t3 on t2.JBB_ID=t3.JBB_ID " +
                "      WHERE t2.SYZT='1' " +
                "      GROUP BY SUBSTR(t3.ZGKG_DM,1,"+length+") " +
                "     ) t1 " +
                "LEFT JOIN (" +
                "           SELECT DWMC, '2'||DWDM AS DWDM " +
                "           FROM S_DM_DWXX_CZ " +
                "           WHERE DWJB=1 " +
                "           UNION ALL " +
                "           SELECT MC AS DWMC, SWBMBM AS DWDM " +
                "           FROM  DM_SWBM " +
                "          ) t3 ON t1.DWDM=t3.DWDM";

        sql =  sql + where;

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        List<DictTreeGrid> resultList = new ArrayList<DictTreeGrid>();
        if(CollectionUtils.isNotEmpty(list)){
            for(HashMap tempMap : list){
                DictTreeGrid tempGrid = new DictTreeGrid();
                tempGrid.setDwdm(String.valueOf(tempMap.get("DWDM")));
                tempGrid.setDwmc(String.valueOf(tempMap.get("DWMC")));
                tempGrid.setZs(String.valueOf(tempMap.get("ZS")));
                tempGrid.setZdpp(String.valueOf(tempMap.get("ZDPP")));
                tempGrid.setRgpp(String.valueOf(tempMap.get("RGPP")));
                tempGrid.setWgjs(String.valueOf(tempMap.get("WGJS")));
                tempGrid.setGjzs(String.valueOf(tempMap.get("GJZS")));
                tempGrid.setPpl(String.valueOf(tempMap.get("PPL")));
                if(length==11){
                    tempGrid.setState("open");
                }
                tempGrid.setIconCls("empty");
                resultList.add(tempGrid);
            }
        }
        return resultList;
    }

    //房产税挂接进度
    @RequestMapping("gjFcJd")
    public String gjFcJd(){
        return "landtax/jdtj/gjFcJd";
    }

    @RequestMapping("gjFcJdJson")
    @ResponseBody
    public Object gjFcJdJson(String id){
        String sql = "";
        String where = "";
        Integer length  = 7;

        if(StringUtils.isNotBlank(id)){//说明是点击节点加载
            length = id.length()+4;
            where = " where t1.DWDM like '"+id+"%' ";
        }
        sql = "SELECT t1.*, ROUND(NVL(t1.GJZS, 0)/t1.ZS*100,2) PPL, DECODE(t3.DWMC, NULL, t1.DWDM, t3.DWMC) AS DWMC " +
                "FROM (" +
                "      SELECT SUBSTR(t3.ZGKG_DM,1,"+length+") AS DWDM, COUNT(*) AS ZS ,SUM(DECODE(t2.SJLY, '1', 1, 0)) AS ZDPP, " +
                "             SUM(DECODE(t2.SJLY, '2', 1, 0)) AS RGPP, SUM(DECODE(t2.SJLY, '0', 1, '4', 1, 0)) AS WGJS," +
                "             SUM(DECODE(t2.SJLY, '1', 1, '2', 1, 0)) AS GJZS " +
                "      FROM SW_DJ_FC t1 " +
                "           JOIN SW_DJ_SY t2 on t1.SY_ID=t2.SY_ID " +
                "           JOIN SW_DJ_JBB t3 on t2.JBB_ID=t3.JBB_ID " +
                "      WHERE t2.SYZT='1' " +
                "      GROUP BY SUBSTR(t3.ZGKG_DM,1,"+length+") " +
                "     ) t1 " +
                "LEFT JOIN (" +
                "           SELECT DWMC, '2'||DWDM AS DWDM " +
                "           FROM S_DM_DWXX_CZ " +
                "           WHERE DWJB=1 " +
                "           UNION ALL " +
                "           SELECT MC AS DWMC, SWBMBM AS DWDM " +
                "           FROM  DM_SWBM " +
                "          ) t3 ON t1.DWDM=t3.DWDM";

        sql =  sql + where;

        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        List<DictTreeGrid> resultList = new ArrayList<DictTreeGrid>();
        if(CollectionUtils.isNotEmpty(list)){
            for(HashMap tempMap : list){
                DictTreeGrid tempGrid = new DictTreeGrid();
                tempGrid.setDwdm(String.valueOf(tempMap.get("DWDM")));
                tempGrid.setDwmc(String.valueOf(tempMap.get("DWMC")));
                tempGrid.setZs(String.valueOf(tempMap.get("ZS")));
                tempGrid.setZdpp(String.valueOf(tempMap.get("ZDPP")));
                tempGrid.setRgpp(String.valueOf(tempMap.get("RGPP")));
                tempGrid.setWgjs(String.valueOf(tempMap.get("WGJS")));
                tempGrid.setGjzs(String.valueOf(tempMap.get("GJZS")));
                tempGrid.setPpl(String.valueOf(tempMap.get("PPL")));
                if(length==11){
                    tempGrid.setState("open");
                }
                tempGrid.setIconCls("empty");
                resultList.add(tempGrid);
            }
        }
        return resultList;
    }
}
