package cn.gtmap.landtax.web.hcxm;

import cn.gtmap.landtax.entity.TjBaseParamVo;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.print.PrintGridExcelUtil;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.service.WorkFlowService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.persistence.Query;
import javax.servlet.http.HttpServletRequest;
import java.text.DecimalFormat;
import java.util.*;

/**
 * Created by zhouzhiwei on 2015/9/2.
 */
@Controller
@RequestMapping("/hcxm")
public class HcxmController {
    @Autowired
    TjService tjService;
    @Autowired
    WorkFlowService workFlowService;
    @Autowired
    SysUserService sysUserService;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    BaseRepository baseRepository;


    @RequestMapping("")
    public String hcxm(Model model, String hcxmlx, String customParams, String forbiddenList) {
        model.addAttribute("hcxmlx",hcxmlx);
        String tag = getTag(hcxmlx);

        // 如果是无需创建任务的列表，tag值后面加Forbidden
        if (StringUtils.isNotEmpty(forbiddenList)) {
            tag = tag + "Forbidden";
            model.addAttribute("forbiddenList", true);
        } else {
            model.addAttribute("forbiddenList", false);
        }

        model.addAttribute("tag",tag);
        model.addAttribute("customParams", customParams);
        TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tag);
        if (tjBaseParamVo != null) {
            model.addAttribute("colJson", tjBaseParamVo.getColJson());
            model.addAttribute("headPageFile", tjBaseParamVo.getHeadPageFile());
            model.addAttribute("reportName", tjBaseParamVo.getReportName());
            if (StringUtils.isNotBlank(tjBaseParamVo.getExcelTemplate()) && StringUtils.isNotBlank(tjBaseParamVo.getExcelXml()) && StringUtils.isNotBlank(tjBaseParamVo.getExportFieldList())) {
                model.addAttribute("needExport", "true");
            }
            if (tjBaseParamVo.isNeedExport()) {
                model.addAttribute("autoExport", "true");
            }
        }

        return "landtax/hcxm/baseHcxmTz";
    }

    /**
     * 将核查项目中指定id的记录标记为不需要创建核查任务
     * @param model
     * @param hcxmlx
     * @param ids
     * @return
     */
    @RequestMapping("forbiddenCreateHcxm")
    @ResponseBody
    public Object forbiddenCreateHcxm(Model model, String hcxmlx, String ids, String bz) {
        ResponseMessage responseMessage = new ResponseMessage();

        try {
            String[] idArray = ids.split(",");
            List<String> idList = Arrays.asList(idArray);
            hcxmService.signForbiddenCreateHcxm(hcxmlx, idList, bz);
        } catch (Exception e) {
            responseMessage.setMsg(e.getMessage());
        }

        return responseMessage;
    }

    /**
     * 将核查项目中被标记为不需要创建核查任务中的指定id的记录重新标记为需要创建核查任务
     * @param model
     * @param hcxmlx
     * @param ids
     * @return
     */
    @RequestMapping("needCreateHcxm")
    @ResponseBody
    public Object needCreateHcxm(Model model, String hcxmlx, String ids) {
        ResponseMessage responseMessage = new ResponseMessage();

        try {
            String[] idArray = ids.split(",");
            List<String> idList = Arrays.asList(idArray);
            hcxmService.signNeedCreateHcxm(hcxmlx, idList);
        } catch (Exception e) {
            responseMessage.setMsg(e.getMessage());
        }

        return responseMessage;
    }

    @RequestMapping("createSelHcxm")
    @ResponseBody
    public Object createSelHcxm (Model model, String hcxmlx, String tag, String ids, String fjdm) {
        ResponseMessage responseMessage = new ResponseMessage();

        if (StringUtils.isEmpty(tag))
            tag = getTag(hcxmlx);

        TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tag);
        if (tjBaseParamVo == null) {
            return null;
        }
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();

        ids = ids.replaceAll(",", "','");
        queryConditionList.add(new QueryCondition(" rwbm in ('" + ids + "')"));
        List<HashMap> list = (List<HashMap>)tjService.getTjList(tag, queryConditionList);

        if (fjdm != null && !fjdm.equals("32038103")) {
            fjdm = null;
        }
        String msg = createAndTurnWf(hcxmlx, list, fjdm);
        responseMessage.setMsg(msg);

        return responseMessage;
    }

    @RequestMapping("createAllHcxm")
    @ResponseBody
    public Object createAllHcxm (Model model, String hcxmlx, String tag, String query, String customParams, String fjdm, String mjyz) {
        ResponseMessage responseMessage = new ResponseMessage();

        if (StringUtils.isEmpty(tag))
            tag = getTag(hcxmlx);

        TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tag);
        if (tjBaseParamVo == null) {
            return null;
        }
        List<QueryCondition> queryConditionList = CommonUtil.initQueryCondition(query);
        queryConditionList = addCustomParams(queryConditionList, customParams);

        if (hcxmlx.equals(Hcxmlx.ZDHC.toString())) {
            queryConditionList.add(new QueryCondition("MJHJ_GT", QueryCondition.GE, mjyz));
        } else if (hcxmlx.equals(Hcxmlx.SYHC.toString())) {
            queryConditionList.add(new QueryCondition("MJHJ_SW", QueryCondition.GE, mjyz));
        } else if (hcxmlx.equals(Hcxmlx.MJBYZHC.toString())) {
            queryConditionList.add(new QueryCondition("MJCZ", QueryCondition.GE, mjyz));
        }
        List<HashMap> list = (List<HashMap>)tjService.getTjList(tag, queryConditionList);

        if (fjdm != null && !fjdm.equals("32038103")) {
            fjdm = null;
        }
        String msg = createAndTurnWf(hcxmlx, list, fjdm);
        responseMessage.setMsg(msg);

        return responseMessage;
    }

    @RequestMapping("hcjd")
    public String hcjd(Model model,String hcxmlx){
        model.addAttribute("hcxmlx",hcxmlx);
        return "landtax/hcxm/hcjd";
    }

    @RequestMapping("hcjdRootJson")
    @ResponseBody
    public Object hcjdRootJson(Model model,String hcxmlx,String id){
        Object obj = hcxmService.hcjdRootJson(hcxmlx,id);
        return obj;
    }

    @RequestMapping("getTipMsg")
    @ResponseBody
    public Object getTipMsg(Model model, String hcxmlx, String tag, String query, String customParams){
        List<QueryCondition> queryConditionList = CommonUtil.initQueryCondition(query);
        queryConditionList = addCustomParams(queryConditionList, customParams);

        if (StringUtils.isEmpty(tag))
            tag = getTag(hcxmlx);

        String sql = tjService.getTjSql(tag);

        String msg = "";
        String resultExpression = "";
        if (hcxmlx.equals(Hcxmlx.ZDHC.toString())) {
            resultExpression = "NVL(SUM(MJHJ_GT),0) AS MJHJ_GT";
            Query querylist = tjService.createQuery(sql, resultExpression,queryConditionList, null, false);
            querylist.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            List<HashMap> list = querylist.getResultList();
            if (CollectionUtils.isNotEmpty(list)) {
                msg = "国土发证面积合计：" + formatString("#,##0.00", list.get(0).get("MJHJ_GT").toString()) + "平方米";
            }
        } else if (hcxmlx.equals(Hcxmlx.SYHC.toString())) {
            resultExpression = "NVL(SUM(MJHJ_SW),0) AS MJHJ_SW";
            Query querylist = tjService.createQuery(sql, resultExpression, queryConditionList, null, false);
            querylist.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            List<HashMap> list = querylist.getResultList();
            if (CollectionUtils.isNotEmpty(list)) {
                msg = "土地税面积合计：" + formatString("#,##0.00", list.get(0).get("MJHJ_SW").toString()) + "平方米";
            }
        } else if (hcxmlx.equals(Hcxmlx.MJBYZHC.toString())) {
            resultExpression = "NVL(SUM(MJHJ_GT),0) AS MJHJ_GT, NVL(SUM(MJHJ_SW),0) AS MJHJ_SW, NVL(SUM(MJCZ),0) AS MJCZ";
            Query querylist = tjService.createQuery(sql, resultExpression, queryConditionList, null, false);
            querylist.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            List<HashMap> list = querylist.getResultList();
            if (CollectionUtils.isNotEmpty(list)) {
                msg = "税务面积合计：" + formatString("#,##0.00", list.get(0).get("MJHJ_SW").toString()) + "平方米，" +
                      "国土发证面积合计：" + formatString("#,##0.00", list.get(0).get("MJHJ_GT").toString()) + "平方米，" +
                      "面积差值合计：" + formatString("#,##0.00", list.get(0).get("MJCZ").toString()) + "平方米";
            }
        }

        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setMsg(msg);
        return responseMessage;
    }

    private String createAndTurnWf(String hcxmlx, List<HashMap> list, String fjdm) {
        String resultStr = null;
        int countSuccess = 0;
        List<PfUserVo> toUserList = null;

        String rwIdField = "RWBM";
        String reginCodeField = "FJDM";
        String rwId = "";
        String wiid = "";
        String toUserId = "";
        for (HashMap hashMap : list) {
            rwId = (hashMap.get(rwIdField) == null) ? "" : hashMap.get(rwIdField).toString();

            if (hcxmService.getCurSwHcXmRwRelByRwid(rwId) != null) {
                continue;
            }
            wiid = workFlowService.wfCreate(hcxmlx, rwId, true);

            // 获取用户列表
            if (toUserList == null) {
                PerformerTaskModel result = null;
                try {
                    result = workFlowService.getTurnUserList(SessionUtil.getCurrentUserId(), wiid);
                    toUserList = result.getUserList();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            if (!wiid.startsWith("java.lang:")) {
                if (StringUtils.isEmpty(fjdm))
                    fjdm = (hashMap.get(reginCodeField) == null) ? "" : hashMap.get(reginCodeField).toString();

                for(PfUserVo pfUserVo : toUserList){

                    String regionCode = sysUserService.getRegionCodeByUserId(pfUserVo.getUserId());
                    if(regionCode.length() > 8){
                        regionCode = regionCode.substring(0, 8);
                    }
                    if(regionCode.startsWith(fjdm)){
                        toUserId = pfUserVo.getUserId();
                        break;
                    }
                }

                workFlowService.autoTurnWorkflow(wiid, toUserId);

                countSuccess++;
            } else {
                resultStr = wiid;
                break;
            }
        }

        if (resultStr == null) {
            resultStr = String.valueOf(countSuccess);
        }

        return resultStr;
    }

    private String getTag(String hcxmlx) {
        String tag = "";

        if (hcxmlx.equals(Hcxmlx.ZDHC.toString())) {
            tag = "zdhc";
        } else if (hcxmlx.equals(Hcxmlx.SYHC.toString())) {
            tag = "syhc";
        } else if (hcxmlx.equals(Hcxmlx.MJBYZHC.toString())) {
            tag = "zdsymjdfTj";
        }

        return tag;
    }

    private List<QueryCondition> addCustomParams(List<QueryCondition> queryConditionList, String customParams) {
        if (queryConditionList == null)
            queryConditionList = new ArrayList<QueryCondition>();

        if (StringUtils.isNotBlank(customParams)) {
            List<QueryCondition> customQueryConditionList = CommonUtil.initQueryCondition(customParams);
            for (int i = 0; i < customQueryConditionList.size(); i++) {
                queryConditionList.add(customQueryConditionList.get(i));
            }
        }

        return queryConditionList;
    }

    private String formatString(String formatExpression, String value) {
        DecimalFormat decimalFormat = new DecimalFormat(formatExpression);
        String formatResult = value;
        try {
            formatResult = decimalFormat.format(Double.valueOf(value));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return formatResult;
    }

    /**
     * 获取当前用户参与该流程的任务URL地址
     * @param model
     * @param proid
     * @return
     */
    @RequestMapping("getTaskUrl")
    @ResponseBody
    public Object getTaskUrl(Model model, String proid){
        // 获取用户ID
        UserInfo user = SessionUtil.getCurrentUser();
        String userId = user.getId();

        String sql = "";
        Query query = null;

        // 根据任务某个节点的ID获取任务当前节点的ID
        sql = "SELECT USER_ID, ASSIGNMENT_ID, BEGIN_TIME, BJ, " +
                "       RANK() OVER(PARTITION BY USER_ID ORDER BY BEGIN_TIME DESC) AS YHPM, " +
                "       RANK() OVER(ORDER BY BEGIN_TIME DESC) AS JDPM " +
                "FROM ( " +
                "      SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME, ASSIGNMENT_ID, 0 AS BJ " +
                "      FROM PF_ASSIGNMENT " +
                "      UNION " +
                "      SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME, ASSIGNMENT_ID, 1 AS BJ " +
                "      FROM PF_ASSIGNMENTHISTORY " +
                "     ) t\n" +
                "WHERE t.ACTIVITY_ID IN ( " +
                "      SELECT ACTIVITY_ID " +
                "      FROM PF_ACTIVITY " +
                "      WHERE WORKFLOW_INSTANCE_ID='" + proid + "' " +
                "      ) ";
        sql = "SELECT * FROM (" + sql + ") WHERE USER_ID='" + userId + "' AND YHPM=1 AND ROWNUM=1 ";
        query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String, Object>> list = query.getResultList();

        String url = "";
        String taskid = "";
        if (CollectionUtils.isNotEmpty(list)){  // 该用户对该流程已办理
            taskid = list.get(0).get("ASSIGNMENT_ID").toString();
            String jdpm = list.get(0).get("JDPM").toString();
            String bj = list.get(0).get("BJ").toString();
            if (jdpm.equals("1") && bj.equals("0")) {
                url = "taskhandle.action?taskid=" + taskid;
            } else {
                url = "taskoverhandle.action?taskid=" + taskid;
            }
        } else {  // 该用户未参与流程
            url = "";
        }

        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setMsg(url);
        return responseMessage;
    }

    //未处理已处理台帐
    @RequestMapping("wclYclTz")
    public String wclTz(Model model, String hcxmlx, String xzqdm, String xflx, String cllx){
        model.addAttribute("hcxmlx",hcxmlx);
        model.addAttribute("xzqdm",xzqdm);
        model.addAttribute("cllx",cllx);//1表示未处理台帐，2表示已处理台帐
        model.addAttribute("xflx",xflx);//0表示已下发，1表示未下发

        String name = Hcxmlx.getMcByDm(hcxmlx);
        if(StringUtils.isNotBlank(cllx) && "1".equals(cllx)){
            name = name + "未处理任务详情";
        }else if(StringUtils.isNotBlank(cllx) && "2".equals(cllx)){
            name = name + "已处理任务详情";
        }
        model.addAttribute("reportName", name);

        return "landtax/hcxm/wclYclTz";
    }

    @RequestMapping("wclYclTzJson")
    @ResponseBody
    // cllx：处理类型，“1”为未处理，“2”为已处理
    public Object wclYclTzJson(Model model, Pageable pageable, String hcxmlx, String xzqdm, String xflx, String cllx, String query){
        List<QueryCondition> queryConditionList = CommonUtil.initQueryCondition(query);
        return hcxmService.getWclYclTzJson(pageable, hcxmlx, xzqdm, xflx, cllx, queryConditionList);
    }

    @RequestMapping("exportExcelTjEx")
    public String exportExcelTjEx(HttpServletRequest request, String hcxmlx, String xzqdm, String xflx, String cllx, String query, String gridOptions){
        try {
            List<QueryCondition> queryConditionList = CommonUtil.initQueryCondition(query);
            List<HashMap> list = hcxmService.getWclYclTzList(hcxmlx, xzqdm, xflx, cllx, queryConditionList);

            String name = Hcxmlx.getMcByDm(hcxmlx);
            if(StringUtils.isNotBlank(cllx) && "1".equals(cllx)){
                name = name + "未处理任务详情";
            }else if(StringUtils.isNotBlank(cllx) && "2".equals(cllx)){
                name = name + "已处理任务详情";
            }

            com.alibaba.fastjson.JSONObject jsonObject = (new com.alibaba.fastjson.JSONObject()).parseObject(gridOptions);
            PrintGridExcelUtil printGridExcel = new PrintGridExcelUtil();
            printGridExcel.setTitle(name);
            printGridExcel.setGridOptions(jsonObject);
            printGridExcel.printGridExcel(request, list);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return "common/downExcel";
    }
}
