package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.TjBaseParamVo;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.service.ZdbgService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.support.spring.BaseController;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.DateUtils;
import cn.gtmap.landtax.util.QueryCondition;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.persistence.Query;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * Created by zhouzhiwei on 2015-9-30.
 */
@Controller
@RequestMapping("/zdbg")
public class ZdbgController extends BaseController {
    @Autowired
    ZdbgService zdBgService;
    @Autowired
    TjService tjService;
    @Autowired
    BaseRepository baseRepository;


    @RequestMapping("index")
    public String test(Model model) throws Exception {
        Date startDate = DateUtils.now();
        Date endDate = DateUtils.addYears(startDate, -1);

        String tag = "zdbgList";
        model.addAttribute("tag", tag);
        TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tag);
        if (tjBaseParamVo != null) {
            model.addAttribute("colJson", tjBaseParamVo.getColJson());
            model.addAttribute("headPageFile", tjBaseParamVo.getHeadPageFile());
            model.addAttribute("reportName", tjBaseParamVo.getReportName());
            if (StringUtils.isNotBlank(tjBaseParamVo.getExcelTemplate()) && StringUtils.isNotBlank(tjBaseParamVo.getExcelXml()) && StringUtils.isNotBlank(tjBaseParamVo.getExportFieldList())) {
                model.addAttribute("needExport", "true");
            }
            if (tjBaseParamVo.isNeedExport()) {
                model.addAttribute("autoExport", "true");
            }
        }

        return "landtax/zd/zdbg";
    }

    /*
    *  分析更新宗地变更数据
    *  @startDate,分析的变更数据起始时间
    *  @endDate,分析的变更数据结束时间
    *  */
    @RequestMapping("doZdbg")
    @ResponseBody
    public Object doZdbg(Model model, Date startDate, Date endDate) {
        // 分析更新宗地数据
        String dobgid = zdBgService.analyZdBgData(startDate, endDate);
        zdBgService.refreshZdSwRelation(dobgid);
        // 更新税务数据更宗地数据的关联关系
        ResponseMessage responseMessage = new ResponseMessage();
        return responseMessage;
    }

    @RequestMapping("zdbgJson")
    @ResponseBody
    public Object zdbgJson(Model model, Pageable request, String tag, String query) {
        List<QueryCondition> queryConditionList = CommonUtil.initQueryCondition(query);
        Page page = tjService.getTjJson(request, tag, queryConditionList);
        return page;
    }

    @RequestMapping("getZdbgStartRq")
    @ResponseBody
    public Object getZdbgStartRq(Model model) throws Exception {
        String sql = "SELECT MAX(BG_END) AS LASTENDRQ FROM S_SJ_ZDBG_DOBG";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap> list = query.getResultList();

        String startRq = "";
        if (list.get(0).get("LASTENDRQ") != null) {
            Date lastEndRq = (Date)list.get(0).get("LASTENDRQ");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(lastEndRq);
            calendar.add(Calendar.DAY_OF_YEAR, 1);
            startRq = simpleDateFormat.format(calendar.getTime());
        }

        ResponseMessage responseMessage = new ResponseMessage();
        responseMessage.setMsg(startRq);
        return responseMessage;
    }
}
