package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.entity.Zd;
import cn.gtmap.landtax.entity.ZdTemp;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.service.ZdService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.alibaba.fastjson.JSON;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.web.SessionUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.deser.ValueInstantiators;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * .
 * <p/>
 * 宗地
 * @author shenjian
 * @version V1.0, 2014/8/18
 */
@Controller
@RequestMapping("/zd")
public class ZdController {
    @Autowired
    private DwxxService dwxxService;
    @Autowired
    ZdService zdService;
    @Autowired
    BaseRepository baseRepository;

    @RequestMapping("list")
    public String zdList(Model model) {
        //获取所有区县信息
        List<SDmDwxxCz> allQxList = dwxxService.getAllQxList();
        model.addAttribute("allQxList",allQxList);
        return "landtax/fzjc/zdtz";
    }
    @RequestMapping("zdJson")
    @ResponseBody
    public Object zdjson(Pageable pageable,Zd zdQuery, String proid) {
        return zdService.getZdPage(zdQuery, pageable, proid);
    }

    @RequestMapping("getJdByQx")
    @ResponseBody
    public Object getJdByQx(Model model,String qx) {
        List<SDmDwxxCz> jdList = dwxxService.getJdByQx(qx);
        return jdList;
    }

    @RequestMapping("getJfByJd")
    @ResponseBody
    public Object getJfByJd(Model model,String jd) {
        List<SDmDwxxCz> jdList = dwxxService.getJfByJd(jd);
        return jdList;
    }

    @RequestMapping("getSwDjSy")
    @ResponseBody
    public Page getSwDjSy(Model model,String jd) {
        Page<SwDjSy> swDjSyPage = dwxxService.getSwdjSy(null);
        System.out.println(JSON.toJSONString(swDjSyPage));
        return swDjSyPage;
    }

    @RequestMapping("zdInput")
    public String zdInput(Model model,String djh,String tag) throws  Exception{
        Zd zd = baseRepository.get(Zd.class,djh);
        List zdTempList = zdService.zdInput(djh);
        ZdTemp zdTemp = null;
        if(CollectionUtils.isNotEmpty(zdTempList)){
            zdTemp = (ZdTemp)zdTempList.get(0);
        }
        if(zdTemp!=null){
            model.addAttribute("zdTemp",zdTemp);
        }else{
            model.addAttribute("zdTemp",zd);
        }
        model.addAttribute("tag",tag);
        model.addAttribute("zd",zd);

        return "landtax/fzjc/zdxxInput";

    }

    @RequestMapping("zdSave")
    @ResponseBody
    public Object zdSave(Model model,ZdTemp zdTemp) throws  Exception{
        ResponseMessage responseMessage = new ResponseMessage();
        String msg="";
        return responseMessage;
    }

    @RequestMapping("zdQxXg")
    @ResponseBody
    public Object zdQxXg(Model model,ZdTemp zdTemp) throws  Exception{
        String msg="";
        ResponseMessage responseMessage = new ResponseMessage();
        try{
            msg=zdService.zdQxXg(zdTemp);
            responseMessage.setMsg("成功取消修改");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，取消修改失败");
        }
        if(msg!=null&&msg!=""){
            responseMessage.setMsg(msg);
        }
        return responseMessage;
    }

    @RequestMapping("zdTempSave")
    @ResponseBody
    public Object zdTempSave(Model model,ZdTemp zdTemp) throws  Exception{
        ResponseMessage responseMessage = new ResponseMessage();
        try{
            zdService.saveTempZd(zdTemp);
            responseMessage.setMsg("保存成功");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，保存失败");
        }
        return responseMessage;
    }

    @RequestMapping("findZdByDjh")
    @ResponseBody
    public Object findZdByDjh(Model model,String djh){
        Zd zd = zdService.findZdByDjh(djh);
        return zd;
    }
}
