package cn.gtmap.landtax.web.fzjc;


import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Dldm;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.model.dictionary.Sylx;
import cn.gtmap.landtax.entity.SwDjJbb;
import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.entity.SwDjSyTemp;
import cn.gtmap.landtax.entity.Zd;
import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.print.ExportFormExcelUtil;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.print.XMLBuildHelper;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;


/**
 * 税源管理,查询和修改等
 *
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/27
 */
@Controller
@RequestMapping("/ts")
public class TaxSourceController {
    @Autowired
    HcxmService hcxmService;
    @Autowired
    TaxService taxService;
    @Autowired
    SyhcService syhcService;
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    WorkFlowService workFlowService;
    @Autowired
    TjService tjService;

    @RequestMapping("sytz")
    public Object sytz(Model model, String sylx, String noEdit) throws  Exception{
        if (org.apache.commons.lang.StringUtils.isEmpty(sylx))
            sylx = "1";

        model.addAttribute("sylx", sylx);
        model.addAttribute("noEdit", noEdit);

        String tag = null;
        if (sylx.equals("1")) {
            tag = "sytzTds";
        } else {
            tag = "sytzFcs";
        }

        // 获取用户过滤条件
        String customParams = null;
        String regionCode = "";
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (userInfo != null) {
            regionCode = userInfo.getRegionCode();
            // 二分局特殊处理，能看全局
            if (regionCode.equals("32038102"))
                regionCode = "320381";
        }
        customParams = "[{\"REGIONCODE\":\"" + regionCode + "\"},{\"REGIONCODE\":\"" + QueryCondition.LLK + "\"}]";
        model.addAttribute("tag", tag);
        model.addAttribute("customParams", customParams);
        TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tag);
        model.addAttribute("tjBaseParamVo", tjBaseParamVo);
        if (tjBaseParamVo != null) {
            model.addAttribute("colJson", tjBaseParamVo.getColJson());
            model.addAttribute("headPageFile", tjBaseParamVo.getHeadPageFile());
            model.addAttribute("reportName", tjBaseParamVo.getReportName());
            if (org.apache.commons.lang.StringUtils.isNotBlank(tjBaseParamVo.getExcelTemplate()) && org.apache.commons.lang.StringUtils.isNotBlank(tjBaseParamVo.getExcelXml()) && org.apache.commons.lang.StringUtils.isNotBlank(tjBaseParamVo.getExportFieldList())) {
                model.addAttribute("needExport", "true");
            }
            if (tjBaseParamVo.isNeedExport()) {
                model.addAttribute("autoExport", "true");
            }
        }

        return "landtax/fzjc/sytz";
    }

    @RequestMapping("syJson")
    @ResponseBody
    public Object getSwdjSy(Model model,Pageable request,String sylx,SwDjSyQuery swDjSyQuery) {

        if(StringUtils.isBlank(sylx)|| Sylx.TDSY.toString().equals(sylx))
            return taxService.findSwdjTdMap(swDjSyQuery, request);
        else if(StringUtils.isBlank(sylx)|| Sylx.FCSY.toString().equals(sylx))
            return taxService.findSwdjFcMap(swDjSyQuery,request);
        return null;
    }

    @RequestMapping("syxxInput")
    public Object syxxInput(Model model, String syId, String noSave, String noPrint, String noBack, String sylx) throws  Exception{
        SwDjSy swDjSy =(SwDjSy)baseRepository.get(SwDjSy.class, syId);
        if (swDjSy.getZd() == null)
            swDjSy.setZd(new Zd());
        if (swDjSy.getSwDjJbb() == null)
            swDjSy.setSwDjJbb(new SwDjJbb());
        if (swDjSy.getSwDjTd() == null)
            swDjSy.setSwDjTd(new SwDjTd());
        if (swDjSy.getSwDjFc() == null)
            swDjSy.setSwDjFc(new SwDjFc());

        model.addAttribute("sylx", sylx);
        model.addAttribute("swDjSy", swDjSy);
        model.addAttribute("noBack",noBack);
        model.addAttribute("noPrint",noPrint);
        model.addAttribute("noSave",noSave);

        return "landtax/fzjc/syxxTz";

    }

    @RequestMapping("syxxTempInput")
    public  String  syxxTempInput(Model model, String tempId, String noSave, String noPrint, String noBack, String sylx){
        SwDjSyTemp swDjSyTemp = baseRepository.get(SwDjSyTemp.class,tempId);
        if (swDjSyTemp.getZd() == null)
            swDjSyTemp.setZd(new Zd());
        if (swDjSyTemp.getSwDjJbbTemp() == null)
            swDjSyTemp.setSwDjJbbTemp(new SwDjJbbTemp());
        if (swDjSyTemp.getSwDjTdTemp() == null)
            swDjSyTemp.setSwDjTdTemp(new SwDjTdTemp());
        if (swDjSyTemp.getSwDjFcTemp() == null)
            swDjSyTemp.setSwDjFcTemp(new SwDjFcTemp());

        model.addAttribute("swDjSyTemp", swDjSyTemp);
        model.addAttribute("sylx", sylx);
        model.addAttribute("noBack", noBack);
        model.addAttribute("noPrint", noPrint);
        model.addAttribute("noSave", noSave);

        return "landtax/fzjc/syxxTz";

    }


    @RequestMapping("syxxSave")
    @ResponseBody
    public Object syxxSave(Model model, SwDjSy swDjSy, String sylx) throws  Exception{
        ResponseMessage responseMessage = new ResponseMessage();
        String msg = "" ;
        try{
            if (swDjSy.getSwDjJbb() != null) {
                if (org.apache.commons.lang.StringUtils.isEmpty(swDjSy.getSwDjJbb().getJbbId())) {
                    swDjSy.getSwDjJbb().setJbbId(UUIDGenerator.generate());
                }
            }
            taxService.addSwDjSyUpdateInfo(swDjSy, Syzt.ZC.toString());

            taxService.updateSwDjSy(swDjSy);
            responseMessage.setMsg(" 保存成功！ ");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg(" 出现异常，保存失败！ ");
        }
        return responseMessage;
    }

    @RequestMapping("syxxTempSave")
    @ResponseBody
    public Object syxxTempSave(Model model, SwDjSyTemp swDjSyTemp, String sylx) throws  Exception{
        ResponseMessage responseMessage = new ResponseMessage();
        String syId = swDjSyTemp.getSyId();
        String tempId = swDjSyTemp.getTempId();
        String msg = "" ;
        try{
            if(swDjSyTemp.getSwDjTdTemp()==null && (sylx == null || sylx == "1")){
                SwDjTdTemp swDjTdTemp = new SwDjTdTemp();
                swDjTdTemp.setTempId(tempId);
                swDjTdTemp.setSyId(syId);
                swDjSyTemp.setSwDjTdTemp(swDjTdTemp);
            }
            if(swDjSyTemp.getSwDjFcTemp()==null && (sylx == null || sylx == "2")){
                SwDjFcTemp swDjFcTemp = new SwDjFcTemp();
                swDjFcTemp.setTempId(tempId);
                swDjFcTemp.setSyId(syId);
                swDjSyTemp.setSwDjFcTemp(swDjFcTemp);
            }
            if (swDjSyTemp.getSwDjJbbTemp() != null) {
                if (org.apache.commons.lang.StringUtils.isEmpty(swDjSyTemp.getSwDjJbbTemp().getJbbId())) {
                    swDjSyTemp.getSwDjJbbTemp().setJbbId(UUIDGenerator.generate());
                }
            }
            taxService.addSwDjSyTempUpdateInfo(swDjSyTemp, Syzt.ZC.toString());

            syhcService.saveSyTemp(swDjSyTemp);
            responseMessage.setMsg(" 保存成功！ ");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg(" 出现异常，保存失败！ ");
        }
        return responseMessage;
    }

    @RequestMapping("delSy")
    @ResponseBody
    public Object delSy(Model model, String syId) throws  Exception{
        ResponseMessage responseMessage = new ResponseMessage();
        try{
            taxService.deleteSwDjSy(syId);
        }catch (Exception e){
            e.printStackTrace();
        }
        return responseMessage;
    }

    @RequestMapping("parseTdytByDm")
    @ResponseBody
    public Object parseTdytByDm(Model model,String dm){
        String[] dms = dm.split(",");
        String[] tdytmcs = new String[dms.length];
        for(int i=0;i<dms.length;i++){
            String tempTdytmc = Dldm.getMcByDm(dms[i]);
            tdytmcs[i] = tempTdytmc;
        }
        return tdytmcs;
    }

    @RequestMapping("loginUserInfo")
    @ResponseBody
    public Object loginUserInfo() {
        HashMap loginUserInfo = new HashMap();

        String userName = "";
        String ssfj = "";
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (userInfo != null) {
            String regionCode = userInfo.getRegionCode();

            userName = userInfo.getUsername();
            if (regionCode.length() == 8) {
                ssfj = "2" + regionCode + "00";
            }
        }

        loginUserInfo.put("userName", userName);
        loginUserInfo.put("ssfj", ssfj);

        return loginUserInfo;
    }

    @RequestMapping("getJsbl")
    @ResponseBody
    public Object getJsbl() {
        String jsblConf = AppConfig.getProperty("jsbl");
        if (org.apache.commons.lang.StringUtils.isBlank(jsblConf)) {
            jsblConf = "0.7";
        }
        return jsblConf;
    }

    @RequestMapping("findSwDjJbbByGlbm")
    @ResponseBody
    public Object findSwDjJbbByGlbm(Model model,String glbm, String syzt){
        SwDjJbb swDjJbb = null;
        if (syzt == null || syzt.equals("1")) {
            swDjJbb = taxService.findSwDjJbbByGlbm(glbm);
        } else if (syzt.equals("3")) {
            SwDjJbbTemp swDjJbbTemp = taxService.findSwDjJbbTempByGlbm(glbm);
            if (swDjJbbTemp != null) {
                swDjJbb = new SwDjJbb();
                BeanUtils.copyProperties(swDjJbbTemp, swDjJbb);
            } else {
                swDjJbb = taxService.findSwDjJbbByGlbm(glbm);
            }
        }
        return swDjJbb;
    }

    @RequestMapping("printSyxx")
    @ResponseBody
    public void printSyxx(Model model, HttpServletResponse response, String syId, String djh, String sylx) throws  Exception{
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();

        SwDjSy swDjSy = new SwDjSy();
        if(org.apache.commons.lang.StringUtils.isNotBlank(syId)){
            swDjSy = baseRepository.get(SwDjSy.class, syId);
        }else{//说明是录入界面打印
            //根据djh获取宗地信息
            Zd zd = baseRepository.get(Zd.class,djh);
            swDjSy.setZd(zd);
        }
        xml.append(xmlBuildHelper.voToXml(swDjSy));
        String res=xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }

    @RequestMapping("printSyxxTemp")
    @ResponseBody
    public void printSyxxTemp(Model model, HttpServletResponse response, String tempId, String djh) throws  Exception {
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();

        SwDjSyTemp swDjSyTemp = new SwDjSyTemp();
        if(org.apache.commons.lang.StringUtils.isNotBlank(tempId)) {
            swDjSyTemp = baseRepository.get(SwDjSyTemp.class, tempId);
        }else{ // 说明是录入界面打印
            // 根据djh获取宗地信息
            Zd zd = baseRepository.get(Zd.class,djh);
            swDjSyTemp.setZd(zd);
        }
        SwDjSy swDjSy = taxService.copyTempToSy(swDjSyTemp);
        xml.append(xmlBuildHelper.voEntityToXml(swDjSy));
        String res=xmlBuildHelper.getPrintXml(xml.toString());
        response.setContentType("text/xml; charset=GBK");
        PrintWriter out = response.getWriter();
        out.write(res);
        out.flush();
        out.close();
    }

    @RequestMapping("exportSyxx")
    public String exportSyxx(Model model, HttpServletRequest request, String syId, String djh, String xls) throws  Exception{
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();

        SwDjSy swDjSy = new SwDjSy();
        if(org.apache.commons.lang.StringUtils.isNotBlank(syId)){
            swDjSy = baseRepository.get(SwDjSy.class, syId);
        }else{//说明是录入界面打印
            //根据djh获取宗地信息
            Zd zd = baseRepository.get(Zd.class,djh);
            swDjSy.setZd(zd);
        }

        ExportFormExcelUtil.exportFormExcel(request, swDjSy, xls);

        return "common/downExcel";
    }

    @RequestMapping("exportSyxxTemp")
    public String exportSyxxTemp(Model model, HttpServletRequest request, String tempId, String djh, String xls) throws  Exception {
        XMLBuildHelper xmlBuildHelper = new XMLBuildHelper();
        StringBuilder xml = new StringBuilder();

        SwDjSyTemp swDjSyTemp = new SwDjSyTemp();
        if(org.apache.commons.lang.StringUtils.isNotBlank(tempId)) {
            swDjSyTemp = baseRepository.get(SwDjSyTemp.class, tempId);
        }else{ // 说明是录入界面打印
            // 根据djh获取宗地信息
            Zd zd = baseRepository.get(Zd.class,djh);
            swDjSyTemp.setZd(zd);
        }
        SwDjSy swDjSy = taxService.copyTempToSy(swDjSyTemp);


        ExportFormExcelUtil.exportFormExcel(request, swDjSy, xls);

        return "common/downExcel";
    }


    @RequestMapping("getPrintIdByProid")
    @ResponseBody
    public Object getPrintIdByProid(Model model,String proid){
        String hcxmlx = workFlowService.getHcxmlx(proid);
        SwHcXmRwRel swHcXmRwRel = hcxmService.getCurSwHcXmRwRelByProid(proid);
        String bdId = swHcXmRwRel.getBdId();
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        if (hcxmlx.equals(Hcxmlx.ZDHC.toString())) {
            queryConditionList.add(new QueryCondition("QLR_ID", QueryCondition.EQ, bdId));
        } else {
            queryConditionList.add(new QueryCondition("JBB_ID", QueryCondition.EQ, bdId));
        }
        List<HashMap> zdList = tjService.getTjList("zdList", queryConditionList);
        List<String> djhList = new ArrayList<String>();
        for (HashMap hashMap : zdList) {
            if (hashMap.get("DJH") != null)
                djhList.add(hashMap.get("DJH").toString());
        }

        List<SwDjSyTemp> swDjSyTempList = new ArrayList<SwDjSyTemp>();
        swDjSyTempList = syhcService.getSyxx(swHcXmRwRel.getShxrId());

        String tdsTempIds = "";
        String fcsTempIds = "";
        String djh = null;
        for (SwDjSyTemp swDjSyTemp : swDjSyTempList) {
            if (!swDjSyTemp.getSyzt().equals(Syzt.ZC.toString()))
                continue;

            if (swDjSyTemp.getZd() != null) {
                djh = swDjSyTemp.getZd().getDjh();
                if (djhList.indexOf(djh) > -1) {
                    djhList.remove(djh);
                }
            }
            if (swDjSyTemp.getSwDjTdTemp() != null) {
                if (!tdsTempIds.equals(""))
                    tdsTempIds += ",";
                tdsTempIds += swDjSyTemp.getTempId();
            }
            if (swDjSyTemp.getSwDjFcTemp() != null) {
                if (!fcsTempIds.equals(""))
                    fcsTempIds += ",";
                fcsTempIds += swDjSyTemp.getTempId();
            }
        }
        String zddjhs = "";
        for (String zddjh : djhList) {
            if (!zddjhs.equals(""))
                zddjhs += ",";
            zddjhs += zddjh;
        }

        HashMap<String, String> data = new HashMap<String, String>();
        data.put("zddjh", zddjhs);
        data.put("tdsTempId", tdsTempIds);
        data.put("fcsTempId", fcsTempIds);
        return data;
    }
}
