package cn.gtmap.landtax.web.fzjc;

import cn.gtmap.landtax.entity.TjBaseParamVo;
import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.service.SwgxService;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.support.spring.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * Created by zhouzhiwei on 2015-9-30.
 */
@Controller
@RequestMapping("/swgx")
public class SwgxController extends BaseController {
    @Autowired
    SwgxService swgxService;
    @Autowired
    TjService tjService;
    @Autowired
    BaseRepository baseRepository;


    @RequestMapping("index")
    public String test(Model model) throws Exception {
        String tag = "swgxFx";
        model.addAttribute("tag",tag);
        model.addAttribute("customParams", null);
        TjBaseParamVo tjBaseParamVo = tjService.getTjBaseParam(tag);
        model.addAttribute("tjBaseParamVo", tjBaseParamVo);
        if (tjBaseParamVo != null) {
            model.addAttribute("colJson", tjBaseParamVo.getColJson());
            model.addAttribute("headPageFile", tjBaseParamVo.getHeadPageFile());
            model.addAttribute("reportName", tjBaseParamVo.getReportName());
            if (tjBaseParamVo.isNeedExport()) {
                model.addAttribute("autoExport", "true");
            }
        }
        return "landtax/swgx/swgx";
    }

    /*
    *  税务数据更新
    *  */
    @RequestMapping("doUpdate")
    @ResponseBody
    public Object doUpdate(Model model) {
        // 分析更新宗地数据
        swgxService.updateSwData();

        ResponseMessage responseMessage = new ResponseMessage();
        return responseMessage;
    }
}
