package cn.gtmap.landtax.web;

import cn.gtmap.landtax.model.dictionary.ResponseMessage;
import cn.gtmap.landtax.service.WorkFlowService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * Created by zhouzhiwei on 2015-8-6.
 */

@Controller
@RequestMapping("/wf")
public class WorkFlowController {
    @Autowired
    private WorkFlowService workFlowService;

    @RequestMapping("delWorkflow")
    @ResponseBody
    public Object delWorkflow(Model model,String proid) {
        ResponseMessage responseMessage = new ResponseMessage();
        try {
            workFlowService.wfDel(proid);
            responseMessage.setMsg("删除成功");
        }catch (Exception e){
            e.printStackTrace();
            responseMessage.setMsg("出现异常，删除失败");
        }
        return null;
    }

    @RequestMapping("endWorkflow")
    @ResponseBody
    public String endWorkflow(Model model,String proid) {
        workFlowService.wfEnd(proid);
        return null;
    }

    @RequestMapping("createWorkflow")
    @ResponseBody
    public String createWorkflow(Model model,String hcxmlx, String id) {
        return workFlowService.wfCreate(hcxmlx, id);
    }
}
