package cn.gtmap.landtax.util;

import com.gtis.plat.service.SysWorkFlowDefineService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.spring.Container;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

public class WorkFlowXmlUtil {
	static int MAPMAXSIZE = 100;
	static HashMap<String, WorkFlowXml> workFlowDefineMap = new HashMap<String, WorkFlowXml>();
	static LinkedHashMap<String, WorkFlowXml> workFlowInstanceMap = new LinkedHashMap<String, WorkFlowXml>(
			100);
	@Autowired
	@Qualifier("SysWorkFlowInstanceService")
	private SysWorkFlowInstanceService worFlowInstanceService;
	@Autowired
	@Qualifier("SysWorkFlowDefineService")
	private SysWorkFlowDefineService workFlowDefineService;

	public SysWorkFlowInstanceService getWorFlowInstanceService() {
		return worFlowInstanceService;
	}

	public void setWorFlowInstanceService(
			SysWorkFlowInstanceService worFlowInstanceService) {
		this.worFlowInstanceService = worFlowInstanceService;
	}

	public SysWorkFlowDefineService getWorkFlowDefineService() {
		return workFlowDefineService;
	}

	public void setWorkFlowDefineService(
			SysWorkFlowDefineService workFlowDefineService) {
		this.workFlowDefineService = workFlowDefineService;
	}

	public WorkFlowXml getWorkFlowDefineModel(PfWorkFlowDefineVo defineVo) {
		WorkFlowXml modelXml = workFlowDefineMap.get(defineVo
				.getWorkflowDefinitionId());
		if (modelXml != null) {
			if (modelXml.getModifyDate() != null
					&& !modelXml.getModifyDate().equals(
							defineVo.getModifyDate()))
				modelXml = null;
		}
		if (modelXml == null) {
			String xml = workFlowDefineService.getWorkFlowDefineXml(defineVo);
			modelXml = new WorkFlowXml(xml);
			modelXml.setModifyDate(defineVo.getModifyDate());
			workFlowDefineMap.put(defineVo.getWorkflowDefinitionId(), modelXml);
		}
		return modelXml;
	}

	public WorkFlowXml getWorkFlowInstanceModel(PfWorkFlowInstanceVo instanceVo) {
		WorkFlowXml modelXml = workFlowInstanceMap.get(instanceVo
				.getWorkflowIntanceId());
		if (modelXml != null) {
			if (modelXml.getModifyDate() != null
					&& !modelXml.getModifyDate().equals(
							instanceVo.getModifyDate()))
				modelXml = null;
		}
		if (modelXml == null) {
			if (workFlowInstanceMap.size() > MAPMAXSIZE) {
				synchronized (workFlowInstanceMap) {
					workFlowInstanceMap.remove(workFlowInstanceMap.keySet()
							.iterator().next().toString());
				}
			}
			String xml = worFlowInstanceService
					.getWorkflowInstanceXml(instanceVo);
			modelXml = new WorkFlowXml(xml);
			modelXml.setModifyDate(instanceVo.getModifyDate());
			workFlowInstanceMap
					.put(instanceVo.getWorkflowIntanceId(), modelXml);
		}
		return modelXml;
	}
	
	public void updateGobalValByProId(String proId, String valName,
			String val) {
		PfWorkFlowInstanceVo vo=worFlowInstanceService.getWorkflowInstanceByProId(proId);
		updateGobalVal(vo.getWorkflowIntanceId(),valName,val);
	}

	public HashMap<String, Object> getGobalValByProId(String proId) {
		PfWorkFlowInstanceVo vo=worFlowInstanceService.getWorkflowInstanceByProId(proId);
        if (vo!=null)
		    return getGobalVal(vo.getWorkflowIntanceId());
        else
            return new HashMap<String, Object>();
	}
	
	public void updateGobalVal(String workflowIntanceId, String valName,
			String val) {
		worFlowInstanceService.updateGobalVal(workflowIntanceId, valName, val);
	}

	public HashMap<String, Object> getGobalVal(String workflowIntanceId) {
		return worFlowInstanceService.getGobalVal(workflowIntanceId);
	}

	public static WorkFlowXml getDefineModel(PfWorkFlowDefineVo defineVo) {
		WorkFlowXmlUtil factory = (WorkFlowXmlUtil) Container
				.getBean("WorkFlowXmlUtil");
		return factory.getWorkFlowDefineModel(defineVo);
	}

	public static WorkFlowXml getInstanceModel(PfWorkFlowInstanceVo instanceVo) {
		WorkFlowXmlUtil factory = (WorkFlowXmlUtil) Container
				.getBean("WorkFlowXmlUtil");
		return factory.getWorkFlowInstanceModel(instanceVo);
	}
	
	
	
	public static void updateGobalVals(String workflowIntanceId, String valName,
			String val) {
		WorkFlowXmlUtil factory = (WorkFlowXmlUtil) Container
		.getBean("WorkFlowXmlUtil");
		factory.updateGobalVal(workflowIntanceId,valName,val);
	}
	
	public static HashMap<String, Object> getGobalVals(String workflowIntanceId) {
		WorkFlowXmlUtil factory = (WorkFlowXmlUtil) Container.getBean("WorkFlowXmlUtil");
		return factory.getGobalVal(workflowIntanceId);
	}
	
	public static void updateGobalValsByProId(String proId, String valName,
			String val) {
		WorkFlowXmlUtil factory = (WorkFlowXmlUtil) Container
		.getBean("WorkFlowXmlUtil");
		factory.updateGobalValByProId(proId,valName,val);
	}
	
	public static HashMap<String, Object> getGobalValsByProId(String proId) {
		WorkFlowXmlUtil factory = (WorkFlowXmlUtil) Container
		.getBean("WorkFlowXmlUtil");
		return factory.getGobalValByProId(proId);
	}

    public static List<HashMap> getActivityListByWorkDefinId(String workflowDefinitionId) throws Exception{
        if(StringUtils.isNotBlank(workflowDefinitionId)) {
            SysWorkFlowDefineService workFlowDefineService = (SysWorkFlowDefineService) Container.getBean("SysWorkFlowDefineService");
            String xml = workFlowDefineService.getWorkFlowDefineXml(workflowDefinitionId);
            Document doc = DocumentHelper.parseText(xml);
            Element root = doc.getRootElement();
            Element WorkflowProcessesElement = root.element("WorkflowProcesses");
            Element WorkflowProcessElement = WorkflowProcessesElement.element("WorkflowProcess");
            Element ActivitiesElement = WorkflowProcessElement.element("Activities");
            List<Element> nodeList = ActivitiesElement.elements("Activity");

            List<HashMap> activityList = new ArrayList<HashMap>();
            for (int i = 0; i < nodeList.size(); i++) {
                Element tempEl = nodeList.get(i);
                String activityDefinitionId = tempEl.attributeValue("Id");
                String activityName = tempEl.attributeValue("Name");
                HashMap tempMap = new HashMap();
                tempMap.put("activityDefinitionId", activityDefinitionId);
                tempMap.put("activityName", activityName);
                activityList.add(tempMap);
            }
            return activityList;
        }
        return null;
    }

}
