package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Czlx;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.service.*;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import cn.gtmap.landtax.service.ZdbgService;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.web.SessionUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
public class ZdbgServiceImpl implements ZdbgService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    DicService dicService;
    @Autowired
    TaxService taxService;
    @Autowired
    WorkFlowService workFlowService;
    @Autowired
    SysUserService sysUserService;

    @Override
    @Transactional(readOnly = true, propagation = Propagation.NOT_SUPPORTED)
    public List<SSjZdbg> findZdBgList(Date startDate, Date endDate) {
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("bgrq", QueryCondition.GE, startDate));
        queryConditionList.add(new QueryCondition("bgrq", QueryCondition.LE, endDate));

        List<SSjZdbg> sSjZdbgList = baseRepository.list(SSjZdbg.class, queryConditionList);
        return sSjZdbgList;
    }

    @Override
    @Transactional(readOnly = true, propagation = Propagation.NOT_SUPPORTED)
    public List<HashMap> findZdBgChangeMap(Date startDate, Date endDate) {
        String sql = "WITH " +
                    "S_SJ_ZDBG_FIND AS ( " +
                    "  SELECT t.* " +
                    "  FROM S_SJ_ZDBG t " +
                    "  WHERE TO_CHAR(t.BGRQ, 'yyyymmdd') <=TO_CHAR(SYSDATE - 1, 'yyyymmdd') AND TO_CHAR(t.BGRQ, 'yyyymmdd') BETWEEN :GEDATE AND :LEDATE " +
                    "), " +
                    "S_SJ_ZDBG_QUERY AS ( " +
                    "  SELECT t.* " +
                    "  FROM S_SJ_ZDBG_FIND t " +
                    "  WHERE NOT EXISTS (SELECT * FROM S_SJ_ZDBG_FIND t1 WHERE t.BGBH=t1.BGBH AND t1.BGFS!=t.BGFS) " +
                    "        AND NOT EXISTS (SELECT * FROM S_SJ_ZDBG_FIND t1 WHERE t.DJH_NEW=t1.DJH_OLD AND t.BGFS='属性变更' AND t1.BGBH>t.BGBH) " +
                    "        AND NOT EXISTS (SELECT * FROM S_SJ_ZDBG_FIND t1 WHERE t.BGBH=t1.BGBH AND t.BGFS='宗地综合变更' " +
                    "                                                                   AND ((t.DJH_NEW=t1.DJH_OLD AND t1.DJH_OLD IS NOT NULL) OR (t1.DJH_NEW=t.DJH_OLD AND t1.DJH_NEW IS NOT NULL))) " +
                    ") " +
                    "SELECT t.* " +
                    "FROM ( " +
                    "      SELECT t.*, " +
                    "             CASE " +
                    "               WHEN t.PDJH IS NULL THEN " +
                    "                 CASE " +
                    "                   WHEN (t.TDYT IN ('071','072')) THEN " +
                    "                     '新增免税宗地' " +
                    "                   ELSE " +
                    "                     '新增应税宗地' " +
                    "                 END " +
                    "               WHEN (t1.TDYT IS NULL OR t1.TDYT IN ('071','072')) THEN " +
                    "                 CASE " +
                    "                   WHEN (t.TDYT IS NULL) THEN " +
                    "                     '免税宗地灭失' " +
                    "                   WHEN (t.TDYT IN ('071','072')) THEN " +
                    "                     '免税宗地转免税宗地' " +
                    "                   ELSE " +
                    "                     '免税宗地转应税宗地' " +
                    "                 END " +
                    "               ELSE " +
                    "                 CASE " +
                    "                   WHEN (t.TDYT IS NULL) THEN " +
                    "                     '应税宗地灭失' " +
                    "                   WHEN (t.TDYT IN ('071','072')) THEN " +
                    "                     '应税宗地转免税宗地' " +
                    "                   ELSE " +
                    "                     '应税宗地转应税宗地' " +
                    "                 END " +
                    "             END " +
                    "             AS BGLX " +
                    "      FROM ( " +
                    "            SELECT CONNECT_BY_ISLEAF, CONNECT_BY_ROOT DJH_OLD AS PDJH, SYS_CONNECT_BY_PATH(BGBH,',') AS BGBHLIST, " +
                    "                   t.* " +
                    "            FROM S_SJ_ZDBG_QUERY t " +
                    "            WHERE CONNECT_BY_ISLEAF IN ('1') " +
                    "            START WITH (NOT EXISTS (SELECT t1.* FROM S_SJ_ZDBG_QUERY t1 WHERE t.DJH_OLD=t1.DJH_NEW AND t.BGBH > t1.BGBH) OR t.DJH_OLD IS NULL) " +
                    "            CONNECT BY (t.DJH_OLD=PRIOR t.DJH_NEW  AND t.BGBH > PRIOR t.BGBH) " +
                    "           ) t " +
                    "           LEFT JOIN ZD t1 ON t.PDJH=t1.DJH " +
                    "     ) t " +
                    "WHERE BGLX NOT IN ('免税宗地灭失', '免税宗地转免税宗地', '新增免税宗地') " +
                    "ORDER BY BGBH DESC";

        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.setParameter("GEDATE", startDate != null ? (new SimpleDateFormat("yyyyMMdd")).format(startDate) : "20150101");
        if (endDate == null)
            endDate = Calendar.getInstance().getTime();
        query.setParameter("LEDATE", (new SimpleDateFormat("yyyyMMdd")).format(endDate));
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);

        return query.getResultList();
    }

    @Override
    @Transactional
    public void bgZd(String bgAnalyProid) {
        if (StringUtils.isBlank(bgAnalyProid))
            return;

        SSjZdbgAnaly sSjZdbgAnaly = baseRepository.get(SSjZdbgAnaly.class, bgAnalyProid);
        if (sSjZdbgAnaly == null)
            return;

        Zd zdOld = null;
        Zd zdNew = null;
        if (StringUtils.isNotEmpty(sSjZdbgAnaly.getDjhBefore())) {
            zdOld = baseRepository.get(Zd.class, sSjZdbgAnaly.getDjhBefore());

            if (zdOld != null) { // 存历史记录
                ZdHistory zdHistory = new ZdHistory();
                try {
                    BeanUtils.copyProperties(zdHistory, zdOld);
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                zdHistory.setDjhNew(sSjZdbgAnaly.getsSjZdbg().getDjhNew());
                zdHistory.setUserid(SessionUtil.getCurrentUserId());
                zdHistory.setUsername(SessionUtil.getCurrentUser().getUsername());
                zdHistory.setGxrq(Calendar.getInstance().getTime());
                zdHistory.setHisId(UUIDGenerator.generate());
                baseRepository.save(zdHistory);
            }
        }
        if (StringUtils.isNotEmpty(sSjZdbgAnaly.getsSjZdbg().getDjhNew())) {
            zdNew = baseRepository.get(Zd.class, sSjZdbgAnaly.getsSjZdbg().getDjhNew());
            if (zdNew == null) {
                zdNew = new Zd();
                zdNew.setDjh(sSjZdbgAnaly.getsSjZdbg().getDjhNew());
                updateBgInfo(zdNew, sSjZdbgAnaly.getsSjZdbg());

                if (zdOld != null) {
                    zdNew.setTddj(zdOld.getTddj());
                    zdNew.setSgqdm(zdOld.getSgqdm());
                    zdNew.setZdlx(zdOld.getZdlx());
                    zdNew.setXzqdm(zdOld.getXzqdm());
                }
                setZdOtherInfo(zdNew);

                baseRepository.save(zdNew);
            } else {
                updateBgInfo(zdNew, sSjZdbgAnaly.getsSjZdbg());
                baseRepository.update(zdNew);
            }

            // 变更成了免税宗地
            if (zdNew.getTdyt() == null || zdNew.getTdyt().equals("071") || zdNew.getTdyt().equals("072")) {
                baseRepository.delete(zdNew);
            }
        }

        if (zdOld != null && (zdNew == null || !zdOld.getDjh().equalsIgnoreCase(zdNew.getDjh()))) {   // 删除原宗地
            baseRepository.delete(zdOld);
        }
    }

    @Override
    @Transactional
    public String analyZdBgData(Date startDate, Date endDate) {
        List<HashMap> zdbgChangeMap = findZdBgChangeMap(startDate, endDate);
        // 判断为空则退出
        if (CollectionUtils.isEmpty(zdbgChangeMap))
            return null;

        String bgbhStr = null;
        List<String> bgbhList = new ArrayList<String>();
        String groupid = null;
        HashMap<String, String> bgbhGroup = new HashMap<String, String>();

        // 获取变更操作记录
        SSjZdbgDobg sSjZdbgDobg = doZdbg(startDate, endDate);
        if (sSjZdbgDobg == null)
            return null;

        for (HashMap hashMap : zdbgChangeMap) {
            bgbhStr = hashMap.get("BGBHLIST").toString();
            bgbhList.clear();
            bgbhList.addAll(Arrays.asList(bgbhStr.split(",")));
            bgbhList.remove(0);

            // 检查是否能够合并到之前的分组,有则返回分组ID
            groupid = null;
            for (String bgbh : bgbhList) {
                if (bgbhGroup.get(bgbh) != null) {
                    groupid = bgbhGroup.get(bgbh);
                    break;
                }
            }
            if (StringUtils.isBlank(groupid)) {
                groupid = UUIDGenerator.generate();
            }

            // 存储变更编号跟分组id信息
            for (String bgbh : bgbhList) {
                if (bgbhGroup.get(bgbh) == null) {
                    bgbhGroup.put(bgbh, groupid);
                }
            }

            // 开始存储分析数据
            SSjZdbgAnaly sSjZdbgAnaly = new SSjZdbgAnaly();
            sSjZdbgAnaly.setProid(UUIDGenerator.generate());
            sSjZdbgAnaly.setGroupid(groupid);
            sSjZdbgAnaly.setDjhBefore(hashMap.get("PDJH") == null ? null : hashMap.get("PDJH").toString());
            SSjZdbg sSjZdbg = baseRepository.get(SSjZdbg.class, hashMap.get("PROJECTID").toString());
            sSjZdbgAnaly.setsSjZdbg(sSjZdbg);
            sSjZdbgAnaly.setsSjZdbgDobg(sSjZdbgDobg);
            sSjZdbgAnaly.setBglx(hashMap.get("BGLX") == null ? null : hashMap.get("BGLX").toString());
            sSjZdbgAnaly.setClzt("0");

            baseRepository.save(sSjZdbgAnaly);

            // 变更宗地
            bgZd(sSjZdbgAnaly.getProid());
        }

        return sSjZdbgDobg.getProid();
    }

    // 记录时间段做一次变更
    private SSjZdbgDobg doZdbg(Date startDate, Date endDate) {
        SSjZdbgDobg sSjZdbgDobg = findZdbgDobg(startDate, endDate);
        if (sSjZdbgDobg != null)
            return sSjZdbgDobg;

        // 日期都为空则返回空
        if (startDate == null && endDate == null)
            return null;

        // 判断该时间段是否做过变更
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("bgEnd", QueryCondition.GE, startDate));
        List<SSjZdbgDobg> list = baseRepository.list(SSjZdbgDobg.class, queryConditionList);
        if (CollectionUtils.isEmpty(list)) {
            // 生成变更操作记录
            sSjZdbgDobg = new SSjZdbgDobg();
            sSjZdbgDobg.setProid(UUIDGenerator.generate());
            sSjZdbgDobg.setBgBegin(startDate);
            sSjZdbgDobg.setBgEnd(endDate);
            sSjZdbgDobg.setCzrq(Calendar.getInstance().getTime());
            UserInfo userInfo = SessionUtil.getCurrentUser();
            sSjZdbgDobg.setUserid(userInfo.getId());
            sSjZdbgDobg.setUsername(userInfo.getUsername());

            baseRepository.save(sSjZdbgDobg);
        }

        return sSjZdbgDobg;
    }

    @Override
    @Transactional(readOnly = true, propagation = Propagation.NOT_SUPPORTED)
    public List<SSjZdbgAnaly> findZdbgAnaly(Date startDate, Date endDate) {
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("analyBegin", QueryCondition.GE, startDate));
        queryConditionList.add(new QueryCondition("analyEnd", QueryCondition.LE, endDate));

        String orderBy = " order by sSjZdbg.bgbh";
        List<SSjZdbgAnaly> sSjZdbgAnalyList = baseRepository.list(SSjZdbgAnaly.class, queryConditionList, orderBy);
        return sSjZdbgAnalyList;
    }

    @Override
    @Transactional(readOnly = true, propagation = Propagation.NOT_SUPPORTED)
    public SSjZdbgDobg findZdbgDobg(Date startDate, Date endDate) {
        SSjZdbgDobg sSjZdbgDobg = null;

        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("bgBegin", QueryCondition.EQ, startDate));
        queryConditionList.add(new QueryCondition("bgEnd", QueryCondition.EQ, endDate));
        List<SSjZdbgDobg> list = baseRepository.list(SSjZdbgDobg.class, queryConditionList);
        if (CollectionUtils.isNotEmpty(list)) {
            sSjZdbgDobg = list.get(0);
        }
        return sSjZdbgDobg;
    }

    @Override
    @Transactional
    public void refreshZdSwRelation(String dobgid) {
        String zdgx = "自动变更税务数据";
        String cjhcrw = "创建核查任务下发";

        String sql = "SELECT DISTINCT t.GROUPID, " +
                    "       CASE " +
                    "         WHEN t.DJH_NEW_CNT=1 AND t.DJH_BEFORE_CNT>0 THEN " +
                    "           :zdgx " +
                    "         ELSE " +
                    "           :cjhcrw " +
                    "       END " +
                    "       AS CLFS " +
                    "FROM ( " +
                    "      SELECT t1.GROUPID, t1.DOBGID, " +
                    "             COUNT(DISTINCT DECODE(SUBSTR(t1.BGLX, 1, 4), '应税宗地', t1.DJH_BEFORE, NULL)) OVER(PARTITION BY GROUPID) AS DJH_BEFORE_CNT, " +
                    "             COUNT(DISTINCT DECODE(SUBSTR(t1.BGLX, LENGTH(BGLX)-4+1, 4), '应税宗地', t2.DJH_NEW, NULL)) OVER(PARTITION BY GROUPID) AS DJH_NEW_CNT " +
                    "      FROM S_SJ_ZDBG_ANALY t1 " +
                    "           LEFT JOIN S_SJ_ZDBG t2 ON t1.BGPROID=t2.PROJECTID " +
                    "     ) t " +
                    "WHERE t.DOBGID=:dobgid ";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        query.setParameter("dobgid", dobgid);
        query.setParameter("zdgx", zdgx);
        query.setParameter("cjhcrw", cjhcrw);

        List<HashMap> list = query.getResultList();

        if (CollectionUtils.isEmpty(list))
            return;

        List<String> djhOldList = new ArrayList<String>();
        List<String> djhNewList = new ArrayList<String>();
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        List<SSjZdbgAnaly> sSjZdbgAnalyList = null;
        List<SwDjSy> swDjSyList = null;
        List<PfUserVo> toUserList = null;
        for (HashMap hashMap : list) {
            String groupid = hashMap.get("GROUPID").toString();
            String clfs = hashMap.get("CLFS").toString();

            queryConditionList.clear();
            queryConditionList.add(new QueryCondition("groupid", QueryCondition.EQ, groupid));
            sSjZdbgAnalyList = baseRepository.list(SSjZdbgAnaly.class, queryConditionList);

            djhOldList.clear();
            djhNewList.clear();
            for (SSjZdbgAnaly sSjZdbgAnaly : sSjZdbgAnalyList) {
                String bglx = sSjZdbgAnaly.getBglx();
                String djh = sSjZdbgAnaly.getDjhBefore();
                if (StringUtils.isNotBlank(djh) && bglx.startsWith("应税宗地")) {
                    if (djhOldList.indexOf(djh) == -1) {
                        djhOldList.add(djh);
                    }
                }

                djh = sSjZdbgAnaly.getsSjZdbg().getDjhNew();
                if (StringUtils.isNotBlank(djh) && bglx.endsWith("应税宗地")) {
                    if (djhNewList.indexOf(djh) == -1) {
                        djhNewList.add(djh);
                    }
                }
            }

            String djhFilterStr = "";
            for (int i = 0; i < djhOldList.size(); i++) {
                if (djhFilterStr != "") {
                    djhFilterStr += "','";
                }
                djhFilterStr += djhOldList.get(i);
            }
            djhFilterStr = "'" + djhFilterStr + "'";

            queryConditionList.clear();
            queryConditionList.add(new QueryCondition("zd.djh in (" + djhFilterStr + ")"));
            swDjSyList = baseRepository.list(SwDjSy.class, queryConditionList);

            if (clfs.equals(zdgx)) {
                // 自动处理
                Zd zd = baseRepository.get(Zd.class, djhNewList.get(0));
                for (SwDjSy swDjSy : swDjSyList) {
                    swDjSy.setZd(zd);
                    swDjSy.setBz("宗地数据更新");
                    taxService.addSwDjSyUpdateInfo(swDjSy, Czlx.UPDATE.toString());
                    taxService.updateSwDjSy(swDjSy);
                }
            } else {
                // 创建核查任务
                String wiid = workFlowService.wfCreateZdgxhc(Hcxmlx.ZDGXHC.toString(), groupid, swDjSyList);

                // 获取用户列表
                if (toUserList == null) {
                    PerformerTaskModel result = null;
                    try {
                        result = workFlowService.getTurnUserList(SessionUtil.getCurrentUserId(), wiid);
                        toUserList = result.getUserList();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                // 获取下发分局代码
                String fjdm = "";
                if (CollectionUtils.isNotEmpty(swDjSyList)) {
                    fjdm =  swDjSyList.get(0).getZd().getSgqdm();
                } else {
                    Zd zd = baseRepository.get(Zd.class, djhNewList.get(0));
                    if (zd != null)
                    fjdm = zd.getSgqdm();
                }
                if (!wiid.startsWith("java.lang:") && fjdm != "") {
                    String toUserId = "";
                    for(PfUserVo pfUserVo : toUserList) {
                        String regionCode = sysUserService.getRegionCodeByUserId(pfUserVo.getUserId());
                        if(regionCode.length() > 8) {
                            regionCode = regionCode.substring(0, 8);
                        }
                        if(regionCode.startsWith(fjdm)) {
                            toUserId = pfUserVo.getUserId();
                            break;
                        }
                    }

                    workFlowService.autoTurnWorkflow(wiid, toUserId);
                }
            }
        }
        return;
    }

    // 将变更属性赋给宗地
    private void updateBgInfo(Zd zd, SSjZdbg sSjZdbg) {
        if (zd == null)
            zd = new Zd();

        if (sSjZdbg == null)
            return;

        if (sSjZdbg.getDjhNew() != null)
            zd.setDjh(sSjZdbg.getDjhNew());
        if (sSjZdbg.getQlrmc() != null)
            zd.setQlrmc(sSjZdbg.getQlrmc());
        if (sSjZdbg.getScmj() != null)
            zd.setScmj(sSjZdbg.getScmj());
        if (sSjZdbg.getTdzl() != null)
            zd.setTdzl(sSjZdbg.getTdzl());
        if (sSjZdbg.getTdyt() != null) {
            zd.setTdyt(sSjZdbg.getTdyt());
            try {
                zd.setTdytmc(dicService.findMcByDm("Dldm", sSjZdbg.getTdyt()));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    // 给宗地其它属性赋值
    private void setZdOtherInfo(Zd zd) {
        if (zd == null)
            return;

        String djh = zd.getDjh();
        if (StringUtils.isBlank(djh))
            return;

        if (zd.getTddj() == null || zd.getSgqdm() == null) {
            String sql = "SELECT t.* FROM S_DM_ZDSX t WHERE t.DM=:XZDM";
            Query query = baseRepository.getEntityManager().createNativeQuery(sql);
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            query.setParameter("XZDM", djh.substring(0, 9));
            List<HashMap<String, String>> list = query.getResultList();
            if (CollectionUtils.isNotEmpty(list)) {
                HashMap<String, String> hashMap = list.get(0);
                if (zd.getTddj() == null) {
                    zd.setTddj(hashMap.get("TDDJ"));
                }
                if (zd.getSgqdm() == null) {
                    zd.setSgqdm(hashMap.get("SGQDM"));
                }
            }
        }

        if (zd.getXzqdm() == null) {
            zd.setXzqdm(djh.substring(0, 12));
        }
        if (zd.getZdlx() == null) {
            zd.setZdlx("1");
        }

    }
}
