package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.WorkFlowService;
import cn.gtmap.landtax.service.ZdService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.web.SessionUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;


@Service
public class ZdServiceImpl implements ZdService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    HcxmService hcxmService;
    @Autowired
    WorkFlowService workFlowService;

    //获取正在修改的宗地
    @Override
    public List zdInput(String djh) throws Exception{
        //根据地籍号获取zd
        List<QueryCondition> paramList = new ArrayList<QueryCondition>();
        paramList.add(new QueryCondition("djh",QueryCondition.EQ,djh));
        paramList.add(new QueryCondition("sjzt",QueryCondition.EQ,"1"));
        List zdTempList = baseRepository.list(ZdTemp.class,paramList);
        return zdTempList;
    }

    // 更新宗地信息
    @Override
    @Transactional
    public void updateZd(Zd zd) throws  Exception{
        if (zd == null)
            return;
        if (StringUtils.isBlank(zd.getDjh()))
            return;

        Zd zdOld = baseRepository.get(Zd.class, zd.getDjh());
        if (zdOld != null) { // 保存历史记录
            ZdHistory zdHistory = new ZdHistory();
            BeanUtils.copyProperties(zdHistory, zdOld);
            zdHistory.setDjhNew(zd.getDjh());
            zdHistory.setUserid(SessionUtil.getCurrentUserId());
            zdHistory.setUsername(SessionUtil.getCurrentUser().getUsername());
            zdHistory.setGxrq(Calendar.getInstance().getTime());
            zdHistory.setHisId(UUIDGenerator.generate());
            baseRepository.save(zdHistory);

            baseRepository.update(zd);
        } else {
            baseRepository.save(zd);
        }
    }

    //宗地取消修改
    @Override
    @Transactional
    public String zdQxXg(ZdTemp zdTemp) throws  Exception{
        String djh = zdTemp.getDjh();
        String msg="";
        List<QueryCondition> paramList = new ArrayList<QueryCondition>();
        paramList.add(new QueryCondition("djh",QueryCondition.EQ,djh));
        paramList.add(new QueryCondition("sjzt",QueryCondition.EQ,"1"));
        List zdTempList = baseRepository.list(ZdTemp.class,paramList);
        ZdTemp zdTempS = null;
        if(CollectionUtils.isNotEmpty(zdTempList)){
            zdTempS = (ZdTemp)zdTempList.get(0);
        }
        //取消修改(zdTemp一定是存在的)，将zd临时表中额数据状态修由1改为2
        if(zdTempS!=null){
            zdTempS.setSjzt("2");
            baseRepository.update(zdTempS);
        }else {
            msg="已成功入库或已取消修改";
        }
        return  msg;
    }

    //宗地临时保存
    @Override
    @Transactional
    public  void  saveTempZd(ZdTemp zdTemp)throws Exception{
        String UUID = UUIDGenerator.generate();
        String djh = zdTemp.getDjh();
        String userId = SessionUtil.getCurrentUserId();
        String username = SessionUtil.getCurrentUser().getUsername();
        Date zdxgrq= Calendar.getInstance().getTime();
        Zd zdOld = baseRepository.get(Zd.class,djh);
        //查看宗地临时表中是否有正在修改的记录
        List<QueryCondition> paramlist = new ArrayList<QueryCondition>();
        paramlist.add(new QueryCondition("djh",QueryCondition.EQ,djh));
        paramlist.add(new QueryCondition("sjzt",QueryCondition.EQ,"1"));
        List listTemp = baseRepository.list(ZdTemp.class,paramlist);
        ZdTemp zdTempOld = null;
        if(CollectionUtils.isNotEmpty(listTemp)){
            zdTempOld=(ZdTemp)listTemp.get(0);
        }

        //如果有正在修改的记录，就更新这条记录，没有就保存一条新的记录
        if(zdTempOld!=null){
            zdTempOld = (ZdTemp)CommonUtil.copyPropertyForSave(zdTemp,zdTempOld);
            zdTempOld.setUserid(userId);
            zdTempOld.setUsername(username);
            zdTempOld.setZdxgrq(zdxgrq);
            baseRepository.update(zdTempOld);
        }else{
            zdTempOld = new ZdTemp();
            zdTempOld = (ZdTemp)CommonUtil.copyPropertyForSave(zdOld,zdTempOld);
            zdTempOld = (ZdTemp)CommonUtil.copyPropertyForSave(zdTemp,zdTempOld);
            zdTempOld.setSjzt("1");
            zdTempOld.setId(UUID);
            zdTempOld.setUserid(userId);
            zdTempOld.setUsername(username);
            zdTempOld.setZdxgrq(zdxgrq);
            baseRepository.save(zdTempOld);
        }

    }

    @Override
    @Transactional(readOnly = true, propagation = Propagation.NOT_SUPPORTED)
    public Zd findZdByDjh(String djh) {
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("djh", QueryCondition.LK, djh));
        List<Zd> zdList = baseRepository.list(Zd.class, queryConditionList);

        Zd zd = null;
        if (CollectionUtils.isNotEmpty(zdList)) {
            zd = zdList.get(0);
        }
        return zd;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getZdPage(Zd zdQuery, Pageable pageable, String proid) {
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        if(StringUtils.isNotBlank(zdQuery.getDjh())){
            queryConditionList.add(new QueryCondition("djh",QueryCondition.LK,zdQuery.getDjh()));
        }
        if(StringUtils.isNotBlank(zdQuery.getTdzh())){
            queryConditionList.add(new QueryCondition("tdzh",QueryCondition.LK,zdQuery.getTdzh()));
        }
        if(StringUtils.isNotBlank(zdQuery.getQlrmc())){
            queryConditionList.add(new QueryCondition("qlrmc",QueryCondition.LK,zdQuery.getQlrmc()));
        }
        if(StringUtils.isNotBlank(zdQuery.getTdzl())){
            queryConditionList.add(new QueryCondition("tdzl",QueryCondition.LK,zdQuery.getTdzl()));
        }
        if(StringUtils.isNotBlank(proid)){
            String hcxmlx = workFlowService.getHcxmlx(proid);
            String bdId = hcxmService.getCurSwHcXmRwRelByProid(proid).getBdId();
            try {
                List<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
                if (Hcxmlx.ZDHC.toString().equals(hcxmlx)) {
                    String qlrmc = baseRepository.get(SSjZdqlr.class, bdId).getQlrmc();
                    queryConditions.add(new QueryCondition("qlrmc", QueryCondition.EQ, qlrmc));
                    List<Zd> zdList = baseRepository.list(Zd.class, queryConditions);

                    String djhs = "";
                    String djh = "";
                    for (int i = 0; i < zdList.size(); i++) {
                        djh = "'" + zdList.get(i).getDjh() + "'";
                        if (StringUtils.isNotEmpty(djhs))
                            djhs += ",";
                        djhs += djh;
                    }
                    if (StringUtils.isNotEmpty(djhs))
                        queryConditionList.add(new QueryCondition("djh in (" + djhs + ")"));
                } else if (Hcxmlx.SYHC.toString().equals(hcxmlx) || Hcxmlx.MJBYZHC.toString().equals(hcxmlx)) {
                    queryConditions.add(new QueryCondition("swDjJbb.jbbId", QueryCondition.EQ, bdId));
                    List<SwDjSy> swDjSyList = baseRepository.list(SwDjSy.class, queryConditions);

                    String djhs = "";
                    String djh = "";
                    for (int i = 0; i < swDjSyList.size(); i++) {
                        djh = "'" + swDjSyList.get(i).getZd().getDjh() + "'";
                        if (StringUtils.isNotEmpty(djhs))
                            djhs += ",";
                        djhs += djh;
                    }
                    queryConditionList.add(new QueryCondition("djh in (" + djhs + ")"));
                } else if (Hcxmlx.ZDGXHC.toString().equals(hcxmlx)) {
                    queryConditions.add(new QueryCondition("groupid", QueryCondition.EQ, bdId));
                    List<SSjZdbgAnaly> sSjZdbgAnalyList = baseRepository.list(SSjZdbgAnaly.class, queryConditions);

                    String djhs = "";
                    String djh = "";
                    for (int i = 0; i < sSjZdbgAnalyList.size(); i++) {
                        djh = "'" + sSjZdbgAnalyList.get(i).getsSjZdbg().getDjhNew() + "'";
                        if (sSjZdbgAnalyList.get(i).getBglx().endsWith("应税宗地")) {
                            if (StringUtils.isNotEmpty(djhs))
                                djhs += ",";
                            djhs += djh;
                        }
                    }
                    if (StringUtils.isNotEmpty(djhs)) {
                        queryConditionList.add(new QueryCondition("djh in (" + djhs + ")"));
                    } else {
                        queryConditionList.add(new QueryCondition("1=2"));
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        return baseRepository.find(Zd.class, queryConditionList, null, pageable);
    }
}
