package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.entity.SwHcXmRwRel;
import cn.gtmap.landtax.model.dictionary.Blzt;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.dictionary.Sjly;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.WorkFlowService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.*;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.service.WorkFlowCoreService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.PfRoleVo;
import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.wf.WorkFlowInfo;
import com.gtis.plat.wf.WorkFlowTransInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.plat.wf.model.TransitionModel;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.logging.SimpleFormatter;

/**
 * Created by zhouzhiwei on 2015/9/1.
 */
@Service
public class WorkFlowServiceImpl implements WorkFlowService {
    @Autowired
    private BaseRepository baseRepository;
    @Autowired
    IPlatUtil platUtil;
    @Autowired
    private HashMap workFlowIdMap;
    @Autowired
    TaxService taxService;
    @Autowired
    WorkFlowCoreService workFlowCoreService;
    @Autowired
    SysUserService sysUserService;

    @Override
    @Transactional
    public void wfDel(String proid) {
        SwHcXmRwRel swHcXmRwRel = getSwHcXmRwRelByWiid(proid);

        Set<SwDjSyTemp> swDjSyTempSet = swHcXmRwRel.getSwDjSyTempSet();
        List<SwDjSyTemp> swDjSyTempList = new ArrayList<SwDjSyTemp>(swDjSyTempSet);
        for (SwDjSyTemp swDjSyTemp : swDjSyTempList) {
            baseRepository.delete(swDjSyTemp);
        }

        //3,SwHcXmRwRel.blzt 设置为1，表示该任务已办结
        doUpSwHcXmRwRel(swHcXmRwRel, Blzt.YSC.toString());

        //4,判断SwHcXm中是否还有swHcXmRwRel
        doUpSwHcXm(swHcXmRwRel);
    }

    @Override
    @Transactional
    public void wfEnd(String proid) {
        //1,将swDjSy.syzt 设置成1
        SwHcXmRwRel swHcXmRwRel = getSwHcXmRwRelByWiid(proid);
        Set<SwDjSyTemp> swDjSyTempSet = swHcXmRwRel.getSwDjSyTempSet();
        List<SwDjSyTemp> swDjSyTempList = new ArrayList<SwDjSyTemp>(swDjSyTempSet);

        // 将临时税源数据存放到税源表中
        SwDjSy swDjSy = null;
        for(SwDjSyTemp swDjSyTemp : swDjSyTempList){
            if (swDjSyTemp.getSyzt().equals(Syzt.ZC.toString())) {
                swDjSy = baseRepository.get(SwDjSy.class, swDjSyTemp.getSyId());
                if (swDjSy != null) {   // 已存在的税源
                    if (swDjSyTemp.getUpdateRq().after(swDjSy.getUpdateRq())) { // 有修改过
                        swDjSy = taxService.copyTempToSy(swDjSyTemp);
                        swDjSy.setSjly(Sjly.SYHC.toString());
                        taxService.updateSwDjSy(swDjSy);
                    }
                } else {    // 不存在
                    swDjSy = taxService.copyTempToSy(swDjSyTemp);
                    swDjSy.setSjly(Sjly.SYHC.toString());
                    taxService.updateSwDjSy(swDjSy);
                }
            } else if (swDjSyTemp.getSyzt().equals(Syzt.SC.toString())) {
                swDjSy = baseRepository.get(SwDjSy.class, swDjSyTemp.getSyId());
                if (swDjSy != null) {   // 已存在的税源
                    if (swDjSyTemp.getUpdateRq().after(swDjSy.getUpdateRq())) { // 有修改过
                        taxService.deleteSwDjSy(swDjSyTemp.getSyId());
                    }
                } else {    // 不存在
                    baseRepository.delete(swDjSyTemp);
                }
            } else {
                baseRepository.delete(swDjSyTemp);
            }
        }

        //3,SwHcXmRwRel.blzt 设置为1，表示该任务已办结
        doUpSwHcXmRwRel(swHcXmRwRel, Blzt.YBJ.toString());

        //4,判断SwHcXm中是否还有swHcXmRwRel
        doUpSwHcXm(swHcXmRwRel);
    }

    @Override
    public String wfCreate(String hcxmlx, String id) {
        return wfCreate(hcxmlx, id, false);
    }

    @Override
    @Transactional
    public  String wfCreate(String hcxmlx, String id, boolean returnProid) {
        //创建核查任务的工作流项目
        Project project = new Project();
        String wiid = UUIDGenerator.generate();
        project.setProjectId(wiid);
        String wwid = workFlowIdMap.get(hcxmlx).toString();
        project.setWdid(wwid);
        project.setBz("");

        String userId = SessionUtil.getCurrentUserId();
        String taskName = "";
        if (hcxmlx.equals(Hcxmlx.ZDHC.toString())) {
            SSjZdqlr sSjZdqlr = baseRepository.get(SSjZdqlr.class, id);
            taskName = sSjZdqlr.getQlrmc();
        } else {
            SwDjJbb swDjJbb = baseRepository.get(SwDjJbb.class, id);
            taskName = swDjJbb.getNsrmc();
        }
        String taskId = "";
        try {
            taskId = platUtil.createWorkFlowInstance(project, userId, taskName);
        } catch (Exception e) {
            if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
                taskId = "java.lang:" + ((RuntimeException) e).getMessage().substring(0, ((RuntimeException) e).getMessage().length());
                return taskId;
            } else {
                throw new RuntimeException();
            }
        }

        SwHcXm swHcXm = new SwHcXm();
        swHcXm.setMc(Hcxmlx.getMcByDm(hcxmlx));
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(hcxmlx);
        swHcXm.setXmybj(Blzt.WBJ.toString());
        baseRepository.save(swHcXm);

        String shxrId = UUIDGenerator.generate();
        SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
        swHcXmRwRel.setShxrId(shxrId);
        swHcXmRwRel.setRwId(wiid);
        swHcXmRwRel.setSwHcXm(swHcXm);
        swHcXmRwRel.setBdId(id);
        swHcXmRwRel.setBlzt(Blzt.WBJ.toString());
        baseRepository.save(swHcXmRwRel);

        // 将关联的税务数据放到临时表中
        // 获取税源查询过滤条件
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("syzt", QueryCondition.EQ, Syzt.ZC.toString()));
        if (hcxmlx.equals(Hcxmlx.ZDHC.toString())) {
            SSjZdqlr sSjZdqlr = baseRepository.get(SSjZdqlr.class, id);
            queryConditionList.add(new QueryCondition("zd.qlrmc", QueryCondition.EQ, sSjZdqlr.getQlrmc()));
        } else if (hcxmlx.equals(Hcxmlx.SYHC.toString()) || hcxmlx.equals(Hcxmlx.FCSYHC.toString())) {
            queryConditionList.add(new QueryCondition("swDjJbb.jbbId", QueryCondition.EQ, id));
        } else if (hcxmlx.equals(Hcxmlx.MJBYZHC.toString())) {
            queryConditionList.add(new QueryCondition("swDjJbb.jbbId", QueryCondition.EQ, id));
        } else if (hcxmlx.equals(Hcxmlx.SBBYZHC.toString())) {
            queryConditionList.add(new QueryCondition("swDjJbb.jbbId", QueryCondition.EQ, id));
        }
        // 查询税源数据
        List<SwDjSy> swDjSyList = taxService.findSyList(queryConditionList);
        SwDjSyTemp swDjSyTemp = null;
        // 将税源数据放到临时表中
        if (CollectionUtils.isNotEmpty(swDjSyList)) {
            for (SwDjSy swDjSy : swDjSyList) {
                // 没有税源的放到临时表中
                if (swDjSy.getSwDjTd() == null && swDjSy.getSwDjFc() == null){
                    continue;
                }

                swDjSyTemp = taxService.copySyToTemp(swDjSy);
                swDjSyTemp.setSwHcXmRwRel(swHcXmRwRel);
                baseRepository.save(swDjSyTemp);
            }
        }

        if (returnProid) { // 返回proid而不是taskId
            taskId = wiid;
        }
        return  taskId;
    }

    @Override
    @Transactional
    public  String wfCreateZdgxhc(String hcxmlx, String groupid, List<SwDjSy> swDjSyList) {
        //创建核查任务的工作流项目
        Project project = new Project();
        String wiid = UUIDGenerator.generate();
        project.setProjectId(wiid);
        String wwid = workFlowIdMap.get(hcxmlx).toString();
        project.setWdid(wwid);
        project.setBz("");

        String userId = SessionUtil.getCurrentUserId();
        String taskName = Hcxmlx.getMcByDm(hcxmlx) + (new SimpleDateFormat("yyyy-mm-dd")).format(Calendar.getInstance().getTime()) + ":" + groupid;
        if (hcxmlx.equals(Hcxmlx.ZDGXHC.toString())) {
            for (SwDjSy swDjSy : swDjSyList) {
            }
        }
        String taskId = "";
        try {
            taskId = platUtil.createWorkFlowInstance(project, userId, taskName);
        } catch (Exception e) {
            if (((RuntimeException)e).getMessage().equals("该用户不允许创建该流程")) {
                taskId = "java.lang:" + ((RuntimeException) e).getMessage().substring(0, ((RuntimeException) e).getMessage().length());
                return taskId;
            } else {
                throw new RuntimeException();
            }
        }

        SwHcXm swHcXm = new SwHcXm();
        swHcXm.setMc(Hcxmlx.getMcByDm(hcxmlx));
        swHcXm.setXmId(UUIDGenerator.generate());
        swHcXm.setCjrq(Calendar.getInstance().getTime());
        swHcXm.setCjrId(SessionUtil.getCurrentUserId());
        swHcXm.setXmlx(hcxmlx);
        swHcXm.setXmybj(Blzt.WBJ.toString());
        baseRepository.save(swHcXm);

        String shxrId = UUIDGenerator.generate();
        SwHcXmRwRel swHcXmRwRel = new SwHcXmRwRel();
        swHcXmRwRel.setShxrId(shxrId);
        swHcXmRwRel.setRwId(wiid);
        swHcXmRwRel.setSwHcXm(swHcXm);
        swHcXmRwRel.setBdId(groupid);
        swHcXmRwRel.setBlzt(Blzt.WBJ.toString());
        baseRepository.save(swHcXmRwRel);

        // 将关联的税务数据放到临时表中
        SwDjSyTemp swDjSyTemp = null;
        // 将税源数据放到临时表中
        if (CollectionUtils.isNotEmpty(swDjSyList)) {
            for (SwDjSy swDjSy : swDjSyList) {
                // 没有税源的放到临时表中
                if (swDjSy.getSwDjTd() == null && swDjSy.getSwDjFc() == null){
                    continue;
                }

                // 保存临时税源
                swDjSyTemp = taxService.copySyToTemp(swDjSy);
                swDjSyTemp.setSwHcXmRwRel(swHcXmRwRel);
                baseRepository.save(swDjSyTemp);

                // 保存税源
                swDjSy.setZd(null);
                taxService.updateSwDjSy(swDjSy);
            }
        }

        return  wiid;
    }

    // 根据proid获取对应的任务类型
    @Override
    public String getHcxmlx(String proid) {
        String hcxmlx = "";

        SwHcXmRwRel swHcXmRwRel = getSwHcXmRwRelByWiid(proid);
        hcxmlx = swHcXmRwRel.getSwHcXm().getXmlx();
        return hcxmlx;
    }

    @Override
    public String autoTurnWorkflow(String proid, String userId) {
        //任务自动转发
        String taskidZz = PlatUtil.getTaskIdByProid(proid);
        String turnXmlZz = null;
        try {
            turnXmlZz = initTurnTaskXml(proid, userId, taskidZz);
            Document docZz = DocumentHelper.parseText(turnXmlZz);
            workFlowCoreService.turnTask(docZz,taskidZz);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void doUpSwHcXmRwRel(SwHcXmRwRel swHcXmRwRel, String blzt){
        if (StringUtils.isEmpty(blzt))
                blzt = Blzt.YBJ.toString();
        swHcXmRwRel.setBlzt(blzt);
        baseRepository.update(swHcXmRwRel);
    }

    private void doUpSwHcXm(SwHcXmRwRel swHcXmRwRel){
        SwHcXm swHcXm = swHcXmRwRel.getSwHcXm();
        String xmId = swHcXm.getXmId();
        String jpql = "from SwHcXmRwRel o where o.swHcXm.xmId=?0 and o.blzt='0'";
        List<SwHcXmRwRel> swHcXmRwRelList = baseRepository.getByJpql(jpql,xmId);
        if(CollectionUtils.isEmpty(swHcXmRwRelList)){ // 说明该项目下的所有任务都已经办理完成
            swHcXm.setXmybj("1");
            baseRepository.update(swHcXm);
        }
    }

    @Transactional(readOnly = true)
    private SwHcXmRwRel getSwHcXmRwRelByWiid(String wiid) {
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("rwId", QueryCondition.EQ, wiid));
        return (SwHcXmRwRel)baseRepository.getSingleResult(SwHcXmRwRel.class, queryConditionList);
    }

    // 生成转发任务的xml信息
    private String initTurnTaskXml(String proid,String userId,String taskid) throws Exception{
        WorkFlowInfo info = workFlowCoreService.getWorkFlowTurnInfo(userId, taskid);
        WorkFlowTransInfo transInfo=info.getTransInfo();
        List<ActivityModel> lstTrans = transInfo.getTranActivitys();
        if (lstTrans != null && lstTrans.size() > 0) {
            String nextActivityDefineId = lstTrans.get(0).getDefineId();
            WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
            ActivityModel nextModel = workXml.getActivity(nextActivityDefineId);

            List<PerformerModel> performerList = nextModel.getPerformerList();
            if (performerList != null && performerList.size() > 0){
                String roleId = "";
                List<PfRoleVo> roleList = sysUserService.getRoleListByUser(userId);
                for (PerformerModel performerModel : performerList) {
                    if (StringUtils.isNotBlank(performerModel.getRoleId())){
                        boolean isok = false;
                        for (PfRoleVo roleVo : roleList){
                            if (StringUtils.equals(performerModel.getRoleId(),roleVo.getRoleId())){
                                roleId = performerModel.getRoleId();
                                isok = true;
                                break;
                            }
                        }
                        if (isok){
                            break;
                        }
                    }
                }

                String activityRelType = "";
                if (transInfo.getTransType().equalsIgnoreCase("and"))
                    activityRelType = "and";
                else
                    activityRelType = "or";

                String activitysElement = "<Activitys RelType=\"" + activityRelType + "\"";
                activitysElement += " SendSMS= \"false\"";
                activitysElement += ">";
                String activityElement = "<Activity ";
                activityElement += " Id=\"" + nextActivityDefineId + "\">";
                String userInfoElement = "<UserInfo ";
                userInfoElement += " RoleId=\"" + roleId + "\"";
                userInfoElement += " Id=\"" + "" + "\">";
                userInfoElement += "</UserInfo>";
                activityElement += userInfoElement;
                activityElement += "</Activity>";
                activitysElement += activityElement;

                String remarkElement = "<ReMark>";
                String remarkTextElement = "<text>";
                remarkTextElement += "</text>";
                remarkElement += remarkTextElement + "</ReMark>";
                activitysElement += remarkElement + "</Activitys>";
                return activitysElement;
            }
        }
        return null;
    }

    // 获取转发人列表
    @Override
    public PerformerTaskModel getTurnUserList(String userId, String proid) throws  Exception {
        PerformerTaskModel result=new PerformerTaskModel();
        try {
            //获取工作流转发信息
            String taskid = PlatUtil.getTaskIdByProid(proid);
            if (StringUtils.isNotBlank(taskid)){
                WorkFlowInfo info = workFlowCoreService.getWorkFlowTurnInfo(userId, taskid);
                // 活动模型
                WorkFlowXml workXml = WorkFlowXmlUtil.getInstanceModel(info.getWorkFlowIntanceVo());
                String activityDefinitionId = info.getSourceActivity().getActivityDefinitionId();
                ActivityModel activityModel = workXml.getActivity(activityDefinitionId);
                // 定义转发列表
                List<TransitionModel> lstTrans = activityModel.getTransitionsList();
                List<ActivityModel> tranActivitys = new ArrayList<ActivityModel>();
                for (TransitionModel transModel : lstTrans) {
                    String nextActivityDefineId = transModel.getToId();
                    ActivityModel nextModel = workXml.getActivity(nextActivityDefineId);
                    List<PerformerModel> performerList = nextModel.getPerformerList();
                    for (PerformerModel performerModel : performerList) {
                        if (!performerModel.getUserId().equals("")) {// 参与者是人
                            String userid = performerModel.getUserId();
                            PfUserVo userVo = sysUserService.getUserVo(userid);
                            List<PfOrganVo> organs=sysUserService.getOrganListByUser(userVo.getUserId());
                            result.setName(organs.get(0).getOrganName());
                            result.setId("0");
                            result.getUserList().add(userVo);
                            result.setType("User");
                        } else if (!performerModel.getOrganId().equals("")) {// 参与者是部门
                            List<PfUserVo> users = sysUserService.getUserListByOragn(performerModel.getOrganId());
                            PfOrganVo organVo=sysUserService.getOrganVo(performerModel.getOrganId());
                            if (organVo!=null){
                                result.setName(organVo.getOrganName());
                                result.setId(organVo.getOrganId());
                                for(PfUserVo vo:users){
                                    result.getUserList().add(vo);
                                }
                            }
                            result.setType("Organ");
                        } else if (!performerModel.getRoleId().equals("")) {// 参与者是角色
                            List<PfUserVo> users = sysUserService.getUserListByRole(performerModel
                                    .getRoleId());
                            PfRoleVo roleVo = sysUserService.getRoleVo(performerModel
                                    .getRoleId());
                            result.setName(roleVo.getRoleName());
                            result.setId(roleVo.getRoleId());
                            for(PfUserVo vo:users){
                                result.getUserList().add(vo);
                            }
                            result.setType("Role");
                        }
                    }
                }
            }
        }catch (Exception e){
            e.printStackTrace();
        }
        return result;
    }
}
