package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.util.*;

/**
 * Created by zhouzhiwei on 2015/8/8.
 */
@Service
public class TjServiceImpl implements TjService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    ArrayList tjBaseParamList;


    @Override
    @Transactional(readOnly = true)
    public Page getTjJson(Pageable request, String sqlTag, List<QueryCondition> queryConditionList) {
        Page page = null;

        String sql = getTjSql(sqlTag);
        if (StringUtils.isNotEmpty(sql)) {
            Query query = createQuery(sql, queryConditionList, null, false);
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            Query countQuery = createQuery(sql, queryConditionList, null, true);
            page =  baseRepository.find(query, countQuery, request);
        } else {
            TjBaseParamVo tjBaseParamVo = getTjBaseParam(sqlTag);
            Class aclass = getTjEntityClass(sqlTag);
            List<QueryCondition> customQueryConditionList = tjBaseParamVo.getQueryConditionList();
            if (CollectionUtils.isNotEmpty(customQueryConditionList))
                queryConditionList.addAll(customQueryConditionList);
            if (aclass != null) {
                page =  baseRepository.find(aclass, queryConditionList, tjBaseParamVo.getOrderBy(), request);
            }
        }

        return page;
    }

    @Override
    @Transactional(readOnly = true)
    public List getTjList(String sqlTag, List<QueryCondition> queryConditionList) {
        List<HashMap<String, Object>> list = null;
        String sql = getTjSql(sqlTag);
        if (StringUtils.isNotEmpty(sql)) {
            Query query = createQuery(sql, queryConditionList, null, false);
            query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
            list = query.getResultList();
        } else {
            TjBaseParamVo tjBaseParamVo = getTjBaseParam(sqlTag);
            Class aclass = getTjEntityClass(sqlTag);
            List<QueryCondition> customQueryConditionList = tjBaseParamVo.getQueryConditionList();
            if (CollectionUtils.isNotEmpty(customQueryConditionList))
                queryConditionList.addAll(customQueryConditionList);
            if (aclass != null) {
                list =  baseRepository.list(aclass, queryConditionList, tjBaseParamVo.getOrderBy());
            }
        }

        return list;
    }

    @Override
    public TjBaseParamVo getTjBaseParam(String tag) {
        TjBaseParamVo tjBaseParam = null;
        String tagValue;
        if (tjBaseParamList != null) {
            for (int i = 0; i < tjBaseParamList.size(); i++) {
                tagValue = ((TjBaseParamVo)tjBaseParamList.get(i)).getTag();
                if (tagValue.equals(tag)) {
                    tjBaseParam = (TjBaseParamVo)tjBaseParamList.get(i);
                    break;
                }
            }
        }
        return tjBaseParam;
    }

    @Override
    public String getTjSql(String sqlTag) {
        String sqlBase = "";
        TjBaseParamVo tjBaseParam = getTjBaseParam(sqlTag);
        if (tjBaseParam != null) {
            sqlBase = tjBaseParam.getSql();
        }
        return sqlBase;
    }

    private Class getTjEntityClass(String sqlTag) {
        Class aClass = null;
        TjBaseParamVo tjBaseParam = getTjBaseParam(sqlTag);
        if (tjBaseParam != null) {
            if (StringUtils.isNotEmpty(tjBaseParam.getEntityName())) {
                try {
                    aClass = Class.forName(tjBaseParam.getEntityName());
                } catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return aClass;
    }

    /**
     * 根据sql语句跟查询条件获取Query
     *
     * @param sql
     * @param queryConditions
     * @param orderBy
     * @param isQueryTotal    是否查询记录总数, true 则查询记录总数
     * @return
     */
    @Override
    public Query createQuery(String  sql, List<QueryCondition> queryConditions, String orderBy, boolean isQueryTotal) {
        return createQuery(sql, null, queryConditions, orderBy, isQueryTotal);
    }

    @Override
    public Query createQuery(String  sql, String resultExpression, List<QueryCondition> queryConditions, String orderBy, boolean isQueryTotal) {
        if (StringUtils.isEmpty(resultExpression))
            resultExpression = "*";
        StringBuffer sqlQuery = new StringBuffer("SELECT " + resultExpression + " FROM (" + sql + ") WHERE 1=1");
        if (queryConditions != null && queryConditions.size() > 0) {
            //构造sql语句
            Iterator<QueryCondition> iterator = queryConditions.iterator();
            while (iterator.hasNext()) {
                QueryCondition queryCondition = iterator.next();
                if (queryCondition != null) {
                    if (queryCondition.getOperator().equals(QueryCondition.CUSTOM)) {
                        sqlQuery.append(" AND (").append(queryCondition.getCustomJPQL()).append(")");
                    }
                    if (queryCondition.getValue() != null && !"".equals(queryCondition.getValue())) {
                        //如果占位符名称是*.*格式，则换成*_*格式。且：和名称之间不能有空格
                        String placeholder = queryCondition.getField().indexOf(".") != -1 ? queryCondition.getField().replace(".", "_") : queryCondition.getField();
                        String operator = queryCondition.getOperator();
                        if (operator.equals(QueryCondition.LLK) || operator.equals(QueryCondition.RLK))
                            operator = QueryCondition.LK;
                        sqlQuery.append(" AND ").append(queryCondition.getField().trim())
                                .append(" ").append(operator).append(":").append(placeholder.trim());
                    }
                }

            }
        }
        if (isQueryTotal) {
            sqlQuery.insert(0, "select count(*) from (").append(")");
        } else if (orderBy != null && !"".equals(orderBy)) {
            sqlQuery.append(" ").append(orderBy);
        }

        Query query = baseRepository.getEntityManager().createNativeQuery(sqlQuery.toString());

        if (queryConditions != null && queryConditions.size() > 0) {
            //为参数赋值
            Iterator<QueryCondition> iterator2 = queryConditions.iterator();
            while (iterator2.hasNext()) {
                QueryCondition queryCondition = iterator2.next();
                if (queryCondition != null) {
                    if (queryCondition.getValue() != null && !"".equals(queryCondition.getValue())) {
                        //将占位符中的.替换成_
                        String queryConditionField = queryCondition.getField().indexOf(".") != -1 ? queryCondition.getField().replace(".", "_") : queryCondition.getField();
                        if (queryCondition.getOperator().equals(QueryCondition.LK)) {
                            query.setParameter(queryConditionField, "%" + queryCondition.getValue() + "%");
                        } else if (queryCondition.getOperator().equals(QueryCondition.LLK)) {
                            query.setParameter(queryConditionField, queryCondition.getValue() + "%");
                        } else if (queryCondition.getOperator().equals(QueryCondition.RLK)) {
                            query.setParameter(queryConditionField, "%" + queryCondition.getValue());
                        } else {
                            query.setParameter(queryConditionField, queryCondition.getValue());
                        }
                    }
                }

            }
        }

        return query;
    }
}
