package cn.gtmap.landtax.service.impl;


import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Czlx;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

@Service
public class TaxServiceImpl implements TaxService {
    @Autowired
    BaseRepository baseRepository;

    @Override
    @Transactional(readOnly = true, propagation = Propagation.NOT_SUPPORTED)
    public Page<SwDjSy> findSwdjTdMap(SwDjSyQuery swDjSyQuery, Pageable pageable) {
        List<QueryCondition> list = addParameter(swDjSyQuery);
        list.add(new QueryCondition("swDjTd.tdId is not null"));
        return baseRepository.find(SwDjSy.class, list, null, pageable);
    }

    @Override
    @Transactional(readOnly = true, propagation = Propagation.NOT_SUPPORTED)
    public Page<SwDjSy> findSwdjFcMap(SwDjSyQuery swDjSyQuery, Pageable pageable) {
        List<QueryCondition> list = addParameter(swDjSyQuery);
        list.add(new QueryCondition("swDjFc.fcId is not null"));
        return baseRepository.find(SwDjSy.class, list, null, pageable);
    }

    @Override
    @Transactional(readOnly = true, propagation = Propagation.NOT_SUPPORTED)
    public SwDjJbb findSwDjJbbByGlbm(String glbm) {
        String jpql = "from SwDjJbb where glbm=?0";
        List list = baseRepository.getByJpql(jpql,glbm);
        if(CollectionUtils.isNotEmpty(list)){
            return (SwDjJbb)(list.get(0));
        }
        return null;
    }

    @Override
    @Transactional(readOnly = true, propagation = Propagation.NOT_SUPPORTED)
    public SwDjJbbTemp findSwDjJbbTempByGlbm(String glbm) {
        String jpql = "from SwDjJbbTemp where glbm=?0";
        List list = baseRepository.getByJpql(jpql,glbm);
        if(CollectionUtils.isNotEmpty(list)){
            return (SwDjJbbTemp)(list.get(0));
        }
        return null;
    }

    @Override
    @Transactional(readOnly = true, propagation = Propagation.NOT_SUPPORTED)
    public SwDjJbb findSwDjJbbById(String jbbId) {
        return baseRepository.get(SwDjJbb.class, jbbId);
    }

    @Override
    @Transactional
    public void updateSwDjSy(SwDjSy swDjSy) {
        if (StringUtils.isEmpty(swDjSy.getSyId()))
            swDjSy.setSyId(UUIDGenerator.generate());

        SwDjSy swDjSyOld = baseRepository.get(SwDjSy.class, swDjSy.getSyId());

        if (swDjSy.getSwDjJbb() != null) {
            SwDjJbb swDjJbb = findSwDjJbbById(swDjSy.getSwDjJbb().getJbbId());
            if (swDjJbb == null) { // 添加纳税人
                baseRepository.save(swDjSy.getSwDjJbb());
            } else { // 更新纳税人
                try {
                    swDjJbb = (SwDjJbb) CommonUtil.copyPropertyForSave(swDjSy.getSwDjJbb(), swDjJbb);
                    baseRepository.update(swDjJbb);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        addSwDjSyUpdateInfo(swDjSy, Czlx.UPDATE.toString());
        if (swDjSyOld != null) { // 修改
            // 保存历史记录
            SwDjSyHis swDjSyHis = copySyToHis(swDjSyOld);
            baseRepository.save(swDjSyHis);

            // 判断已存在的税源数据是否被删除状态
            if (swDjSyOld.getSyzt().equalsIgnoreCase(Syzt.SC.toString())) {
                // 同步删除之前的土地税跟房产税主键值
                if (swDjSy.getSwDjTd() != null && swDjSyOld.getSwDjTd() != null) {
                    swDjSy.getSwDjTd().setTdId(swDjSyOld.getSwDjTd().getTdId());
                }
                if (swDjSy.getSwDjFc() != null && swDjSyOld.getSwDjFc() != null) {
                    swDjSy.getSwDjFc().setFcId(swDjSyOld.getSwDjFc().getFcId());
                }
            }

            try {
                swDjSy = (SwDjSy)CommonUtil.copyPropertyForSave(swDjSy, swDjSyOld);
            } catch (Exception e) {
                e.printStackTrace();
            }
            // 更新
            baseRepository.update(swDjSy);
        } else {
            // 保存
            baseRepository.save(swDjSy);
        }

    }

    @Override
    @Transactional
    public void deleteSwDjSy(String syId) {
        SwDjSy swDjSyOld = baseRepository.get(SwDjSy.class, syId);

        if (swDjSyOld != null) { // 修改
            // 保存历史记录
            SwDjSyHis swDjSyHis = copySyToHis(swDjSyOld);
            baseRepository.save(swDjSyHis);

            // 更新
            addSwDjSyUpdateInfo(swDjSyOld, Czlx.DELETE.toString());
            baseRepository.update(swDjSyOld);
        }
    }

    @Override
    @Transactional
    public void updateSwDjSyTemp(SwDjSyTemp swDjSyTemp) {
        if (StringUtils.isEmpty(swDjSyTemp.getSyId()))
            swDjSyTemp.setSyId(UUIDGenerator.generate());

        SwDjSyTemp swDjSyTempOld = baseRepository.get(SwDjSyTemp.class, swDjSyTemp.getTempId());

        addSwDjSyTempUpdateInfo(swDjSyTemp, Czlx.UPDATE.toString());
        if (swDjSyTempOld != null) { // 修改
            // 判断已存在的税源数据是否被删除状态
            if (swDjSyTempOld.getSyzt().equalsIgnoreCase(Syzt.SC.toString())) {
                // 同步删除之前的土地税跟房产税主键值
                if (swDjSyTemp.getSwDjTdTemp() != null && swDjSyTempOld.getSwDjTdTemp() != null) {
                    swDjSyTemp.getSwDjTdTemp().setTempId(swDjSyTempOld.getSwDjTdTemp().getTempId());
                }
                if (swDjSyTemp.getSwDjFcTemp() != null && swDjSyTempOld.getSwDjFcTemp() != null) {
                    swDjSyTemp.getSwDjFcTemp().setTempId(swDjSyTempOld.getSwDjFcTemp().getTempId());
                }
                // 更新
                baseRepository.update(swDjSyTemp);
            } else {
                // 更新
                baseRepository.update(swDjSyTemp);
            }
        } else {
            // 保存
            baseRepository.save(swDjSyTemp);
        }

    }

    @Override
    @Transactional
    public void deleteSwDjSyTemp(String tempId) {
        SwDjSyTemp swDjSyTempOld = baseRepository.get(SwDjSyTemp.class, tempId);

        if (swDjSyTempOld != null) { // 修改
            // 更新
            addSwDjSyTempUpdateInfo(swDjSyTempOld, Czlx.DELETE.toString());
            baseRepository.update(swDjSyTempOld);
        }
    }

    // 添加当前人员与时间信息
    @Override
    public void addSwDjSyUpdateInfo(SwDjSy swDjSy, String czlx) {
        if (swDjSy != null && StringUtils.isNotEmpty(czlx)) {
            UserInfo userInfo = SessionUtil.getCurrentUser();
            if (userInfo != null) {
                swDjSy.setUpdateUserid(userInfo.getId());
                swDjSy.setUpdateUsername(userInfo.getUsername());
                swDjSy.setUpdateRq(Calendar.getInstance().getTime());
            }
            if (czlx.equalsIgnoreCase(Czlx.DELETE.toString())) {
                swDjSy.setCzlx(Czlx.DELETE.toString());
                swDjSy.setSyzt(Syzt.SC.toString());
            } else {
                swDjSy.setCzlx(Czlx.UPDATE.toString());
                swDjSy.setSyzt(Syzt.ZC.toString());
            }
        }
    }

    // 添加当前人员与时间信息
    @Override
    public void addSwDjSyTempUpdateInfo(SwDjSyTemp swDjSyTemp, String czlx) {
        if (swDjSyTemp != null && StringUtils.isNotEmpty(czlx)) {
            UserInfo userInfo = SessionUtil.getCurrentUser();
            if (userInfo != null) {
                swDjSyTemp.setUpdateUserid(userInfo.getId());
                swDjSyTemp.setUpdateUsername(userInfo.getUsername());
                swDjSyTemp.setUpdateRq(Calendar.getInstance().getTime());
            }
            if (czlx.equalsIgnoreCase(Czlx.DELETE.toString())) {
                swDjSyTemp.setCzlx(Czlx.DELETE.toString());
                swDjSyTemp.setSyzt(Syzt.SC.toString());
            } else {
                swDjSyTemp.setCzlx(Czlx.UPDATE.toString());
                swDjSyTemp.setSyzt(Syzt.ZC.toString());
            }
        }
    }

    @Override
    public SwDjSyHis copySyToHis(SwDjSy swDjSy) {
        String hisId = UUIDGenerator.generate();
        SwDjSyHis swDjSyHis = new SwDjSyHis();
        BeanUtils.copyProperties(swDjSy, swDjSyHis);
        swDjSyHis.setHisId(hisId);
        if (swDjSy.getSwDjJbb() != null) {
            SwDjJbbHis swDjJbbHis = new SwDjJbbHis();
            BeanUtils.copyProperties(swDjSy.getSwDjJbb(), swDjJbbHis);
            swDjJbbHis.setHisId(hisId);
            swDjSyHis.setSwDjJbbHis(swDjJbbHis);
        }
        if (swDjSy.getSwDjTd() != null) {
            SwDjTdHis swDjTdHis = new SwDjTdHis();
            BeanUtils.copyProperties(swDjSy.getSwDjTd(), swDjTdHis);
            swDjTdHis.setHisId(hisId);
            swDjSyHis.setSwDjTdHis(swDjTdHis);
        }
        if (swDjSy.getSwDjFc() != null) {
            SwDjFcHis swDjFcHis = new SwDjFcHis();
            BeanUtils.copyProperties(swDjSy.getSwDjFc(), swDjFcHis);
            swDjFcHis.setHisId(hisId);
            swDjSyHis.setSwDjFcHis(swDjFcHis);
        }
        if (swDjSy.getZd() != null) {
            Zd zd = new Zd();
            BeanUtils.copyProperties(swDjSy.getZd(), zd);
            swDjSyHis.setZd(zd);
        }

        return swDjSyHis;
    }

    @Override
    public SwDjSyTemp copySyToTemp(SwDjSy swDjSy) {
        String tempId = UUIDGenerator.generate();
        SwDjSyTemp swDjSyTemp = new SwDjSyTemp();
        BeanUtils.copyProperties(swDjSy, swDjSyTemp);
        swDjSyTemp.setTempId(tempId);
        if (swDjSy.getSwDjJbb() != null) {
            SwDjJbbTemp swDjJbbTemp = new SwDjJbbTemp();
            BeanUtils.copyProperties(swDjSy.getSwDjJbb(), swDjJbbTemp);
            swDjJbbTemp.setTempId(tempId);
            swDjSyTemp.setSwDjJbbTemp(swDjJbbTemp);
        }
        if (swDjSy.getSwDjTd() != null) {
            SwDjTdTemp swDjTdTemp = new SwDjTdTemp();
            BeanUtils.copyProperties(swDjSy.getSwDjTd(), swDjTdTemp);
            swDjTdTemp.setTempId(tempId);
            swDjSyTemp.setSwDjTdTemp(swDjTdTemp);
        }
        if (swDjSy.getSwDjFc() != null) {
            SwDjFcTemp swDjFcTemp = new SwDjFcTemp();
            BeanUtils.copyProperties(swDjSy.getSwDjFc(), swDjFcTemp);
            swDjFcTemp.setTempId(tempId);
            swDjSyTemp.setSwDjFcTemp(swDjFcTemp);
        }
        if (swDjSy.getZd() != null) {
            Zd zd = new Zd();
            BeanUtils.copyProperties(swDjSy.getZd(), zd);
            swDjSyTemp.setZd(zd);
        }

        return swDjSyTemp;
    }

    @Override
    public SwDjSy copyTempToSy(SwDjSyTemp swDjSyTemp) {
        SwDjSy swDjSy = new SwDjSy();
        BeanUtils.copyProperties(swDjSyTemp, swDjSy);
        if (swDjSyTemp.getSwDjJbbTemp() != null) {
            SwDjJbb swDjJbb = new SwDjJbb();
            BeanUtils.copyProperties(swDjSyTemp.getSwDjJbbTemp(), swDjJbb);
            swDjSy.setSwDjJbb(swDjJbb);
        }
        if (swDjSyTemp.getSwDjTdTemp() != null) {
            SwDjTd swDjTd = new SwDjTd();
            BeanUtils.copyProperties(swDjSyTemp.getSwDjTdTemp(), swDjTd);
            swDjTd.setTdId(swDjSyTemp.getSwDjTdTemp().getTempId());
            swDjSy.setSwDjTd(swDjTd);
        }
        if (swDjSyTemp.getSwDjFcTemp() != null) {
            SwDjFc swDjFc = new SwDjFc();
            BeanUtils.copyProperties(swDjSyTemp.getSwDjFcTemp(), swDjFc);
            swDjFc.setFcId(swDjSyTemp.getSwDjFcTemp().getTempId());
            swDjSy.setSwDjFc(swDjFc);
        }
        if (swDjSyTemp.getZd() != null) {
            Zd zd = new Zd();
            BeanUtils.copyProperties(swDjSyTemp.getZd(), zd);
            swDjSy.setZd(zd);
        }

        return swDjSy;
    }

    @Override
    @Transactional(readOnly = true, propagation = Propagation.NOT_SUPPORTED)
    public List<SwDjSy> findSyList(List<QueryCondition> queryConditionList) {
        if (queryConditionList == null)
            queryConditionList = new ArrayList<QueryCondition>();

        return baseRepository.list(SwDjSy.class, queryConditionList);
    }

    @Override
    @Transactional(readOnly = true, propagation = Propagation.NOT_SUPPORTED)
    public List<SwDjSyTemp> findSyTempList(List<QueryCondition> queryConditionList) {
        if (queryConditionList == null)
            queryConditionList = new ArrayList<QueryCondition>();

        return baseRepository.list(SwDjSyTemp.class, queryConditionList);
    }

    @Override
    public void updateSyZdInfo(String syId, String djhNew) {
        if (StringUtils.isEmpty(syId) || StringUtils.isEmpty(djhNew))
            return;

        SwDjSy swDjSy = baseRepository.get(SwDjSy.class, syId);
        Zd zd = baseRepository.get(Zd.class, djhNew);
        if (swDjSy == null || zd == null)
            return;

        swDjSy.setZd(zd);
        swDjSy.setBz("宗地变更信息更新");
        updateSwDjSy(swDjSy);
    }

    private List<QueryCondition> addParameter(SwDjSyQuery swDjSyQuery){
        List<QueryCondition> list = new ArrayList<QueryCondition>();
        if(StringUtils.isNotBlank(swDjSyQuery.getGlbm())){
            list.add(new QueryCondition("swDjJbb.glbm",QueryCondition.LK,swDjSyQuery.getGlbm()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getDjh())){
            list.add(new QueryCondition("zd.djh",QueryCondition.LK,swDjSyQuery.getDjh()));
        }
        if(StringUtils.isNotBlank(swDjSyQuery.getNsrmc())){
            list.add(new QueryCondition("swDjJbb.nsrmc",QueryCondition.LK,swDjSyQuery.getNsrmc()));
        }
        list.add(new QueryCondition("syzt=1"));
        list.add(new QueryCondition("zd.djh is not null"));
        return list;
    }
}
