package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Syzt;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.SyhcService;
import cn.gtmap.landtax.service.TaxService;
import cn.gtmap.landtax.service.WorkFlowService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.CommonUtil;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.util.*;

/**
 * Created by user on 2015/9/4.
 */
@Service
public class SyhcServiceImpl implements SyhcService{
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    WorkFlowService workFlowService;
    @Autowired
    HcxmService hcxmService;

    @Override
    public List getSyxx(String param){
        String hm = UUIDGenerator.generate();
        List<QueryCondition> paramList = new ArrayList<QueryCondition>();
        paramList.add(new QueryCondition("shxrId",QueryCondition.EQ, param));
        List syTempList = baseRepository.list(SwHcXmRwRel.class, paramList);
        Set<SwDjSyTemp> swDjSyTempSet = ((SwHcXmRwRel)syTempList.get(0)).getSwDjSyTempSet();
        List<SwDjSyTemp> swDjSyTemp = new ArrayList<SwDjSyTemp>();
        if(swDjSyTempSet.size()>0){
//            swDjSyTemp = (List<SwDjSyTemp>)swDjSyTempSet;
            swDjSyTemp.addAll(swDjSyTempSet);
        }

        return swDjSyTemp;
    }

    @Override
    public SwDjJbbTemp getswDjJbbTempByDjh(String jbbId){
        List<QueryCondition> paramList = new ArrayList<QueryCondition>();
        paramList.add(new QueryCondition("jbbId",QueryCondition.EQ,jbbId));
        SwDjJbbTemp swDjJbbTemp = new SwDjJbbTemp();
        swDjJbbTemp = (SwDjJbbTemp)baseRepository.list(SwDjJbbTemp.class,paramList).get(0);
        return swDjJbbTemp;
    }

    @Override
    public Zd getZd(String djh){
        List<QueryCondition> paramList = new ArrayList<QueryCondition>();
        paramList.add(new QueryCondition("djh",QueryCondition.EQ,djh));
        Zd zd = (Zd)baseRepository.list(Zd.class,paramList).get(0);
        return  zd;
    }

    @Override
    @Transactional
    public void deleteSwdjSy(String tempId)throws Exception{
        SwDjSyTemp swDjSyTemp = new SwDjSyTemp();
        swDjSyTemp = baseRepository.get(SwDjSyTemp.class,tempId);
        swDjSyTemp.setSyzt("2");
        baseRepository.update(swDjSyTemp);
    }

    @Override
    public SwDjSyTemp getswDjSyTempBytempId(String tempId){

        SwDjSyTemp swDjSyTemp = baseRepository.get(SwDjSyTemp.class,tempId);
        SwDjFcTemp swDjFcTemp = new SwDjFcTemp();
        SwDjTdTemp swDjTdTemp = new SwDjTdTemp();
        if(swDjSyTemp.getSwDjFcTemp()==null){
            swDjSyTemp.setSwDjFcTemp(swDjFcTemp);
        }
        if (swDjSyTemp.getSwDjTdTemp()==null){
            swDjSyTemp.setSwDjTdTemp(swDjTdTemp);
        }
        return  swDjSyTemp;

    }

    @Override
    public SwDjJbb getQlrList(String bdId){
        List<QueryCondition> paramList = new ArrayList<QueryCondition>();
        paramList.add(new QueryCondition("jbbId",QueryCondition.EQ,bdId));
        List<SwDjJbb> tempList = baseRepository.list(SwDjJbb.class,paramList);
        SwDjJbb swDjJbb = new SwDjJbb();
        if(tempList.size()>0){
            swDjJbb = (SwDjJbb)tempList.get(0);
        }
        return  swDjJbb;
    }

    @Override
    public String getZdList(String bdId){
        String sql="";
        sql="SELECT QLRMC FROM  S_SJ_ZDQLR  t WHERE t.QLR_ID='" + bdId + "'";
        Query query = baseRepository.getEntityManager().createNativeQuery(sql);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,String>> tempList = query.getResultList();
        String  qlrmc = "";
        if(tempList.size()>0){
            qlrmc = String.valueOf(tempList.get(0).get("QLRMC"));
        }
        return qlrmc;

    }
    @Override
    public  List<SwDjSy> findSyList(List<QueryCondition> paramList){
//        SwDjSy swDjSy = new SwDjSy();
        List<SwDjSy> tempList = new ArrayList<SwDjSy>();

        tempList = baseRepository.list(SwDjSy.class,paramList);
        return  tempList;
    }
    @Override
    @Transactional
    public void saveSy(SwDjSy swDjSy)throws Exception{
        baseRepository.save(swDjSy);
    }

    @Override
    @Transactional
    public void saveSyTemp(SwDjSyTemp swDjSyTemp)throws Exception{
        String tempId = swDjSyTemp.getTempId();
        SwDjSyTemp swDjSyTempOld = new SwDjSyTemp();
        swDjSyTempOld = baseRepository.get(SwDjSyTemp.class,tempId);
        
        if(swDjSyTempOld!=null){
            swDjSyTempOld = (SwDjSyTemp) CommonUtil.copyPropertyForSave(swDjSyTemp, swDjSyTempOld);
            baseRepository.update(swDjSyTempOld);
        }else {
            baseRepository.save(swDjSyTemp);
        }
    }

    @Override
    public String getUserRegionCode(){
        UserInfo userInfo = SessionUtil.getCurrentUser();
        String regionCode = userInfo.getRegionCode();
        return regionCode;
    }
}
