package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.service.MapService;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.io.*;

/**
 * .
 * <p/>
 * 地图功能服务
 *
 * @author yang
 * @version V1.0, 14-5-29
 */
@Service
public class MapServiceImpl implements MapService {


    @Value("${egov.conf}/landtax/map.json")
    String configPath;

    @Override
    @Cacheable(value = "mapConfig")
    public Object getMapConfig() throws Exception {
        return readJsonFile(configPath);
    }

    private Object readJsonFile(String path) throws Exception {
        if (StringUtils.isNotBlank(path)) {
            if (path.indexOf("file:/") > -1)
                path = path.substring(path.indexOf("file:/") + 6);
            File file = new File(path);
            if (!file.exists())
                throw new FileNotFoundException();
            BufferedReader bufferedReader = null;
            StringBuffer config = new StringBuffer();
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF-8"));
                String tmp = null;
                while ((tmp = bufferedReader.readLine()) != null) {
                    config.append(tmp);
                }
            } finally {
                if (bufferedReader != null)
                    bufferedReader.close();
            }
            if (StringUtils.isNotBlank(config.toString())) {
                return JSON.parse(config.toString());
            }
        }
        return null;
    }
}
