package cn.gtmap.landtax.service.impl;/**
 * Created by janeshen on 2014/8/21.
 */

import cn.gtmap.landtax.entity.SSjSignhcxm;
import cn.gtmap.landtax.entity.SwHcXmRwRel;
import cn.gtmap.landtax.model.dictionary.Blzt;
import cn.gtmap.landtax.model.dictionary.Hcxmlx;
import cn.gtmap.landtax.model.query.DictTreeGrid;
import cn.gtmap.landtax.service.HcxmService;
import cn.gtmap.landtax.service.TjService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SQLQuery;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Query;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author shenjian
 * @version V1.0, 2014/8/21
 */
@Service
public class HcxmServiceImpl implements HcxmService {
    @Autowired
    BaseRepository baseRepository;
    @Autowired
    HashMap activityIdMap;
    @Autowired
    TjService tjService;
    @Autowired
    SysUserService sysUserService;

    @Override
    @Transactional(readOnly = true)
    public Page HcxmPage(List<QueryCondition> queryConditionList, String hcxmlx, Pageable pageable) {
        String[] configArr = (String[]) activityIdMap.get(hcxmlx);
        String hcxmSql = getSqlByHcxmlx(hcxmlx);
        String sql = "SELECT t1.*, TO_CHAR(t4.USER_NAME) AS USER_NAME, " +
                    "       DECODE(t2.BLZT, " +
                    "              '1', '5', " +
                    "              DECODE(t4.ACTIVITY_DEFINITION_ID, " +
                    "                     :conf0, '1', " +
                    "                     :conf1, '2', " +
                    "                     :conf2, '3', " +
                    "                     :conf3, '4', " +
                    "                     '0' " +
                    "                     ) " +
                    "              ) AS STATUE " +
                    "FROM (" + hcxmSql + ") t1 " +
                    "     LEFT JOIN (SELECT * FROM SW_HC_XM_RW_REL WHERE HCXM_ID IN (SELECT ID FROM SW_HC_XM WHERE XMLX = :hclx) AND BLZT IN ('0', '1')) t2 on t1.BD_ID = t2.BD_ID " +
                    "     LEFT JOIN ( " +
                    "         SELECT t4.WORKFLOW_INSTANCE_ID, t4.ACTIVITY_DEFINITION_ID, t6.USER_NAME " +
                    "         FROM ( " +
                    "             SELECT * " +
                    "             FROM PF_ACTIVITY t " +
                    "             WHERE t.ACTIVITY_STATE='1' " +
                    "             ) t4 " +
                    "             LEFT JOIN PF_ASSIGNMENT t5 ON t5.ACTIVITY_ID=t4.ACTIVITY_ID " +
                    "             LEFT JOIN PF_USER t6 ON t5.USER_ID=t6.USER_ID " +
                    "     ) t4 ON t4.WORKFLOW_INSTANCE_ID=t2.RW_ID " +
                    "WHERE 1=1 ";

        String statue = "";
        if(StringUtils.isNotBlank(statue)) {
            if (statue.equals("5")) {
                sql = sql + " and t2.BLZT = '1' ";
            } else if (statue.equals("0")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and (t4.ACTIVITY_DEFINITION_ID NOT IN (:conf0, :conf1, :conf2, :conf3) OR t4.ACTIVITY_DEFINITION_ID IS NULL)";
            } else if (statue.equals("1")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and t4.ACTIVITY_DEFINITION_ID = :conf0 ";
            } else if (statue.equals("2")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID= :conf1 ";
            } else if (statue.equals("3")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID= :conf2 ";
            } else if (statue.equals("4")) {
                sql = sql + " and NVL(t2.BLZT, '0')='0' and  t4.ACTIVITY_DEFINITION_ID= :conf3 ";
            }
        }

        Query query = baseRepository.getEntityManager().createNativeQuery(sql)
                .setParameter("hclx", Hcxmlx.ZDHC.toString())
                .setParameter("conf0", configArr[0])
                .setParameter("conf1", configArr[1])
                .setParameter("conf2", configArr[2])
                .setParameter("conf3", configArr[3]);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        StringBuffer countSql = new StringBuffer("SELECT COUNT(*) FROM (").append(sql).append(")");
        Query countQuery = baseRepository.getEntityManager().createNativeQuery(countSql.toString())
                .setParameter("hclx", Hcxmlx.ZDHC.toString())
                .setParameter("conf0", configArr[0])
                .setParameter("conf1", configArr[1])
                .setParameter("conf2", configArr[2])
                .setParameter("conf3", configArr[3]);
        Page page =  baseRepository.find(query, countQuery, pageable);
        return page;
    }

    @Override
    @Transactional(readOnly = true)
    public List<SwHcXmRwRel> getHcXmRwRel(List<QueryCondition> queryConditionList) {
        if (queryConditionList == null)
            queryConditionList = new ArrayList<QueryCondition>();

        return baseRepository.list(SwHcXmRwRel.class, queryConditionList);
    }

    @Override
    public SwHcXmRwRel getCurSwHcXmRwRelByProid(String proid) {
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();

        queryConditionList.add(new QueryCondition("rwId", QueryCondition.EQ, proid));

        List<SwHcXmRwRel> swHcXmRwRelList = getHcXmRwRel(queryConditionList);

        SwHcXmRwRel swHcXmRwRel = null;
        if (CollectionUtils.isNotEmpty(swHcXmRwRelList))
            swHcXmRwRel = swHcXmRwRelList.get(0);

        return swHcXmRwRel;
    }

    @Override
    public SwHcXmRwRel getCurSwHcXmRwRelByRwid(String wiid) {
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();

        queryConditionList.add(new QueryCondition("bdId", QueryCondition.EQ, wiid));
        queryConditionList.add(new QueryCondition("blzt", QueryCondition.EQ, Blzt.WBJ.toString()));

        List<SwHcXmRwRel> swHcXmRwRelList = getHcXmRwRel(queryConditionList);

        SwHcXmRwRel swHcXmRwRel = null;
        if (CollectionUtils.isNotEmpty(swHcXmRwRelList))
            swHcXmRwRel = swHcXmRwRelList.get(0);

        return swHcXmRwRel;
    }

    @Override
    public Object hcjdRootJson(String hcxmlx, String id) {
        Integer flag = null;
        String regionCode = "";
        Boolean isSgy = false;
        String[] configArr = (String[]) activityIdMap.get(hcxmlx);
        UserInfo user = SessionUtil.getCurrentUser();
        String userId = user.getId();

        Integer length = null;

        String organId = "";
        if(StringUtils.isNotBlank(id)){
            regionCode = id;
            length  = regionCode.length() + 2;
        }else{
            regionCode = user.getRegionCode();
            if (regionCode.equals("32038102"))
                regionCode = "320381";
            length = regionCode.length();
        }

        if(length==6){//说明是区县管理员
            flag = 0;
        }else if(length==8 ){//
            flag = 1;
        }else if(length>8){
            flag = 2;
            //根据regionCode获取organId
            List<PfOrganVo> organList = sysUserService.getOrganByRegionCode(regionCode);
            if(CollectionUtils.isNotEmpty(organList)){
                organId = organList.get(0).getOrganId();
            }
        }
        String sql = "";
        if(!isSgy){
            if(flag==2){//说明是普通税务人员
                sql = "SELECT k.XZQDM, k.DWMC, k.USER_ID, " +
                        "       (k.ZS-k.YCL) AS WCL, k.YCL, k.ZS, ROUND(DECODE(k.ZS,0,1,k.YCL/k.ZS)*100,2) AS CLL " +
                        "FROM ( " +
                        "      SELECT d.USER_ID, d.USER_NAME, d.REGION_CODE AS XZQDM, d.USER_NAME AS DWMC, NVL(t.ZS, 0) AS ZS, NVL(t2.YCL, 0) AS YCL " +
                        "      FROM (SELECT TO_CHAR(t1.USER_ID) AS USER_ID, TO_CHAR(t1.USER_NAME) AS USER_NAME, t3.REGION_CODE, t3.ORGAN_NAME " +
                        "            FROM PF_USER t1 " +
                        "                 LEFT JOIN PF_USER_ORGAN_REL t2 ON t1.USER_ID=t2.USER_ID " +
                        "                 LEFT JOIN PF_ORGAN t3 ON t2.ORGAN_ID=t3.ORGAN_ID " +
                        "            WHERE t3.ORGAN_ID IS NOT NULL AND t3.ORGAN_ID = '" + organId + "' " +
                        "           ) d " +
                        "           LEFT JOIN ( " +
                        "              SELECT t5.USER_ID AS DM, COUNT(DISTINCT t.RW_ID) AS ZS " +
                        "              FROM SW_HC_XM_RW_REL t " +
                        "                   LEFT JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID= t1.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID= t2.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN ( " +
                        "                      SELECT * " +
                        "                      FROM ( " +
                        "                            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY t.BEGIN_TIME DESC) AS PM " +
                        "                            FROM ( " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  FROM PF_ASSIGNMENTHISTORY  " +
                        "                                  UNION ALL " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  from  PF_ASSIGNMENT " +
                        "                                  ) t " +
                        "                           ) " +
                        "                      WHERE PM=1 " +
                        "                   ) t5 on t5.ACTIVITY_ID=t2.ACTIVITY_ID " +
                        "                   LEFT JOIN SW_HC_XM t6 ON t.HCXM_ID=t6.ID " +
                        "              WHERE t6.xmlx= '" + hcxmlx + "' AND t2.ACTIVITY_STATE IN ('1','2','3') AND t2.ACTIVITY_DEFINITION_ID='" + configArr[flag] + "' " +
                        "              GROUP BY t5.USER_ID " +
                        "           ) t ON d.USER_ID=t.DM " +
                        "           LEFT JOIN ( " +
                        "              SELECT t5.USER_ID AS DM, COUNT(DISTINCT t.RW_ID) AS YCL " +
                        "              FROM SW_HC_XM_RW_REL t " +
                        "                   LEFT JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID= t1.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID= t2.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN ( " +
                        "                      SELECT * " +
                        "                      FROM ( " +
                        "                            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY t.BEGIN_TIME DESC) AS PM " +
                        "                            FROM ( " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  FROM PF_ASSIGNMENTHISTORY " +
                        "                                  UNION ALL " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  FROM  PF_ASSIGNMENT " +
                        "                                  ) t " +
                        "                           ) " +
                        "                      WHERE PM=1 " +
                        "                   ) t5 on t5.ACTIVITY_ID=t2.ACTIVITY_ID " +
                        "                   LEFT JOIN SW_HC_XM t6 ON t.HCXM_ID=t6.ID " +
                        "              WHERE t6.xmlx= '" + hcxmlx + "' AND t2.ACTIVITY_STATE='2' AND t1.WORKFLOW_STATE='2' AND t2.ACTIVITY_DEFINITION_ID='" + configArr[flag] + "' " +
                        "              GROUP BY t5.USER_ID " +
                        "           ) t2 ON d.USER_ID=t2.DM " +
                        "      ) k " +
                        "ORDER BY k.XZQDM ";
            }else{//说明有子节点
                sql = "SELECT k.XZQDM, k.DWMC, k.ORGAN_ID, " +
                        "       (k.ZS-k.YCL) AS WCL, k.YCL, k.ZS, ROUND(DECODE(k.ZS,0,1,k.YCL/k.ZS)*100,2) AS CLL " +
                        "FROM ( " +
                        "      SELECT d.REGION_CODE AS XZQDM, d.ORGAN_NAME AS DWMC, d.ORGAN_ID, d.ORGAN_NO, NVL(t.ZS, 0) AS ZS, NVL(t2.YCL, 0) AS YCL " +
                        "      FROM (SELECT t1.ORGAN_ID,t1.REGION_CODE,t1.ORGAN_NAME,t1.ORGAN_NO " +
                        "            FROM PF_ORGAN t1 " +
                        "            WHERE t1.REGION_CODE LIKE '" + regionCode + "%' AND LENGTH(t1.REGION_CODE)=" + length + " AND t1.REMARK IS NULL " +
                        "           ) d " +
                        "           LEFT JOIN ( " +
                        "              SELECT SUBSTR(t8.REGION_CODE,1," + length + ") AS DM, COUNT(DISTINCT t.RW_ID) AS ZS " +
                        "              FROM SW_HC_XM_RW_REL t " +
                        "                   LEFT JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID= t1.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID= t2.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN ( " +
                        "                      SELECT * " +
                        "                      FROM ( " +
                        "                            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY t.BEGIN_TIME DESC) AS PM " +
                        "                            FROM ( " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  FROM PF_ASSIGNMENTHISTORY  " +
                        "                                  UNION ALL " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  FROM  PF_ASSIGNMENT " +
                        "                                  ) t " +
                        "                           ) " +
                        "                      WHERE PM=1 " +
                        "                   ) t5 on t5.ACTIVITY_ID=t2.ACTIVITY_ID " +
                        "                   LEFT JOIN SW_HC_XM t6 ON t.HCXM_ID=t6.ID " +
                        "                   LEFT JOIN PF_USER_ORGAN_REL t7 ON t5.USER_ID=t7.USER_ID " +
                        "                   LEFT JOIN PF_ORGAN t8 ON t8.ORGAN_ID=t7.ORGAN_ID " +
                        "              WHERE t6.xmlx= '" + hcxmlx + "' AND t2.ACTIVITY_STATE IN ('1','2','3') AND t2.ACTIVITY_DEFINITION_ID='" + configArr[flag] + "' " +
                        "              GROUP BY SUBSTR(t8.REGION_CODE,1," + length + ") " +
                        "           ) t ON d.REGION_CODE=t.DM " +
                        "           LEFT JOIN ( " +
                        "              SELECT SUBSTR(t8.REGION_CODE,1," + length + ") AS DM, COUNT(DISTINCT t.RW_ID) AS YCL " +
                        "              FROM SW_HC_XM_RW_REL t " +
                        "                   LEFT JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID= t1.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID= t2.WORKFLOW_INSTANCE_ID " +
                        "                   LEFT JOIN ( " +
                        "                      SELECT * " +
                        "                      FROM ( " +
                        "                            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY t.BEGIN_TIME DESC) AS PM " +
                        "                            FROM ( " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  FROM PF_ASSIGNMENTHISTORY " +
                        "                                  UNION ALL " +
                        "                                  SELECT USER_ID, ACTIVITY_ID, BEGIN_TIME " +
                        "                                  FROM  PF_ASSIGNMENT " +
                        "                                  ) t " +
                        "                           ) " +
                        "                      WHERE PM=1 " +
                        "                   ) t5 on t5.ACTIVITY_ID=t2.ACTIVITY_ID " +
                        "                   LEFT JOIN SW_HC_XM t6 ON t.HCXM_ID=t6.ID " +
                        "                   LEFT JOIN PF_USER_ORGAN_REL t7 ON t5.USER_ID=t7.USER_ID " +
                        "                   LEFT JOIN PF_ORGAN t8 ON t8.ORGAN_ID=t7.ORGAN_ID " +
                        "              WHERE t6.xmlx= '" + hcxmlx + "' AND t2.ACTIVITY_STATE='2' AND t1.WORKFLOW_STATE='2' AND t2.ACTIVITY_DEFINITION_ID='" + configArr[flag] + "' " +
                        "              GROUP BY SUBSTR(t8.REGION_CODE,1," + length + ") " +
                        "           ) t2 ON d.REGION_CODE=t2.DM " +
                        "      ) k " +
                        "ORDER BY k.XZQDM ";
            }
        }


        Query query = baseRepository.getEntityManager().createNativeQuery(sql.toString());
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        List<HashMap<String,Object>> list = query.getResultList();
        List<DictTreeGrid> resultList = new ArrayList<DictTreeGrid>();
        if(CollectionUtils.isNotEmpty(list)){
            for(HashMap tempMap : list){
                DictTreeGrid tempGrid = new DictTreeGrid();
                tempGrid.setName(String.valueOf(tempMap.get("DWMC")));
                tempGrid.setZs(String.valueOf(tempMap.get("ZS")));
                tempGrid.setYcl(String.valueOf(tempMap.get("YCL")));
                tempGrid.setWcl(String.valueOf(tempMap.get("WCL")));
                tempGrid.setCll(String.valueOf(tempMap.get("CLL")));
                tempGrid.setXzqdm(String.valueOf(tempMap.get("XZQDM")));
                if(StringUtils.isNotBlank(tempGrid.getXzqdm()) && (length > 8 || isSgy)){
                    tempGrid.setXzqdm(String.valueOf(tempMap.get("USER_ID")));
                    tempGrid.setState("open");
                }
                tempGrid.setIconCls("empty");
                resultList.add(tempGrid);

            }
        }
        return resultList;
    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public Object getWclYclTzJson(Pageable pageable, String hcxmlx, String xzqdm, String xflx, String cllx, List<QueryCondition> queryConditionList) {
        String sql = getWclYclListSql(hcxmlx, xzqdm, xflx, cllx);

        Query query = tjService.createQuery(sql, queryConditionList, null, false);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        Query countQuery = tjService.createQuery(sql, queryConditionList, null, true);

        Page page = baseRepository.find(query, countQuery, pageable);
        return page;

    }

    @Override
    @Transactional(readOnly = true,propagation = Propagation.NOT_SUPPORTED)
    public List<HashMap> getWclYclTzList(String hcxmlx, String xzqdm, String xflx, String cllx, List<QueryCondition> queryConditionList) {
        String sql = getWclYclListSql(hcxmlx, xzqdm, xflx, cllx);

        Query query = tjService.createQuery(sql, queryConditionList, null, false);
        query.unwrap(SQLQuery.class).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP);
        return query.getResultList();

    }

    private String getWclYclListSql(String hcxmlx, String xzqdm, String xflx, String cllx) {
        String qxCode, fjCode, sgyCode;
        String[] configArr = (String[]) activityIdMap.get(hcxmlx);
        qxCode = configArr[0];
        fjCode = configArr[1];
        sgyCode = configArr[2];

        String cllxFilter = " 1=1 ";
        if ("1".equals(cllx)) {
            cllxFilter = " (t1.WORKFLOW_STATE IS NULL OR t1.WORKFLOW_STATE <> 2) ";
        }

        else if ("2".equals(cllx)) {
            cllxFilter = " t1.WORKFLOW_STATE=2 ";
        }

        String table = "";
        String keyField = "";
        String selectField = "";
        if (Hcxmlx.ZDHC.toString().equals(hcxmlx)) {
            table = "(SELECT TO_CHAR(t.QLRMC) AS QLRMC, ROUND(SUM(t.SYQMJ), 2) AS MJHJ_GT, " +
                    "       ROUND(SUM(td.NYNSE), 2) AS NYNSE_TD, ROUND(SUM(td.SCMJ), 2) AS SCMJ_TD, " +
                    "       t1.QLR_ID " +
                    "FROM ZD t " +
                    "     LEFT JOIN S_SJ_ZDQLR t1 ON t.QLRMC=t1.QLRMC " +
                    "     LEFT JOIN ( " +
                    "       SELECT t.* " +
                    "       FROM SW_HC_XM_RW_REL t " +
                    "            LEFT JOIN SW_HC_XM t1 ON t.HCXM_ID=t1.ID " +
                    "       WHERE t.BLZT IN ('1', '0') AND t1.XMLX='" + hcxmlx + "' " +
                    "     ) t2 ON t1.QLR_ID=t2.BD_ID " +
                    "     LEFT JOIN SW_DJ_SY_TEMP sy ON t2.SHXR_ID=sy.SHXR_ID " +
                    "     LEFT JOIN SW_DJ_TD_TEMP td ON sy.TEMP_ID=td.TEMP_ID " +
                    "WHERE t1.QLR_ID IS NOT NULL AND t.ZDLX='1' " +
                    "GROUP BY t.QLRMC, t1.QLR_ID)";
            keyField = "QLR_ID";
            selectField = "t9.QLRMC, t9.MJHJ_GT, t9.NYNSE_TD, t9.SCMJ_TD";
        }
        else if (Hcxmlx.SYHC.toString().equals(hcxmlx) || Hcxmlx.MJBYZHC.toString().equals(hcxmlx)) {
            table = "(SELECT t1.JBB_ID, t1.NSRMC, t1.GLBM, " +
                    "       ROUND(SUM(td.YNMJ), 2) AS YNMJ_TD, ROUND(SUM(td.NYNSE), 2) AS NYNSE_TD, ROUND(SUM(td.SCMJ), 2) AS SCMJ_TD, " +
                    "       ROUND(SUM(fc.FCYZ), 2) AS FCYZ_FC, ROUND(SUM(fc.CZFCYZ), 2) AS CZFCYZ_FC, ROUND(SUM(fc.FCYZ_MS), 2) AS FCYZ_MS_FC, " +
                    "       ROUND(SUM(fc.FCYZ_YS), 2) AS FCYZ_YS_FC, ROUND(SUM(fc.YNSE_ZY), 2) AS YNSE_ZY_FC, ROUND(SUM(fc.YNSE_CZ), 2) AS YNSE_CZ_FC, " +
                    "       ROUND(SUM(fc.NZJ), 2) AS NZJ_FC, ROUND(SUM(fc.NYNSE), 2) AS NYNSE_FC " +
                    "FROM SW_DJ_SY t " +
                    "     LEFT JOIN SW_DJ_JBB t1 ON t.JBB_ID=t1.JBB_ID " +
                    "     LEFT JOIN ( " +
                    "       SELECT t.* " +
                    "       FROM SW_HC_XM_RW_REL t " +
                    "            LEFT JOIN SW_HC_XM t1 ON t.HCXM_ID=t1.ID " +
                    "       WHERE t.BLZT IN ('1', '0') AND t1.XMLX='" + hcxmlx + "' " +
                    "     ) t2 ON t1.JBB_ID=t2.BD_ID " +
                    "     LEFT JOIN SW_DJ_SY_TEMP sy ON t2.SHXR_ID=sy.SHXR_ID " +
                    "     LEFT JOIN SW_DJ_TD_TEMP td ON sy.TEMP_ID=td.TEMP_ID " +
                    "     LEFT JOIN SW_DJ_FC_TEMP fc ON sy.TEMP_ID=fc.TEMP_ID " +
                    "WHERE t1.JBB_ID IS NOT NULL " +
                    "GROUP BY t1.JBB_ID, t1.NSRMC, t1.ZGKG_DM, t1.GLBM)";
            keyField = "JBB_ID";
            selectField = "t9.NSRMC,t9.GLBM,t9.YNMJ_TD,t9.NYNSE_TD,t9.SCMJ_TD,t9.FCYZ_FC,t9.CZFCYZ_FC,t9.FCYZ_MS_FC,t9.FCYZ_YS_FC,t9.YNSE_ZY_FC,t9.YNSE_CZ_FC,t9.NZJ_FC,t9.NYNSE_FC";
        }

        String filter = "";
        if (StringUtils.isEmpty(xflx) || xflx.equals("0")) {
            if (xzqdm == null || xzqdm.length() < 8) {
                filter = "";
            } else if (xzqdm.length() == 8) {
                filter = " AND t2.SSFJ_DM LIKE'" + xzqdm + "%'";
            } else if (xzqdm.length() > 8) {
                filter = " AND t2.SSSGY_DM='" + xzqdm + "'";
            }
        } else {
            if (xzqdm == null || xzqdm.length() < 8) {
                filter = " AND t2.SSQX_DM IS NULL ";
            } else if (xzqdm.length() == 8) {
                filter = " AND t2.SSFJ_DM LIKE'" + xzqdm + "%' AND t2.SSSGY_DM IS NULL";
            } else if (xzqdm.length() > 8) {
                filter = " AND t2.SSSGY_DM='" + xzqdm + "'";
            }
        }

        String sql = "";
        sql = "SELECT t1.*, t2.* " +
                "FROM ( " +
                "      SELECT DISTINCT t.RW_ID," + selectField + " " +
                "      FROM SW_HC_XM_RW_REL t " +
                "           JOIN PF_WORKFLOW_INSTANCE t1 ON t.RW_ID=t1.WORKFLOW_INSTANCE_ID " +
                "           JOIN PF_ACTIVITY t2 ON t1.WORKFLOW_INSTANCE_ID=t2.WORKFLOW_INSTANCE_ID " +
                "           JOIN SW_HC_XM t3 ON t.HCXM_ID=t3.ID " +
                "           LEFT JOIN " + table + " t9 ON t9." + keyField + "=t.BD_ID " +
                "      WHERE t3.XMLX='" + hcxmlx + "' AND t2.ACTIVITY_STATE IN ('1', '2', '3') AND " + cllxFilter + " " +
                "    ) t1 " +
                "    JOIN ( " +
                "      SELECT MAX(t1.ASSIGNMENT_ID) AS TASKID, t2.WORKFLOW_INSTANCE_ID, WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + qxCode + "', DECODE(LENGTH(t5.REGION_CODE), 6, t5.ORGAN_NAME, NULL))) AS SSQX, " +
                "             WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + fjCode + "', DECODE(LENGTH(t5.REGION_CODE), 8, t5.ORGAN_NAME, NULL))) AS SSFJ, " +
                "             WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + sgyCode + "', TO_CHAR(t3.USER_NAME))) AS SSSGY, " +
                "             WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + sgyCode + "', TO_CHAR(t3.USER_ID))) AS SSSGY_DM, " +
                "             WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + fjCode + "', DECODE(LENGTH(t5.REGION_CODE), 8, t5.REGION_CODE, NULL))) AS SSFJ_DM, " +
                "             WM_CONCAT(DISTINCT DECODE(t2.ACTIVITY_DEFINITION_ID, '" + qxCode + "', DECODE(LENGTH(t5.REGION_CODE), 6, t5.REGION_CODE, NULL))) AS SSQX_DM " +
                "      FROM ( " +
                "            SELECT t.*, RANK() OVER(PARTITION BY t.ACTIVITY_ID ORDER BY BEGIN_TIME DESC) AS PM " +
                "            FROM ( " +
                "                  SELECT USER_ID, ACTIVITY_ID, ASSIGNMENT_ID, BEGIN_TIME " +
                "                  FROM PF_ASSIGNMENTHISTORY " +
                "                  UNION ALL " +
                "                  SELECT USER_ID, ACTIVITY_ID, ASSIGNMENT_ID, BEGIN_TIME " +
                "                  FROM PF_ASSIGNMENT " +
                "                 ) t " +
                "           ) t1 " +
                "           LEFT JOIN PF_ACTIVITY t2 ON t1.ACTIVITY_ID=t2.ACTIVITY_ID " +
                "           LEFT JOIN PF_USER t3 ON t1.USER_ID=t3.USER_ID " +
                "           LEFT JOIN PF_USER_ORGAN_REL t4 on t1.USER_ID=t4.USER_ID " +
                "           LEFT JOIN PF_ORGAN t5 on t4.ORGAN_ID=t5.ORGAN_ID " +
                "      WHERE t1.PM=1 AND t2.ACTIVITY_STATE IN ('1', '2', '3') " +
                "      GROUP BY t2.WORKFLOW_INSTANCE_ID " +
                "    ) t2 ON t1.RW_ID=t2.WORKFLOW_INSTANCE_ID " +
                "WHERE 1=1 " + filter;
        return sql;
    }

    @Override
    @Transactional
    public void signForbiddenCreateHcxm(String hcxmlx, List<String> idList, String bz) throws Exception {
        // 检查idList是否为空，为空则退出
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }

        // 准备当前的用户信息跟时间
        UserInfo user = SessionUtil.getCurrentUser();
        String username = "";
        String userid = "";
        if (user != null) {
            username = user.getUsername();
            userid = user.getId();
        }
        Date rq = Calendar.getInstance().getTime();

        // 创建查询条件对象
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();

        // 循环idList获取SSjSignhcxm
        for (String id : idList) {
            // 构建查询条件
            queryConditionList.clear();
            queryConditionList.add(new QueryCondition("zt", QueryCondition.EQ, "0"));
            queryConditionList.add(new QueryCondition("xmlx", QueryCondition.EQ, hcxmlx));
            queryConditionList.add(new QueryCondition("rwId", QueryCondition.EQ, id));

            List<SSjSignhcxm> sSjSignhcxmList = baseRepository.list(SSjSignhcxm.class, queryConditionList);
            if (CollectionUtils.isEmpty(sSjSignhcxmList)) { // 记录不存在，需要增加记录
                SSjSignhcxm sSjSignhcxm = new SSjSignhcxm();
                sSjSignhcxm.setSignId(UUIDGenerator.generate());
                sSjSignhcxm.setRwId(id);
                sSjSignhcxm.setXmlx(hcxmlx);

                sSjSignhcxm.setZt("1");
                sSjSignhcxm.setUsername(username);
                sSjSignhcxm.setUserid(userid);
                sSjSignhcxm.setRq(rq);
                sSjSignhcxm.setBz(bz);

                baseRepository.save(sSjSignhcxm);
            } else { // 记录已存在，直接修改第一个
                SSjSignhcxm sSjSignhcxm = sSjSignhcxmList.get(0);

                sSjSignhcxm.setZt("1");
                sSjSignhcxm.setUsername(username);
                sSjSignhcxm.setUserid(userid);
                sSjSignhcxm.setRq(rq);
                sSjSignhcxm.setBz(bz);

                baseRepository.update(sSjSignhcxm);
            }
        }
    }

    @Override
    @Transactional
    public void signNeedCreateHcxm(String hcxmlx, List<String> idList) throws Exception {
        // 检查idList是否为空，为空则退出
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }

        // 准备当前的用户信息跟时间
        UserInfo user = SessionUtil.getCurrentUser();
        String username = "";
        String userid = "";
        if (user != null) {
            username = user.getUsername();
            userid = user.getId();
        }
        Date rq = Calendar.getInstance().getTime();

        // 创建查询条件对象
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();

        // 循环idList获取SSjSignhcxm
        for (String id : idList) {
            // 构建查询条件
            queryConditionList.clear();
            queryConditionList.add(new QueryCondition("zt", QueryCondition.EQ, "1"));
            queryConditionList.add(new QueryCondition("xmlx", QueryCondition.EQ, hcxmlx));
            queryConditionList.add(new QueryCondition("rwId", QueryCondition.EQ, id));

            List<SSjSignhcxm> sSjSignhcxmList = baseRepository.list(SSjSignhcxm.class, queryConditionList);
            if (CollectionUtils.isNotEmpty(sSjSignhcxmList)) { // 记录存在，才需要将zt有1改为0
                SSjSignhcxm sSjSignhcxm = sSjSignhcxmList.get(0);

                sSjSignhcxm.setZt("0");
                sSjSignhcxm.setUsername(username);
                sSjSignhcxm.setUserid(userid);
                sSjSignhcxm.setRq(rq);

                baseRepository.update(sSjSignhcxm);
            }
        }
    }

    // 根据任务类型，获取查询信息的sql语句
    private String getSqlByHcxmlx(String hcxmlx) {
        String sql = "";

        if (hcxmlx.equals(Hcxmlx.ZDHC.toString())) {
            sql = "SELECT t.*, t.DJH AS BD_ID FROM ZD t";
        } else {
            sql = "SELECT t.*, NULL AS BD_ID FROM DUAL t";
        }

        return sql;
    }
}
