package cn.gtmap.landtax.service.impl;

import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.dictionary.Dwjb;
import cn.gtmap.landtax.service.DwxxService;
import cn.gtmap.landtax.support.jpa.BaseRepository;
import cn.gtmap.landtax.util.QueryCondition;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/22
 */
@Service
public class DwxxServiceImpl implements DwxxService {
    @Autowired
    BaseRepository baseRepository;

    @Override
    @Transactional(readOnly = true)
    public List<SDmDwxxCz> getAllDwxx() {
        SDmDwxxCz sDmDwxxCz = new SDmDwxxCz();
        return baseRepository.list(SDmDwxxCz.class, null);
    }

    @Override
    public SDmDwxxCz getDwxxByDwdm(String dwdm) {
        return baseRepository.get(SDmDwxxCz.class, dwdm);
    }

    @Override
    public SDmDwxxCz getCityByDwdm(String dwdm) {
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("dwdm",  QueryCondition.EQ, dwdm));
        queryConditionList.add(new QueryCondition("dwjb",  QueryCondition.EQ, Dwjb.DS.toString()));
        List list = baseRepository.list(SDmDwxxCz.class, queryConditionList);
        if(CollectionUtils.isNotEmpty(list)){
            return (SDmDwxxCz)list.get(0);
        }
        return null;

    }

    @Override
    public List<SDmDwxxCz> getCountiesByDwdm(String dwdm) {
        SDmDwxxCz sDmDwxxCz = new SDmDwxxCz();
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("dwdm",  QueryCondition.LK, dwdm));
        queryConditionList.add(new QueryCondition("dwjb",  QueryCondition.EQ, Dwjb.QX.toString()));
        return baseRepository.list(SDmDwxxCz.class, queryConditionList);
    }

    @Override
    public List<SDmDwxxCz> getAllQxList() {
        List<SDmDwxxCz> allDwxxList =  getAllDwxx();
        List<SDmDwxxCz> qxDwxxList = new ArrayList<SDmDwxxCz>();
        for(SDmDwxxCz tempVo : allDwxxList){
            if(tempVo.getDwdm().length()==6){
                qxDwxxList.add(tempVo);
            }
        }
        return qxDwxxList;
    }

    @Override
    public List<SDmDwxxCz> getJdByQx(String qx) {
        SDmDwxxCz sDmDwxxCz = new SDmDwxxCz();
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("dwdm",  QueryCondition.LK, qx));
        queryConditionList.add(new QueryCondition("dwjb",  QueryCondition.EQ, Dwjb.XZJD.toString()));
        return baseRepository.list(SDmDwxxCz.class, queryConditionList);
    }

    @Override
    public List<SDmDwxxCz> getJfByJd(String jd) {
        SDmDwxxCz sDmDwxxCz = new SDmDwxxCz();
        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("dwdm",  QueryCondition.LK, jd));
        queryConditionList.add(new QueryCondition("dwjb",  QueryCondition.EQ, Dwjb.CJF.toString()));
        return baseRepository.list(SDmDwxxCz.class, queryConditionList);
    }

    @Override
    @Transactional(readOnly = true)
    public Page<SwDjSy> getSwdjSy(Pageable pageable) {
        SwDjSy swDjSy = new SwDjSy();

        if (pageable == null)
            pageable = new PageRequest(1, 4);

        List<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        queryConditionList.add(new QueryCondition("swDjJbb.nsrmc",  QueryCondition.EQ, "常熟市江贸物资有限责任公司"));

        return baseRepository.find(SwDjSy.class, queryConditionList, null, pageable);
    }


}
