package cn.gtmap.landtax.service;

import cn.gtmap.landtax.entity.SSjZdbg;
import cn.gtmap.landtax.entity.SSjZdbgAnaly;
import cn.gtmap.landtax.entity.SSjZdbgDobg;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

public interface ZdbgService {
    // 获取某一个时间段的变更记录
    public List<SSjZdbg> findZdBgList(Date startDate, Date endDate);

    // 获取某一个时间段的有变更的宗地变更信息
    public List<HashMap> findZdBgChangeMap(Date startDate, Date endDate);

    // 变更宗地信息
    public void bgZd(String bgAnalyProid);

    // 分析宗地变更历史数据，存储分析结果数据
    public String analyZdBgData(Date startDate, Date endDate);

    // 获取某一个时间段的宗地变更分析信息
    public List<SSjZdbgAnaly> findZdbgAnaly(Date startDate, Date endDate);

    // 根据时间段获取变更操作记录
    public SSjZdbgDobg findZdbgDobg(Date startDate, Date endDate);

    // 更新税务数据与宗地数据的挂接关系
    public void refreshZdSwRelation(String dobgid);
}
