package cn.gtmap.landtax.service;


import cn.gtmap.landtax.entity.*;
import cn.gtmap.landtax.model.query.SwDjSyQuery;
import cn.gtmap.landtax.util.QueryCondition;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

public interface TaxService {

    public Page<SwDjSy> findSwdjTdMap(SwDjSyQuery swDjSyQuery, Pageable pageable);

    public Page<SwDjSy> findSwdjFcMap(SwDjSyQuery swDjSyQuery, Pageable pageable);

    public SwDjJbb findSwDjJbbByGlbm(String glbm);

    public SwDjJbbTemp findSwDjJbbTempByGlbm(String glbm);

    public SwDjJbb findSwDjJbbById(String jbbId);

    // 更新税源数据
    public void updateSwDjSy(SwDjSy swDjSy);

    // 删除税源数据
    public void deleteSwDjSy(String syId);

    // 更新临时税源数据
    public void updateSwDjSyTemp(SwDjSyTemp swDjSyTemp);

    // 删除临时税源数据
    public void deleteSwDjSyTemp(String tempId) throws Exception;

    // 添加税源数据的更新信息
    public void addSwDjSyUpdateInfo(SwDjSy swDjSy, String czlx);

    // 添加临时税源数据的更新信息
    public void addSwDjSyTempUpdateInfo(SwDjSyTemp swDjSyTemp, String czlx);

    // 复制SwDjSY到SwDjSyHis
    public SwDjSyHis copySyToHis(SwDjSy swDjSy);

    // 复制税源到SwDjSyTemp
    public SwDjSyTemp copySyToTemp(SwDjSy swDjSy);

    // 复制SwDjSyTemp到税源
    public SwDjSy copyTempToSy(SwDjSyTemp swDjSyTemp);

    // 获取税源列表
    public List<SwDjSy> findSyList(List<QueryCondition> queryConditionList);

    // 获取临时税源列表
    public List<SwDjSyTemp> findSyTempList(List<QueryCondition> queryConditionList);

    // 更新税源数据的宗地信息
    public void updateSyZdInfo(String syId, String djhNew);
}
