package cn.gtmap.landtax.service;/**
 * Created by janeshen on 2014/8/19.
 */

import cn.gtmap.landtax.entity.SwHcXmRwRel;
import cn.gtmap.landtax.util.QueryCondition;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.HashMap;
import java.util.List;


/**
 * .
 * <p/>
 * 核查项目服务
 * @author zhouzhiwei
 * @version V1.0, 2015/9/2
 */
public interface HcxmService {
    public Page HcxmPage(List<QueryCondition> queryConditionList, String hcxmlx, Pageable pageable);

    // 根据任务ID获取核查項目列表
    public List<SwHcXmRwRel> getHcXmRwRel(List<QueryCondition> queryConditionList);

    public SwHcXmRwRel getCurSwHcXmRwRelByProid(String proid);

    public SwHcXmRwRel getCurSwHcXmRwRelByRwid(String wiid);

    // 获取核查进度
    public Object hcjdRootJson(String hcxmlx,String id);

    /**
     * 获得已处理未处理列表数据
     * @param pageable
     * @param hcxmlx 核查类型
     * @param xzqdm 单位代码
     * @param xflx 下发类型，分已下发、未下发
     * @param cllx 处理类型，分已处理、未处理
     * @param queryConditionList 查询条件
     * @return
     */
    public Object getWclYclTzJson(Pageable pageable, String hcxmlx, String xzqdm, String xflx, String cllx, List<QueryCondition> queryConditionList);

    /**
     * 获得已处理未处理列表数据
     * @param hcxmlx 核查类型
     * @param xzqdm 单位代码
     * @param xflx 下发类型，分已下发、未下发
     * @param cllx 处理类型，分已处理、未处理
     * @param queryConditionList 查询条件
     * @return
     */
    public List<HashMap> getWclYclTzList(String hcxmlx, String xzqdm, String xflx, String cllx, List<QueryCondition> queryConditionList);
    /**
     * 将核查项目中指定id的记录标记为不需要创建核查任务
     * @param hcxmlx 核查项目类型
     * @param idList 标记的id数字
     * @param bz 备注原因
     * @throws Exception
     */
    public void signForbiddenCreateHcxm(String hcxmlx, List<String> idList, String bz) throws Exception;

    /**
     * 将核查项目中被标记为不需要创建核查任务中的指定id的记录重新标记为需要创建核查任务
     * @param hcxmlx 核查项目类型
     * @param idList 标记的id数字
     * @throws Exception
     */
    public void signNeedCreateHcxm(String hcxmlx, List<String> idList) throws Exception;
}
