package cn.gtmap.landtax.service;

import cn.gtmap.landtax.entity.SDmDwxxCz;
import cn.gtmap.landtax.entity.SwDjSy;
import cn.gtmap.landtax.model.dictionary.Dwjb;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 城镇行政区单位信息
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/22
 */
public interface DwxxService {
    public List<SDmDwxxCz> getAllDwxx();

    public SDmDwxxCz getDwxxByDwdm(String dwdm);

    public SDmDwxxCz getCityByDwdm(String dwdm);

    public List<SDmDwxxCz> getCountiesByDwdm(String dwdm);

    //获取所有区县
    public List<SDmDwxxCz> getAllQxList();

    //获取所有街道根据区县代码
    public List<SDmDwxxCz> getJdByQx(String qx);

    //获取所有街坊根据街道代码
    public List<SDmDwxxCz> getJfByJd(String jd);

    public Page<SwDjSy> getSwdjSy(Pageable pageable);

}
