package cn.gtmap.landtax.print.sign;

import java.sql.*;
import java.util.*;

import com.gtis.plat.service.*;
import com.gtis.plat.vo.*;
import com.gtis.spring.*;

/**
 * 获取签名图片信息
 * 
 * @author Administrator
 * 
 */
public class GetSignInfo {
	/**
	 * 
	 * @param conn
	 *            数据库连接
	 * @param proid
	 *            签名表中关联业务表id
	 * @return
	 */
	public List<SignVo> getSign(String proid) {
		return getSign(null,proid);
	}
	public List<SignVo> getSign(String proid,String signKey) {
		List<SignVo> retList = new LinkedList<SignVo>();
		SysSignService sysSignService = (SysSignService)Container.getBean("SysSignService");
		List<PfSignVo> signList = sysSignService.getSignList(signKey, proid);
		if (signList != null) {
			for (int i = 0; i < signList.size(); i++) {
				PfSignVo sign = signList.get(i);
				SignVo vo = new SignVo();
				vo.setSignId(sign.getSignId());
				vo.setSignName(sign.getSignName());
				vo.setSignKey(sign.getSignKey());
				vo.setSignDate(sign.getSignDate());
//				vo.setSignPic(sign.getSignImage());
				vo.setSignOpinion(sign.getSignOpinion());
				retList.add(vo);
			}
		}
		return retList;
	}
}
