package cn.gtmap.landtax.print;

import cn.gtmap.landtax.util.ObjectValueManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import jxl.*;
import jxl.biff.CellFinder;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.*;
import jxl.format.VerticalAlignment;
import jxl.write.*;
import jxl.write.Number;
import jxl.write.biff.CellValue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.Serializable;
import java.lang.Boolean;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by zhouzhiwei on 2015-04-01.
 * 导出Excel的类
 */
public class ExportFormExcelUtil implements Serializable {
    private static final String xslPath = "\\static\\excel\\temp\\";

    @SuppressWarnings( { "deprecation", "unchecked" })
    public static void exportFormExcel(HttpServletRequest request, Object obj, String xls) throws Exception {
        String XlsName = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".xls";
        String filePath = request.getSession().getServletContext().getRealPath("/") + xslPath + "\\" + XlsName;

        int sheetIndex = 0;
        Workbook rw = Workbook.getWorkbook(new File(request.getRealPath("/" + "static\\excel\\template"), xls));
        WritableWorkbook wwb = Workbook.createWorkbook(new File(filePath), rw);
        WritableSheet ws = wwb.getSheet(sheetIndex);

        try {
            ObjectValueManager objectValueManager = new ObjectValueManager(obj);

            Label label = null;
            WritableCell cell = null;
            CellFormat cellFormat = null;
            String field = null;
            String value = null;
            int iRow = 0;
            int iCol = 0;

            // 遍历对象的属性方法，填充excel
            if (objectValueManager.getMethodHashMap() != null) {
                Iterator iter = ((Map)objectValueManager.getMethodHashMap()).entrySet().iterator();

                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry) iter.next();
                    field = entry.getKey().toString();
                    value = objectValueManager.getObjectValue(field);

                    if (wwb.findCellByName(field) != null) {
                        cell = wwb.findCellByName(field);

                        iRow = cell.getRow();
                        iCol = cell.getColumn();
                        cellFormat = cell.getCellFormat();
                        value = objectValueManager.getObjectValue(field);
                        if (value == null)
                            value = "";
                        label = new Label(iCol, iRow, value, cellFormat);

                        if (cell.getWritableCellFeatures() != null) {
                            String dataValidationList = cell.getWritableCellFeatures().getDataValidationList();
                            WritableCellFeatures wcf = new WritableCellFeatures();
                            if (StringUtils.isNotEmpty(dataValidationList)) {
                                int startCol = transColumnIndex(dataValidationList.split(":")[0]);
                                int startRow = transRowIndex(dataValidationList.split(":")[0]);
                                int endCol = transColumnIndex(dataValidationList.split(":")[1]);
                                int endRow = transRowIndex(dataValidationList.split(":")[1]);

                                List list = new ArrayList();
                                for (int col = startCol; col <= endCol; col++) {
                                    for (int row = startRow; row <= endRow; row++) {
                                        if (ws.getCell(col, row) != null) {
                                            list.add(ws.getCell(col, row).getContents());
                                        }
                                    }
                                }
                                wcf.setDataValidationList(list);
                            }
                            label.setCellFeatures(wcf);
                        }
                        ws.addCell(label);
                    }
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        wwb.write();
        wwb.close();

        request.setAttribute("FileDownLoadURL", request.getContextPath()+"/" + (xslPath.replaceAll("\\\\", "/")) + "" + XlsName);
    }

    private static int transColumnIndex(String cellSign) {
        int index = 0;
        if (StringUtils.isEmpty(cellSign)) {
            return index;
        }
        char[] chars = cellSign.toCharArray();

        int pos = -1;
        for (int i = chars.length - 1; i >= 0; i--) {
            if (chars[i] >= 'A'&& chars[i] <= 'Z') {
                pos++;

                index += (chars[i] - 'A') * Math.pow(26, pos);
            }
        }

        return index;
    }

    private static int transRowIndex(String cellSign) {
        int index = 0;
        if (StringUtils.isEmpty(cellSign)) {
            return index;
        }
        char[] chars = cellSign.toCharArray();

        int pos = -1;
        for (int i = chars.length - 1; i >= 0; i--) {
            if (chars[i] >= '0'&& chars[i] <= '9') {
                pos++;

                index += (chars[i] - '0') * Math.pow(10, pos);
            }
        }
        index--;
        return index;
    }
}
