package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/7
 */
public enum Zclx {
    K("",""),
    GYQY("110", "国有企业"),
    JTQY("120","集体企业"),
    GFHZQY("130","股份合作企业"),
    LYQY("140","联营企业"),
    YXZRGS("150","有限责任公司"),
    GFYXGS("160","股份有限公司"),
    SYQY("170","私营企业"),
    QTQY("190","其他企业"),
    YGATSHZI("210","与港澳台商合资经营企业"),
    YGATSHZUO("220","与港澳台商合作经营企业"),
    GATSDZJYQY("230","港澳台商独资经营企业"),
    GATSGFGS("240","港澳台商投资股份有限公司"),
    GATZWGQY("250","港澳台资外国企业"),
    ZWHZJYQY("310","中外合资经营企业"),
    HZJYQY("320","中外合作经营企业"),
    WZQY("330","外资企业"),
    WSTZGS("340","外商投资股份有限公司"),
    WGQY("350","外国企业"),
    HTGSH("410","个体工商户"),
    GRHH("420","个人合伙"),
    GR("430","个人"),
    SYDW("510","事业单位"),
    MBFSYDW("521","民办非企业单位"),
    ZDJG("540","政党机关"),
    SHTT("550","社会团体"),
    JCMZ("560","基层群众自治组织");




















    private String dm;
    private String mc;

    private Zclx(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Zclx[] Zclxs = Zclx.values();
            for(int i=0;i<Zclxs.length;i++){
                if(Zclxs[i].getDm().equals(StringUtils.trim(dm))){
                    return Zclxs[i].getMc();
                }
            }
        }
        return null;
    }
}
