package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/26
 */
public enum Tdjb {
    DJ2("1", "县级市城区（3元）"),
    DJ3("2", "建制镇（2元）");

    private String dm;
    private String mc;

    private Tdjb(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Tdjb[] Tdjbs = Tdjb.values();
            for(int i=0;i<Tdjbs.length;i++){
                if(Tdjbs[i].getDm().equals(StringUtils.trim(dm))){
                    return Tdjbs[i].getMc();
                }
            }
        }
        return null;
    }


}
