package cn.gtmap.landtax.model.dictionary;/**
 * Created by janeshen on 2014/8/19.
 */

import org.apache.commons.lang.StringUtils;

/**
 * .
 * <p/>
 *
 * @author shenjian
 * @version V1.0, 2014/8/19
 */

public enum Hcxmlx {
    ZDHC("1", "国土宗地核查"),
    SYHC("2", "税源核查"),
    FCSYHC("3", "房产税源信息核查"),
    MJBYZHC("4", "面积不一致核查"),
    SBBYZHC("5","申报不一致核查"),
    ZDGXHC("6","宗地更新核查");
    private String dm;
    private String mc;

    private Hcxmlx(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getDm() {
        return dm;
    }

    public String getMc() {
        return mc;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Hcxmlx[] hcxmlxes = Hcxmlx.values();
            for(int i=0;i<hcxmlxes.length;i++){
                if(hcxmlxes[i].getDm().equals(StringUtils.trim(dm))){
                    return hcxmlxes[i].getMc();
                }
            }
        }
        return null;
    }
}
