package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/26
 */
public enum Fwxz {
    ZZ("10", "住宅"),
    GYJTCC("20", "工业交通仓储"),
    SYJRXX("30", "商业金融信息"),
    JYYLWSKY("40", "教育、医疗、卫生、科研"),
    WHYLTY("50", "文化娱乐体育"),
    BG("60", "办公"),
    JS("70", "军事"),
    QT("80", "其他");
    private String dm;
    private String mc;

    private Fwxz(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Fwxz[] Fwxzs = Fwxz.values();
            for(int i=0;i<Fwxzs.length;i++){
                if(Fwxzs[i].getDm().equals(StringUtils.trim(dm))){
                    return Fwxzs[i].getMc();
                }
            }
        }
        return null;
    }
}
