package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/6/26
 */
public enum Fwsyzt {
    K("",""),
    ZY("01", "自用"),
    CZ("02", "出租");
    private String dm;
    private String mc;

    private Fwsyzt(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Fwsyzt[] Fwsyzts = Fwsyzt.values();
            for(int i=0;i<Fwsyzts.length;i++){
                if(Fwsyzts[i].getDm().equals(StringUtils.trim(dm))){
                    return Fwsyzts[i].getMc();
                }
            }
        }
        return null;
    }
}
