package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/8/11
 */
public enum Dldm {
    ST("011", "水田"),
    SJD("012", "水浇地"),
    HD("013", "旱地"),
    GY("021", "果园"),
    CY("022", "茶园"),
    QTYD("023", "其他园地"),
    YLD("031", "有林地"),
    GMLD("032", "灌木林地"),
    QTLD("033", "其他林地"),
    TRMCD("041", "天然牧草地"),
    RGMCD("042", "人工牧草地"),
    QTCD("043", "其他草地"),
    PFLSYF("051", "批发零售用地"),
    ZSCYYD("052", "住宿餐饮用地"),
    SWJRYD("053", "商务金融用地"),
    QTSFYD("054", "其他商服用地"),
    GYYD("061", "工业用地"),
    CKYD("062", "采矿用地"),
    CCYD("063", "仓储用地"),
    CZZZYD("071", "城镇住宅用地"),
    NCZJD("072", "农村宅基地"),
    JGTTYD("081", "机关团体用地"),
    XWCBYD("082", "新闻出版用地"),
    KJYD("083", "科教用地"),
    YWCSYD("084", "医卫慈善用地"),
    WTYLYD("085", "文体娱乐用地"),
    GGSSYD("086", "公共设施用地"),
    GYYLD("087", "公园与绿地"),
    FJMSSSYD("088", "风景名胜设施用地"),
    JSSSYF("091", "军事设施用地"),
    SLGYD("092", "使领馆用地"),
    JJCSYD("093", "监教场所用地"),
    ZJYD("094", "宗教用地"),
    BZYD("095", "殡葬用地"),
    TLYD("101", "铁路用地"),
    GLYD("102", "公路用地"),
    JXYD("103", "街巷用地"),
    NCDL("104", "农村道路"),
    JCYD("105", "机场用地"),
    GKMTYD("106", "港口码头用地"),
    GDYSYD("107", "管道运输用地"),
    HLSM("111", "河流水面"),
    HPSM("112", "湖泊水面"),
    SKSM("113", "水库水面"),
    KTSM("114", "坑塘水面"),
    YHTT("115", "沿海滩涂"),
    NLTT("116", "内陆滩涂"),
    GQ("117", "沟渠"),
    SGJZYD("118", "水工建筑用地"),
    BCJYJJX("119", "冰川及永久积雪"),
    KQD("121", "空闲地"),
    SSNYD("122", "设施农用地"),
    TK("123", "田坎"),
    YJD("124", "盐碱地"),
    ZZD("125", "沼泽地"),
    SD("126", "沙地"),
    LD("127", "裸地"),
    CS("201", "城市"),
    JZZ("202", "建制镇"),
    CZ("203", "村庄"),
    CKYD204("204", "采矿用地"),
    FJMSJTSYD("205", "风景名胜及特殊用地");
    private String dm;
    private String mc;

    private Dldm(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    @Override
    public String toString() {
        return dm;
    }
    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Dldm[] Dldms = Dldm.values();
            for(int i=0;i<Dldms.length;i++){
                if(Dldms[i].getDm().equals(StringUtils.trim(dm))){
                    return Dldms[i].getMc();
                }
            }
        }
        return null;
    }
}
