package cn.gtmap.landtax.model.dictionary;

import org.apache.commons.lang.StringUtils;

/**
 * 数据操作类型
 * @author <a href="mailto:zhouzhiwei@gtmap.cn">zhouzhiwei</a>
 * @version 1.0, 2015/9/28
 */
public enum Bgfs {
    ZDMS("1", "宗地灭失"),
    ZDXZ("2", "宗地新增"),
    ZDHB("3", "宗地合并"),
    ZDFG("4", "宗地分割"),
    SXBG("5", "属性变更"),
    JZXTZ("6", "界址线调整"),
    ZDZHBG("7", "宗地综合变更"),
    QHTZ("8", "区划调整"),
    BGCX("9", "变更撤销");

    private String dm;
    private String mc;

    private Bgfs(String dm, String mc) {
        this.dm = dm;
        this.mc = mc;
    }

    @Override
    public String toString() {
        return dm;
    }

    public String getMc(){
        return this.mc;
    }

    public String getDm(){
        return this.dm;
    }

    public static String getMcByDm(String dm){
        if(StringUtils.isNotBlank(dm)){
            Bgfs[] bgfses = Bgfs.values();
            for(int i = 0; i < bgfses.length; i++){
                if(bgfses[i].getDm().equals(StringUtils.trim(dm))){
                    return bgfses[i].getMc();
                }
            }
        }
        return null;
    }

    public static String getDmByMc(String mc){
        if(StringUtils.isNotBlank(mc)){
            Bgfs[] bgfses = Bgfs.values();
            for(int i = 0; i < bgfses.length; i++){
                if(bgfses[i].getMc().equals(StringUtils.trim(mc))){
                    return bgfses[i].getDm();
                }
            }
        }
        return null;
    }
}
