package cn.gtmap.landtax.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 宗地临时表
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2014/7/6
 */
@Entity
@Table(name = "ZD_TEMP")
public class ZdTemp {
    @Id
    @Column
    private String id;

    @Column
    private Date zdxgrq; // 宗地修改日期

    @Column
    private String username; // 修改人员名称

    @Column
    private String userid; // 修改人员id

    @Column
    private String djh; // 地籍号

    @Column
    private String qlrmc; // 权利人名称

    @Column
    private String tdzl; // 土地坐落

    @Column
    private String tdytmc; // 土地用途名称

    @Column
    private String tdyt; // 土地用途(代码)

    private BigDecimal scmj; // 实测面积

    @Column
    private String tdzh; // 土地证号

    @Column
    private String xzqdm; // 行政区代码

    @Column
    private String fddbr; // 法定代表人

    @Column
    private String fddbrzjhm; // 法定代表人证件号码

    @Column
    private String sjzt; // 宗地数据状态

    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }

    public String getTdzl() {
        return tdzl;
    }

    public void setTdzl(String tdzl) {
        this.tdzl = tdzl;
    }

    public String getTdytmc() {
        return tdytmc;
    }

    public void setTdytmc(String tdytmc) {
        this.tdytmc = tdytmc;
    }

    public String getTdyt() {
        return tdyt;
    }

    public void setTdyt(String tdyt) {
        this.tdyt = tdyt;
    }

    public BigDecimal getScmj() {
        return scmj;
    }

    public void setScmj(BigDecimal scmj) {
        this.scmj = scmj;
    }

    public String getTdzh() {
        return tdzh;
    }

    public void setTdzh(String tdzh) {
        this.tdzh = tdzh;
    }

    public String getXzqdm() {
        return xzqdm;
    }

    public void setXzqdm(String xzqdm) {
        this.xzqdm = xzqdm;
    }

    public String getFddbr() {
        return fddbr;
    }

    public void setFddbr(String fddbr) {
        this.fddbr = fddbr;
    }

    public String getFddbrzjhm() {
        return fddbrzjhm;
    }

    public void setFddbrzjhm(String fddbrzjhm) {
        this.fddbrzjhm = fddbrzjhm;
    }

    public String getSjzt() {
        return sjzt;
    }

    public void setSjzt(String sjzt) {
        this.sjzt = sjzt;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getZdxgrq() {
        return zdxgrq;
    }

    public void setZdxgrq(Date zdxgrq) {
        this.zdxgrq = zdxgrq;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }
}
