package cn.gtmap.landtax.entity;

import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 宗地
 * @author <a href="mailto:zhouzhiwei@gtmap.cn">zhouzhiwei</a>
 * @version 1.0, 2014/7/6
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "ZD_HISTORY")
public class ZdHistory extends ZdBase implements Serializable {
    @Id
    @Column
    private String hisId; // 主键ID

    @Column
    private String djh; // 地籍号

    @Column
    private String djhNew; // 新地籍号

    @Column
    private Date gxrq; // 更新日期

    @Column
    private String userid; // 更新人ID

    @Column
    private String username; // 更新人名称

    public String getHisId() {
        return hisId;
    }

    public void setHisId(String hisId) {
        this.hisId = hisId;
    }

    public String getDjh() {
        return djh;
    }

    public void setDjh(String djh) {
        this.djh = djh;
    }

    public String getDjhNew() {
        return djhNew;
    }

    public void setDjhNew(String djhNew) {
        this.djhNew = djhNew;
    }

    public Date getGxrq() {
        return gxrq;
    }

    public void setGxrq(Date gxrq) {
        this.gxrq = gxrq;
    }

    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}
