package cn.gtmap.landtax.entity;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 宗地基本表
 *
 * @author <a href="mailto:zhouzhiwei@gtmap.cn">zhouzhiwei</a>
 * @version 1.0, 2015/9/28
 */
@MappedSuperclass
public abstract class ZdBase {
    @Column
    private String qlrmc; // 权利人名称

    @Column
    private String tdzl; // 土地坐落

    @Column
    private String tdytmc; // 土地用途名称

    @Column
    private String tdyt; // 土地用途(代码)

    @Column
    private BigDecimal scmj; // 实测面积

    @Column
    private String tdzh; // 土地证号

    @Column
    private String xzqdm; // 行政区代码

    @Column
    private String tddj; // 土地等级

    @Column
    private String sgqdm; // 税管区代码

    @Column
    private String zdlx; // 宗地类型： 1、宗地；2、虚拟宗地

    @Column
    private BigDecimal syqmj; // 使用权面积，值是登记发证的面积

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }

    public String getTdzl() {
        return tdzl;
    }

    public void setTdzl(String tdzl) {
        this.tdzl = tdzl;
    }

    public String getTdytmc() {
        return tdytmc;
    }

    public void setTdytmc(String tdytmc) {
        this.tdytmc = tdytmc;
    }

    public String getTdyt() {
        return tdyt;
    }

    public void setTdyt(String tdyt) {
        this.tdyt = tdyt;
    }

    public BigDecimal getScmj() {
        return scmj;
    }

    public void setScmj(BigDecimal scmj) {
        this.scmj = scmj;
    }

    public String getTdzh() {
        return tdzh;
    }

    public void setTdzh(String tdzh) {
        this.tdzh = tdzh;
    }

    public String getXzqdm() {
        return xzqdm;
    }

    public void setXzqdm(String xzqdm) {
        this.xzqdm = xzqdm;
    }

    public String getTddj() {
        return tddj;
    }

    public void setTddj(String tddj) {
        this.tddj = tddj;
    }

    public String getSgqdm() {
        return sgqdm;
    }

    public void setSgqdm(String sgqdm) {
        this.sgqdm = sgqdm;
    }

    public String getZdlx() {
        return zdlx;
    }

    public void setZdlx(String zdlx) {
        this.zdlx = zdlx;
    }

    public BigDecimal getSyqmj() {
        return syqmj;
    }

    public void setSyqmj(BigDecimal syqmj) {
        this.syqmj = syqmj;
    }
}
