package cn.gtmap.landtax.entity;

import cn.gtmap.landtax.model.dictionary.*;
import cn.gtmap.landtax.service.DicService;
import cn.gtmap.landtax.service.DwxxService;
import org.springframework.beans.factory.annotation.Autowired;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 税务土地登记表
 *
 * @author <a href="mailto:zhouzhiwei@gtmap.cn">zhouzhiwei</a>
 * @version 1.0, 2015/8/26
 */
@MappedSuperclass
public abstract class SwDjTdBase {
    @Column
    private String tdsyqlx;

    @Column
    private Date tdMssjBegin;

    @Column
    private Date tdMssjEnd;

    @Column
    private String tdMsyy;

    @Column
    private String tdqdfsDm;

    @Column
    private String tdsyytDm;

    @Column
    private BigDecimal dj;

    @Column
    private BigDecimal qdsyqzfje;

    @Column
    private BigDecimal tdkfcb;

    @Column
    private Date csqdsj;

    @Column
    private Date syqzzsj;

    @Column
    private String tdjmxzdm;

    @Column
    private String tdzl;

    @Column
    private BigDecimal zdmj;

    @Column
    private BigDecimal ynmj;

    @Column
    private BigDecimal dwse;

    @Column
    private BigDecimal nynse;

    @Column
    private String tddj;

    @Column
    private String tdsyzh;

    @Column
    private String bz;

    @Column
    private String czrmc;

    @Column
    private String czrzjhm;

    @Column
    private BigDecimal msmj;

    @Column
    private BigDecimal msse;

    @Column
    private BigDecimal dwseMs;

    @Column
    private BigDecimal fzmj;

    @Column
    private BigDecimal scmj;

    @Column
    private String tdsyztDm;

    @Column
    private String tdsyztMc;

    @Column
    private String gtzdbyzyy;

    @Column
    private String zdsybz;

    @Column
    private String msbz;

    private transient String tddjMc;

    private transient String tdqdfsMc;

    private transient String tdsyytMc;

    private transient String tdjmxzMc;

    public String getTdsyqlx() {
        return tdsyqlx;
    }

    public void setTdsyqlx(String tdsyqlx) {
        this.tdsyqlx = tdsyqlx;
    }

    public Date getTdMssjBegin() {
        return tdMssjBegin;
    }

    public void setTdMssjBegin(Date tdMssjBegin) {
        this.tdMssjBegin = tdMssjBegin;
    }

    public Date getTdMssjEnd() {
        return tdMssjEnd;
    }

    public void setTdMssjEnd(Date tdMssjEnd) {
        this.tdMssjEnd = tdMssjEnd;
    }

    public String getTdMsyy() {
        return tdMsyy;
    }

    public void setTdMsyy(String tdMsyy) {
        this.tdMsyy = tdMsyy;
    }

    public String getTdqdfsDm() {
        return tdqdfsDm;
    }

    public void setTdqdfsDm(String tdqdfsDm) {
        this.tdqdfsDm = tdqdfsDm;
    }

    public String getTdsyytDm() {
        return tdsyytDm;
    }

    public void setTdsyytDm(String tdsyytDm) {
        this.tdsyytDm = tdsyytDm;
    }

    public BigDecimal getDj() {
        return dj;
    }

    public void setDj(BigDecimal dj) {
        this.dj = dj;
    }

    public BigDecimal getQdsyqzfje() {
        return qdsyqzfje;
    }

    public void setQdsyqzfje(BigDecimal qdsyqzfje) {
        this.qdsyqzfje = qdsyqzfje;
    }

    public BigDecimal getTdkfcb() {
        return tdkfcb;
    }

    public void setTdkfcb(BigDecimal tdkfcb) {
        this.tdkfcb = tdkfcb;
    }

    public Date getCsqdsj() {
        return csqdsj;
    }

    public void setCsqdsj(Date csqdsj) {
        this.csqdsj = csqdsj;
    }

    public Date getSyqzzsj() {
        return syqzzsj;
    }

    public void setSyqzzsj(Date syqzzsj) {
        this.syqzzsj = syqzzsj;
    }

    public String getTdjmxzdm() {
        return tdjmxzdm;
    }

    public void setTdjmxzdm(String tdjmxzdm) {
        this.tdjmxzdm = tdjmxzdm;
    }

    public String getTdzl() {
        return tdzl;
    }

    public void setTdzl(String tdzl) {
        this.tdzl = tdzl;
    }

    public BigDecimal getZdmj() {
        return zdmj;
    }

    public void setZdmj(BigDecimal zdmj) {
        this.zdmj = zdmj;
    }

    public BigDecimal getYnmj() {
        return ynmj;
    }

    public void setYnmj(BigDecimal ynmj) {
        this.ynmj = ynmj;
    }

    public BigDecimal getDwse() {
        return dwse;
    }

    public void setDwse(BigDecimal dwse) {
        this.dwse = dwse;
    }

    public BigDecimal getNynse() {
        return nynse;
    }

    public void setNynse(BigDecimal nynse) {
        this.nynse = nynse;
    }

    public String getTddj() {
        return tddj;
    }

    public void setTddj(String tddj) {
        this.tddj = tddj;
    }

    public String getTddjMc() {
        if (tddj == null)
            tddjMc = null;
        tddjMc = Tdjb.getMcByDm(tddj);
        return tddjMc;
    }

    public void setTddjMc(String tddjMc) {
        this.tddjMc = tddjMc;
    }

    public String getTdsyzh() {
        return tdsyzh;
    }

    public void setTdsyzh(String tdsyzh) {
        this.tdsyzh = tdsyzh;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public String getCzrmc() {
        return czrmc;
    }

    public void setCzrmc(String czrmc) {
        this.czrmc = czrmc;
    }

    public String getCzrzjhm() {
        return czrzjhm;
    }

    public void setCzrzjhm(String czrzjhm) {
        this.czrzjhm = czrzjhm;
    }

    public BigDecimal getMsmj() {
        return msmj;
    }

    public void setMsmj(BigDecimal msmj) {
        this.msmj = msmj;
    }

    public BigDecimal getMsse() {
        return msse;
    }

    public void setMsse(BigDecimal msse) {
        this.msse = msse;
    }

    public BigDecimal getDwseMs() {
        return dwseMs;
    }

    public void setDwseMs(BigDecimal dwseMs) {
        this.dwseMs = dwseMs;
    }

    public BigDecimal getFzmj() {
        return fzmj;
    }

    public void setFzmj(BigDecimal fzmj) {
        this.fzmj = fzmj;
    }

    public BigDecimal getScmj() {
        return scmj;
    }

    public void setScmj(BigDecimal scmj) {
        this.scmj = scmj;
    }

    public String getTdsyztDm() {
        return tdsyztDm;
    }

    public void setTdsyztDm(String tdsyztDm) {
        this.tdsyztDm = tdsyztDm;
    }

    public String getTdsyztMc() {
        if (tdsyztDm != null && tdsyztMc == null)
            tdsyztMc = Tdsyzt.getMcByDm(tdsyztDm);
        return tdsyztMc;
    }

    public void setTdsyztMc(String tdsyztMc) {
        this.tdsyztMc = tdsyztMc;
    }

    public String getGtzdbyzyy() {
        return gtzdbyzyy;
    }

    public void setGtzdbyzyy(String gtzdbyzyy) {
        this.gtzdbyzyy = gtzdbyzyy;
    }

    public String getZdsybz() {
        return zdsybz;
    }

    public void setZdsybz(String zdsybz) {
        this.zdsybz = zdsybz;
    }

    public String getMsbz() {
        return msbz;
    }

    public void setMsbz(String msbz) {
        this.msbz = msbz;
    }

    public String getTdqdfsMc() {
        if (tdqdfsDm == null)
            tdqdfsMc = null;
        try {
            tdqdfsMc = Tdqdfs.getMcByDm(tdqdfsDm);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return tdqdfsMc;
    }

    public void setTdqdfsMc(String tdqdfsMc) {
        this.tdqdfsMc = tdqdfsMc;
    }

    public String getTdsyytMc() {
        if (tdsyytDm == null)
            tdsyytMc = null;
        try {
            tdsyytMc = Tdyt.getMcByDm(tdsyytDm);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return tdsyytMc;
    }

    public void setTdsyytMc(String tdsyytMc) {
        this.tdsyytMc = tdsyytMc;
    }

    public String getTdjmxzMc() {
        if (tdjmxzdm == null)
            tdjmxzMc = null;
        try {
            tdjmxzMc = Jmxztd.getMcByDm(tdjmxzdm);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return tdjmxzMc;
    }

    public void setTdjmxzMc(String tdjmxzMc) {
        this.tdjmxzMc = tdjmxzMc;
    }
}
