package cn.gtmap.landtax.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 税源主表
 * @author <a href="mailto:zhouzhiwei@gtmap.cn">zhouzhiwei</a>
 * @version 1.0, 2015/8/26
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "SW_DJ_SY_TEMP")
public class SwDjSyTemp extends SwDjSyBase implements Serializable {
    @Id
    @Column
    private String tempId;

    @Column
    private String syId;

    @OneToOne(fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    @JoinColumn(name = "TEMP_ID")
    private SwDjJbbTemp swDjJbbTemp;

    @OneToOne(fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    @JoinColumn(name = "TEMP_ID")
    private SwDjTdTemp swDjTdTemp;

    @OneToOne(fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    @JoinColumn(name = "TEMP_ID")
    private SwDjFcTemp swDjFcTemp;

    @ManyToOne(fetch = FetchType.LAZY, cascade = CascadeType.REFRESH)
    @JoinColumn(name="GT_BM")
    private Zd zd;

    @JSONField(serialize = false)
    @ManyToOne(fetch = FetchType.LAZY,cascade = CascadeType.REFRESH)
    @JoinColumn(name="SHXR_ID")
    private SwHcXmRwRel swHcXmRwRel;

    public String getTempId() {
        return tempId;
    }

    public void setTempId(String tempId) {
        this.tempId = tempId;
    }

    public String getSyId() {
        return syId;
    }

    public void setSyId(String syId) {
        this.syId = syId;
    }

    public SwDjJbbTemp getSwDjJbbTemp() {
        return swDjJbbTemp;
    }

    public void setSwDjJbbTemp(SwDjJbbTemp swDjJbbTemp) {
        this.swDjJbbTemp = swDjJbbTemp;
    }

    public SwDjTdTemp getSwDjTdTemp() {
        return swDjTdTemp;
    }

    public void setSwDjTdTemp(SwDjTdTemp swDjTdTemp) {
        this.swDjTdTemp = swDjTdTemp;
    }

    public SwDjFcTemp getSwDjFcTemp() {
        return swDjFcTemp;
    }

    public void setSwDjFcTemp(SwDjFcTemp swDjFcTemp) {
        this.swDjFcTemp = swDjFcTemp;
    }

    public Zd getZd() {
        return zd;
    }

    public void setZd(Zd zd) {
        this.zd = zd;
    }

    public SwHcXmRwRel getSwHcXmRwRel() {
        return swHcXmRwRel;
    }

    public void setSwHcXmRwRel(SwHcXmRwRel swHcXmRwRel) {
        this.swHcXmRwRel = swHcXmRwRel;
    }
}
