package cn.gtmap.landtax.entity;

import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 税源主表
 * @author <a href="mailto:zhouzhiwei@gtmap.cn">zhouzhiwei</a>
 * @version 1.0, 2015/8/26
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "SW_DJ_SY_HIS")
public class SwDjSyHis extends SwDjSyBase implements Serializable {
    @Id
    @Column
    private String hisId;

    @Column
    private String syId;

    @OneToOne(fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    @JoinColumn(name = "HIS_ID")
    private SwDjJbbHis swDjJbbHis;

    @OneToOne(fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    @JoinColumn(name = "HIS_ID")
    private SwDjTdHis swDjTdHis;

    @OneToOne(fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    @JoinColumn(name = "HIS_ID")
    private SwDjFcHis swDjFcHis;

    @ManyToOne(fetch = FetchType.LAZY, cascade = CascadeType.REFRESH)
    @JoinColumn(name="GT_BM")
    private Zd zd;

    public String getHisId() {
        return hisId;
    }

    public void setHisId(String hisId) {
        this.hisId = hisId;
    }

    public String getSyId() {
        return syId;
    }

    public void setSyId(String syId) {
        this.syId = syId;
    }

    public SwDjJbbHis getSwDjJbbHis() {
        return swDjJbbHis;
    }

    public void setSwDjJbbHis(SwDjJbbHis swDjJbbHis) {
        this.swDjJbbHis = swDjJbbHis;
    }

    public SwDjTdHis getSwDjTdHis() {
        return swDjTdHis;
    }

    public void setSwDjTdHis(SwDjTdHis swDjTdHis) {
        this.swDjTdHis = swDjTdHis;
    }

    public SwDjFcHis getSwDjFcHis() {
        return swDjFcHis;
    }

    public void setSwDjFcHis(SwDjFcHis swDjFcHis) {
        this.swDjFcHis = swDjFcHis;
    }

    public Zd getZd() {
        return zd;
    }

    public void setZd(Zd zd) {
        this.zd = zd;
    }
}
