package cn.gtmap.landtax.entity;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.util.Date;

/**
 * 税务基本表
 *
 * @author <a href="mailto:zhouzhiwei@gtmap.cn">zhouzhiwei</a>
 * @version 1.0, 2015/8/26
 */
@MappedSuperclass
public abstract class SwDjSyBase {
    @Column
    private String syzt; // 税源状态， 对应字典表s_zd_syzt

    @Column
    private String gtly; // 国土数据来源，对应字典表s_zd_gtlx

    @Column
    private String sjly; // 数据来源，对应字典表s_zd_sjly

    @Column
    private String bz; // 备注

    @Column
    private Date updateRq; // 修改时间

    @Column
    private String updateUsername; // 修改人名称

    @Column
    private String updateUserid; // 修改人ID

    @Column
    private String czlx; // 操作类型(对应字典表S_ZD_CZLX)

    @Column
    private String sgztDm; // 税管状态代码

    @Column
    private String sgztMc; // 税管状态名称

    public String getSyzt() {
        return syzt;
    }

    public void setSyzt(String syzt) {
        this.syzt = syzt;
    }

    public String getGtly() {
        return gtly;
    }

    public void setGtly(String gtly) {
        this.gtly = gtly;
    }

    public String getSjly() {
        return sjly;
    }

    public void setSjly(String sjly) {
        this.sjly = sjly;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public Date getUpdateRq() {
        return updateRq;
    }

    public void setUpdateRq(Date updateRq) {
        this.updateRq = updateRq;
    }

    public String getUpdateUsername() {
        return updateUsername;
    }

    public void setUpdateUsername(String updateUsername) {
        this.updateUsername = updateUsername;
    }

    public String getUpdateUserid() {
        return updateUserid;
    }

    public void setUpdateUserid(String updateUserid) {
        this.updateUserid = updateUserid;
    }

    public String getCzlx() {
        return czlx;
    }

    public void setCzlx(String czlx) {
        this.czlx = czlx;
    }

    public String getSgztDm() {
        return sgztDm;
    }

    public void setSgztDm(String sgztDm) {
        this.sgztDm = sgztDm;
    }

    public String getSgztMc() {
        return sgztMc;
    }

    public void setSgztMc(String sgztMc) {
        this.sgztMc = sgztMc;
    }
}
