package cn.gtmap.landtax.entity;

import com.alibaba.fastjson.annotation.JSONField;
import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;

/**
 * 税源主表
 * @author <a href="mailto:zhouzhiwei@gtmap.cn">zhouzhiwei</a>
 * @version 1.0, 2015/8/26
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "SW_DJ_SY")
public class SwDjSy extends SwDjSyBase implements Serializable {
    @Id
    @Column
    private String syId;

    @ManyToOne(fetch = FetchType.LAZY, cascade = CascadeType.REFRESH )
    @JoinColumn(name = "JBB_ID")
    private SwDjJbb swDjJbb;

    @OneToOne(fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    @JoinColumn(name = "syId")
    private SwDjTd swDjTd;

    @OneToOne(fetch = FetchType.LAZY, cascade = CascadeType.ALL)
    @JoinColumn(name = "syId")
    private SwDjFc swDjFc;

    @ManyToOne(fetch = FetchType.LAZY, cascade = CascadeType.REFRESH)
    @JoinColumn(name="GT_BM")
    private Zd zd;

    public String getSyId() {
        return syId;
    }

    public void setSyId(String syId) {
        this.syId = syId;
    }

    public SwDjJbb getSwDjJbb() {
        return swDjJbb;
    }

    public void setSwDjJbb(SwDjJbb swDjJbb) {
        this.swDjJbb = swDjJbb;
    }

    public SwDjTd getSwDjTd() {
        return swDjTd;
    }

    public void setSwDjTd(SwDjTd swDjTd) {
        this.swDjTd = swDjTd;
    }

    public SwDjFc getSwDjFc() {
        return swDjFc;
    }

    public void setSwDjFc(SwDjFc swDjFc) {
        this.swDjFc = swDjFc;
    }

    public Zd getZd() {
        return zd;
    }

    public void setZd(Zd zd) {
        this.zd = zd;
    }
}
