package cn.gtmap.landtax.entity;

import cn.gtmap.landtax.model.dictionary.Jmxzfc;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 税务房产登记表
 *
 * @author <a href="mailto:zhouzhiwei@gtmap.cn">zhouzhiwei</a>
 * @version 1.0, 2015/8/26
 */
@MappedSuperclass
public abstract class SwDjFcBase {
    @Column
    private Date fcMssjBegin;

    @Column
    private Date fcMssjEnd;

    @Column
    private String fcMsyy;

    @Column
    private BigDecimal fcyz;

    @Column
    private BigDecimal sl;

    @Column
    private BigDecimal nzj;

    @Column
    private BigDecimal zjSl;

    @Column
    private BigDecimal ynse;

    @Column
    private BigDecimal fcyzMs;

    @Column
    private BigDecimal nynse;

    @Column
    private String fczh;

    @Column
    private String czrmc;

    @Column
    private String czrzjhm;

    @Column
    private BigDecimal fcyzYs;

    @Column
    private String fczl;

    @Column
    private String bz;

    @Column
    private BigDecimal fwjz;

    @Column
    private BigDecimal tdjz;

    @Column
    private BigDecimal fssbjz;

    @Column
    private BigDecimal fcmj;

    @Column
    private BigDecimal ynseZy;

    @Column
    private BigDecimal ynseCz;

    @Column
    private String fwxzDm;

    @Column
    private String fwxzMc;

    @Column
    private String zyhczDm;

    @Column
    private String zyhczMc;

    @Column
    private String zdsybz;

    @Column
    private String msbz;

    @Column
    private BigDecimal qzczfcmj;

    @Column
    private BigDecimal jsbl; // 计税比例

    @Column
    private String fcjmxzdm; // 减免性质代码

    @Column
    private BigDecimal czfcyz;

    @Column
    private String fczlXian;

    @Column
    private String fczlZhen;

    @Column
    private String fczlLu;

    @Column
    private String fczlHao;

    @Column
    private String fczlDong;

    @Column
    private String fczlDy;

    @Column
    private String fczlLou;

    @Column
    private String fczlShi;

    private transient String fcjmxzMc;

    private transient String zjSlMc;

    public Date getFcMssjBegin() {
        return fcMssjBegin;
    }

    public void setFcMssjBegin(Date fcMssjBegin) {
        this.fcMssjBegin = fcMssjBegin;
    }

    public Date getFcMssjEnd() {
        return fcMssjEnd;
    }

    public void setFcMssjEnd(Date fcMssjEnd) {
        this.fcMssjEnd = fcMssjEnd;
    }

    public String getFcMsyy() {
        return fcMsyy;
    }

    public void setFcMsyy(String fcMsyy) {
        this.fcMsyy = fcMsyy;
    }

    public BigDecimal getFcyz() {
        return fcyz;
    }

    public void setFcyz(BigDecimal fcyz) {
        this.fcyz = fcyz;
    }

    public BigDecimal getSl() {
        return sl;
    }

    public void setSl(BigDecimal sl) {
        this.sl = sl;
    }

    public BigDecimal getNzj() {
        return nzj;
    }

    public void setNzj(BigDecimal nzj) {
        this.nzj = nzj;
    }

    public BigDecimal getZjSl() {
        return zjSl;
    }

    public void setZjSl(BigDecimal zjSl) {
        this.zjSl = zjSl;
    }

    public BigDecimal getYnse() {
        return ynse;
    }

    public void setYnse(BigDecimal ynse) {
        this.ynse = ynse;
    }

    public BigDecimal getFcyzMs() {
        return fcyzMs;
    }

    public void setFcyzMs(BigDecimal fcyzMs) {
        this.fcyzMs = fcyzMs;
    }

    public BigDecimal getNynse() {
        return nynse;
    }

    public void setNynse(BigDecimal nynse) {
        this.nynse = nynse;
    }

    public String getFczh() {
        return fczh;
    }

    public void setFczh(String fczh) {
        this.fczh = fczh;
    }

    public String getCzrmc() {
        return czrmc;
    }

    public void setCzrmc(String czrmc) {
        this.czrmc = czrmc;
    }

    public String getCzrzjhm() {
        return czrzjhm;
    }

    public void setCzrzjhm(String czrzjhm) {
        this.czrzjhm = czrzjhm;
    }

    public BigDecimal getFcyzYs() {
        return fcyzYs;
    }

    public void setFcyzYs(BigDecimal fcyzYs) {
        this.fcyzYs = fcyzYs;
    }

    public String getFczl() {
        return fczl;
    }

    public void setFczl(String fczl) {
        this.fczl = fczl;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }

    public BigDecimal getFwjz() {
        return fwjz;
    }

    public void setFwjz(BigDecimal fwjz) {
        this.fwjz = fwjz;
    }

    public BigDecimal getTdjz() {
        return tdjz;
    }

    public void setTdjz(BigDecimal tdjz) {
        this.tdjz = tdjz;
    }

    public BigDecimal getFssbjz() {
        return fssbjz;
    }

    public void setFssbjz(BigDecimal fssbjz) {
        this.fssbjz = fssbjz;
    }

    public BigDecimal getFcmj() {
        return fcmj;
    }

    public void setFcmj(BigDecimal fcmj) {
        this.fcmj = fcmj;
    }

    public BigDecimal getYnseZy() {
        return ynseZy;
    }

    public void setYnseZy(BigDecimal ynseZy) {
        this.ynseZy = ynseZy;
    }

    public BigDecimal getYnseCz() {
        return ynseCz;
    }

    public void setYnseCz(BigDecimal ynseCz) {
        this.ynseCz = ynseCz;
    }

    public String getFwxzDm() {
        return fwxzDm;
    }

    public void setFwxzDm(String fwxzDm) {
        this.fwxzDm = fwxzDm;
    }

    public String getFwxzMc() {
        return fwxzMc;
    }

    public void setFwxzMc(String fwxzMc) {
        this.fwxzMc = fwxzMc;
    }

    public String getZyhczDm() {
        return zyhczDm;
    }

    public void setZyhczDm(String zyhczDm) {
        this.zyhczDm = zyhczDm;
    }

    public String getZyhczMc() {
        return zyhczMc;
    }

    public void setZyhczMc(String zyhczMc) {
        this.zyhczMc = zyhczMc;
    }

    public String getZdsybz() {
        return zdsybz;
    }

    public void setZdsybz(String zdsybz) {
        this.zdsybz = zdsybz;
    }

    public String getMsbz() {
        return msbz;
    }

    public void setMsbz(String msbz) {
        this.msbz = msbz;
    }

    public BigDecimal getQzczfcmj() {
        return qzczfcmj;
    }

    public void setQzczfcmj(BigDecimal qzczfcmj) {
        this.qzczfcmj = qzczfcmj;
    }

    public BigDecimal getJsbl() {
        return jsbl;
    }

    public void setJsbl(BigDecimal jsbl) {
        this.jsbl = jsbl;
    }

    public String getFcjmxzdm() {
        return fcjmxzdm;
    }

    public void setFcjmxzdm(String fcjmxzdm) {
        this.fcjmxzdm = fcjmxzdm;
    }

    public BigDecimal getCzfcyz() {
        return czfcyz;
    }

    public void setCzfcyz(BigDecimal czfcyz) {
        this.czfcyz = czfcyz;
    }

    public String getFczlXian() {
        return fczlXian;
    }

    public void setFczlXian(String fczlXian) {
        this.fczlXian = fczlXian;
    }

    public String getFczlZhen() {
        return fczlZhen;
    }

    public void setFczlZhen(String fczlZhen) {
        this.fczlZhen = fczlZhen;
    }

    public String getFczlLu() {
        return fczlLu;
    }

    public void setFczlLu(String fczlLu) {
        this.fczlLu = fczlLu;
    }

    public String getFczlHao() {
        return fczlHao;
    }

    public void setFczlHao(String fczlHao) {
        this.fczlHao = fczlHao;
    }

    public String getFczlDong() {
        return fczlDong;
    }

    public void setFczlDong(String fczlDong) {
        this.fczlDong = fczlDong;
    }

    public String getFczlDy() {
        return fczlDy;
    }

    public void setFczlDy(String fczlDy) {
        this.fczlDy = fczlDy;
    }

    public String getFczlLou() {
        return fczlLou;
    }

    public void setFczlLou(String fczlLou) {
        this.fczlLou = fczlLou;
    }

    public String getFczlShi() {
        return fczlShi;
    }

    public void setFczlShi(String fczlShi) {
        this.fczlShi = fczlShi;
    }

    public String getFcjmxzMc() {
        if (fcjmxzdm == null)
            fcjmxzMc = null;
        try {
            fcjmxzMc = Jmxzfc.getMcByDm(fcjmxzdm);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return fcjmxzMc;
    }

    public void setFcjmxzMc(String fcjmxzMc) {
        this.fcjmxzMc = fcjmxzMc;
    }

    public String getZjSlMc() {
        if (zjSl == null) {
            zjSlMc = null;
        } else if (((Double)zjSl.doubleValue()).compareTo(0.04) == 0) {
            zjSlMc = "4%";
        } else if (((Double)zjSl.doubleValue()).compareTo(0.12) == 0) {
            zjSlMc = "12%";
        }

        return zjSlMc;
    }

    public void setZjSlMc(String zjSlMc) {
        this.zjSlMc = zjSlMc;
    }
}
