package cn.gtmap.landtax.entity;

import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 变更操作记录数据
 * @author <a href="mailto:zhouzhiwei@gtmap.cn">zhouzhiwei</a>
 * @version 1.0, 2015/9/28
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "S_SJ_ZDBG_DOBG")
public class SSjZdbgDobg implements Serializable {
    @Id
    private String proid; // 主键ID

    @Column
    private Date bgBegin; // 变更起始日期

    @Column
    private Date bgEnd; // 变更终止日期

    @Column
    private String userid; // 变更人ID

    @Column
    private String username; // 变更人名称

    @Column
    private Date czrq; // 变更执行时间

    @Column
    private String bz; // 备注

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public Date getBgBegin() {
        return bgBegin;
    }

    public void setBgBegin(Date bgBegin) {
        this.bgBegin = bgBegin;
    }

    public Date getBgEnd() {
        return bgEnd;
    }

    public void setBgEnd(Date bgEnd) {
        this.bgEnd = bgEnd;
    }

    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Date getCzrq() {
        return czrq;
    }

    public void setCzrq(Date czrq) {
        this.czrq = czrq;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }
}
