package cn.gtmap.landtax.entity;

import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 宗地变更分析数据
 * @author <a href="mailto:zhouzhiwei@gtmap.cn">zhouzhiwei</a>
 * @version 1.0, 2015/9/28
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "S_SJ_ZDBG_ANALY")
public class SSjZdbgAnaly implements Serializable {
    @Id
    private String proid; // 主键ID

    @ManyToOne(fetch = FetchType.LAZY, cascade = CascadeType.REFRESH)
    @JoinColumn(name="DOBGID")
    private SSjZdbgDobg sSjZdbgDobg;

    @Column
    private String groupid; // 分组ID（所有具有相关性的变更放到一个分组）

    @Column
    private String djhBefore; // 变更前地籍号，记录该次变更记录，由之前哪个地变更而来

    @ManyToOne(fetch = FetchType.LAZY, cascade = CascadeType.REFRESH)
    @JoinColumn(name="BGPROID")
    private SSjZdbg sSjZdbg;

    @Column
    private String bglx; // 变更类型：新增、灭失、应税免税状态的转便说明

    @Column
    private String clzt; // 处理状态：0未处理，1已处理

    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public SSjZdbgDobg getsSjZdbgDobg() {
        return sSjZdbgDobg;
    }

    public void setsSjZdbgDobg(SSjZdbgDobg sSjZdbgDobg) {
        this.sSjZdbgDobg = sSjZdbgDobg;
    }

    public String getGroupid() {
        return groupid;
    }

    public void setGroupid(String groupid) {
        this.groupid = groupid;
    }

    public String getDjhBefore() {
        return djhBefore;
    }

    public void setDjhBefore(String djhBefore) {
        this.djhBefore = djhBefore;
    }

    public SSjZdbg getsSjZdbg() {
        return sSjZdbg;
    }

    public void setsSjZdbg(SSjZdbg sSjZdbg) {
        this.sSjZdbg = sSjZdbg;
    }

    public String getBglx() {
        return bglx;
    }

    public void setBglx(String bglx) {
        this.bglx = bglx;
    }

    public String getClzt() {
        return clzt;
    }

    public void setClzt(String clzt) {
        this.clzt = clzt;
    }
}
