package cn.gtmap.landtax.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 宗地变更数据
 * @author <a href="mailto:zhouzhiwei@gtmap.cn">zhouzhiwei</a>
 * @version 1.0, 2015/9/28
 */
@Entity
@Table(name = "S_SJ_ZDBG")
public class SSjZdbg {
    @Id
    @Column(name = "PROJECTID")
    private String proid; // 主键ID

    @Column
    private String bgbh; // 变更编号

    @Column
    private String djhOld; // 原地籍号

    @Column
    private String djhNew; // 新地籍号

    @Column
    private String qlrmc; // 当前权利人名称

    @Column
    private String tdzl; // 当前土地坐落

    @Column
    private BigDecimal scmj; // 当前实测面积

    @Column
    private String tdyt; // 当前土地用途代码

    @Column
    private String bgfs; // 变更方式名称

    @Column
    private Date bgrq; // 变更日期

    @Column
    private Date tsrq; // 推送日期


    public String getProid() {
        return proid;
    }

    public void setProid(String proid) {
        this.proid = proid;
    }

    public String getBgbh() {
        return bgbh;
    }

    public void setBgbh(String bgbh) {
        this.bgbh = bgbh;
    }

    public String getDjhOld() {
        return djhOld;
    }

    public void setDjhOld(String djhOld) {
        this.djhOld = djhOld;
    }

    public String getDjhNew() {
        return djhNew;
    }

    public void setDjhNew(String djhNew) {
        this.djhNew = djhNew;
    }

    public String getQlrmc() {
        return qlrmc;
    }

    public void setQlrmc(String qlrmc) {
        this.qlrmc = qlrmc;
    }

    public String getTdzl() {
        return tdzl;
    }

    public void setTdzl(String tdzl) {
        this.tdzl = tdzl;
    }

    public BigDecimal getScmj() {
        return scmj;
    }

    public void setScmj(BigDecimal scmj) {
        this.scmj = scmj;
    }

    public String getTdyt() {
        return tdyt;
    }

    public void setTdyt(String tdyt) {
        this.tdyt = tdyt;
    }

    public String getBgfs() {
        return bgfs;
    }

    public void setBgfs(String bgfs) {
        this.bgfs = bgfs;
    }

    public Date getBgrq() {
        return bgrq;
    }

    public void setBgrq(Date bgrq) {
        this.bgrq = bgrq;
    }

    public Date getTsrq() {
        return tsrq;
    }

    public void setTsrq(Date tsrq) {
        this.tsrq = tsrq;
    }
}
